package ohd.hseb.charter.parameters.panels;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.WindowConstants;

import ohd.hseb.charter.parameters.SubtitleParameters;
import ohd.hseb.charter.parameters.TitleParameters;
import ohd.hseb.hefs.utils.gui.components.BufferJPanel;
import ohd.hseb.hefs.utils.gui.tools.SwingTools;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInPanelListener;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInParameters;

public class SubtitleParametersPanel extends TitleParametersPanel implements RectangleInsetsEditingPanelListener,
ActionListener, GeneralPlugInPanelListener
{
    private static final long serialVersionUID = 1L;

    //DO NOT SET _positionChoices HERE TO ANYTHING (even null)!!! \
    //Apparently, the super constructor call sets it (via createDisplay) and setting it here would reset it.
    private JComboBox _positionChoices;

    public SubtitleParametersPanel(TitleParameters managedParameters, TitleParameters defaultParameters)
    {
        super(managedParameters, defaultParameters);
    }

    @Override
    protected void createDisplay()
    {
        super.createDisplay();
        _positionChoices = new JComboBox(SubtitleParameters.buildPositionDisplayedStrings());
        _positionChoices.addActionListener(this);

        //horizontal panel
        JPanel posPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
        posPanel.add(new JLabel("Select Position: "));
        posPanel.add(_positionChoices);

        this.remove(5);
        this.add(posPanel, SwingTools.returnGridBagConstraints(0,
                                                                  5,
                                                                  1,
                                                                  1,
                                                                  1,
                                                                  1,
                                                                  GridBagConstraints.WEST,
                                                                  GridBagConstraints.BOTH,
                                                                  new Insets(0, 0, 0, 0),
                                                                  0,
                                                                  0));
        this.add(new BufferJPanel(), SwingTools.returnGridBagConstraints(0,
                                                                            6,
                                                                            1,
                                                                            1,
                                                                            1,
                                                                            1,
                                                                            GridBagConstraints.WEST,
                                                                            GridBagConstraints.BOTH,
                                                                            new Insets(0, 0, 0, 0),
                                                                            0,
                                                                            0));
    }

    @Override
    protected void addListeners()
    {
        super.addListeners();
        this._positionChoices.addActionListener(this);
    }

    @Override
    protected void removeListeners()
    {
        super.removeListeners();
        this._positionChoices.removeActionListener(this);
    }

    @Override
    public SubtitleParameters getParameters()
    {
        return (SubtitleParameters)this.getManagedParameters();
    }

    @Override
    public SubtitleParameters getDefaults()
    {
        return (SubtitleParameters)this.getDefaultParameters();
    }

    private boolean makePositionParameterReflectPanel()
    {
        String newValue = null;
        if(_positionChoices.getSelectedIndex() > 0)
        {
            newValue = (String)_positionChoices.getSelectedItem();
        }
        if(!ohd.hseb.hefs.utils.tools.StringTools.checkForFullEqualityOfStrings(newValue,
                                                                          getParameters().getPosition(),
                                                                          false))
        {
            getParameters().setPosition(newValue);
            return true;
        }
        return false;
    }

    private void makePositionPanelReflectParameters()
    {
        this.removeListeners();
        if(this.getParameters().getPosition() == null)
        {
            this._positionChoices.setSelectedIndex(0);
        }
        else
        {
            this._positionChoices.setSelectedItem(this.getParameters().getPosition());
        }
        this.addListeners();
    }

    @Override
    protected boolean makeParametersReflectPanel()
    {
        boolean changeMade = super.makeParametersReflectPanel();
        changeMade = this.makePositionParameterReflectPanel() || changeMade;
        return changeMade;
    }

    @Override
    public void makePanelReflectParameters()
    {
        super.makePanelReflectParameters();
        this.makePositionPanelReflectParameters();
    }

    @Override
    public void disableSubPanel()
    {
        super.disableSubPanel();
        _positionChoices.setEnabled(false);
    }

    @Override
    public void enableSubPanel()
    {
        //Don't work with this for now.
    }

    @Override
    public void actionPerformed(ActionEvent e)
    {
        super.actionPerformed(e);
        if(e.getSource() == this._positionChoices)
        {
            if(makePositionParameterReflectPanel())
            {
                fireParametersChanged();
            }
            this.makePositionPanelReflectParameters();
        }
    }

    @Override
    public void parameterChanged(GeneralPlugInParameters parameters)
    {
        this.fireParametersChanged();
    }

    public static void main(String[] args)
    {
        final SubtitleParameters parms = new SubtitleParameters();
        SubtitleParameters defaultParms = new SubtitleParameters();
        defaultParms.setupDefaultParameters();
        SubtitleParametersPanel panel = new SubtitleParametersPanel(parms, defaultParms);
        JFrame display = new JFrame();
        display.setContentPane(panel);
        display.setSize(500, 800);
        display.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        display.setVisible(true);

        panel.addGraphicsGeneratorPlugInPanelListener(new GeneralPlugInPanelListener()
        {

            @Override
            public void parameterChanged(GeneralPlugInParameters parameters)
            {
                System.out.println("####>> PARAMDS -- " + parms);
            }

        });
    }
}
