package ohd.hseb.charter.parameters.panels;

import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;

import ohd.hseb.charter.parameters.SubtitleListParameters;
import ohd.hseb.charter.parameters.SubtitleParameters;
import ohd.hseb.hefs.utils.gui.jtable.TableTools;

public class SubtitleTableModel extends AbstractTableModel
{
    private static final long serialVersionUID = 1L;

    private final SubtitleListParameters _subtitles;
    private final SubtitleListParameters _defaultSubtitles;

    public SubtitleTableModel(SubtitleListParameters subtitles, SubtitleListParameters defaults)
    {
        _subtitles = subtitles;
        _defaultSubtitles = defaults;
    }

    public SubtitleParameters getSubtitleParametersForRow(int rowIndex)
    {
        if(rowIndex < _subtitles.getSubtitleCount())
        {
            return _subtitles.getSubtitle(rowIndex);
        }
        return _defaultSubtitles.getSubtitle(rowIndex - _subtitles.getSubtitleCount());
    }

    public boolean isDefault(int rowIndex)
    {
        return (rowIndex >= _subtitles.getSubtitleCount());
    }

    @Override
    public int getColumnCount()
    {
        return 2;
    }

    @Override
    public int getRowCount()
    {
        return this._subtitles.getSubtitleCount() + _defaultSubtitles.getSubtitleCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex)
    {
        if(columnIndex == 0)
        {
            if(!this.isDefault(rowIndex))
            {
                return TableTools.createDeleteIconLabel("Delete Override Threshold");
            }
            else
            {
                return new JLabel();
            }
        }
        else if(columnIndex == 1)
        {
            SubtitleParameters parms = getSubtitleParametersForRow(rowIndex);
            String text = parms.getText();
            if(text == null)
            {
                return "-undefined-";
            }

            int newLineIndex = text.indexOf('\n');
            if(newLineIndex < 0)
            {
                newLineIndex = parms.getText().length();
            }

            if(isDefault(rowIndex))
            {
                return "TEMPLATE: " + parms.getText().substring(0, newLineIndex);
            }
            return parms.getText().substring(0, newLineIndex);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col)
    {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex)
    {
        if(columnIndex == 0)
        {
            return JLabel.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col)
    {
        if(col == 0)
        {
            return "";
        }
        else if(col == 1)
        {
            return "First Line of Text";
        }
        return "UNDEFINED";
    }

}
