package ohd.hseb.charter.parameters.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.ScrollPaneConstants;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import ohd.hseb.charter.ChartParameters;
import ohd.hseb.charter.parameters.LabelChartParameters;
import ohd.hseb.hefs.utils.arguments.ArgumentInsertingTextArea;
import ohd.hseb.hefs.utils.gui.components.BufferJPanel;
import ohd.hseb.hefs.utils.gui.tools.ColorTools;
import ohd.hseb.hefs.utils.gui.tools.HSwingFactory;
import ohd.hseb.hefs.utils.gui.tools.SwingTools;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInParameters;

/**
 * Since there is no JFontChooser in javax.swing.* package. I have to create such class to choose a font
 * 
 * @author chuir
 * @author Gautam Sood
 */

public class TextFontSelectionPanel extends ChartParametersPanel
{
    private class ButtonActionListener implements ActionListener
    {
        @Override
        public void actionPerformed(final ActionEvent arg0)
        {
            if(arg0.getSource() == _fontComboBox)
            {
                if(_textArea != null)
                {
                    final Font font = _textArea.getFont();
                    _textArea.setFont(new Font(_fontComboBox.getSelectedItem().toString(),
                                               font.getStyle(),
                                               font.getSize()));
                }
            }
            else if(arg0.getSource() == _colorButton)
            {
                final Color color = ColorTools.chooseColor(_textArea, getTextAndFontModifierParameters().getColor());
                if(color != null)
                {
                    _textArea.setForeground(color);
                    setColorButton(color);
                }
            }
            else
            {
                determineSelectedFontStyleAndUpdateTextArea();
            }
            makeParametersReflectPanelAndFireParametersChangeIfNeeded();
        }
    }

    private class FontComboBoxMouseWheelListener implements MouseWheelListener
    {
        @Override
        public void mouseWheelMoved(final MouseWheelEvent arg0)
        {
            final int itemCount = _fontComboBox.getItemCount();
            if(arg0.getWheelRotation() > 0) //Mouse Wheel scrolled up
            {
                if((itemCount - 1) != _fontComboBox.getSelectedIndex())
                {
                    _fontComboBox.setSelectedIndex(_fontComboBox.getSelectedIndex() + 1);
                }
            }
            else
            {
                if(_fontComboBox.getSelectedIndex() != 0)
                {
                    _fontComboBox.setSelectedIndex(_fontComboBox.getSelectedIndex() - 1);
                }
            }
        }
    }

    private class FontRadioButtonListener implements ActionListener
    {
        @Override
        public void actionPerformed(final ActionEvent arg0)
        {
            if(_defaultFontRadioButton.isSelected())
            {
                reactToUserSelectingDefaultFont();
            }
            else
            {
                reactToUserSelectingOverrideFont();
            }
        }
    }

    private class SizeSpinnerChangeListener implements ChangeListener
    {
        @Override
        public void stateChanged(final ChangeEvent arg0)
        {
            determineSelectedFontSizeAndUpdateTextArea();
            makeParametersReflectPanelAndFireParametersChangeIfNeeded();
        }
    }

    private class SizeSpinnerMouseWheelListener implements MouseWheelListener
    {
        @Override
        public void mouseWheelMoved(final MouseWheelEvent arg0)
        {
            if(arg0.getWheelRotation() < 0) // Mouse Wheel scrolled up
            {
                if(!_sizeSpinnerModel.getMaximum().equals(_sizeSpinnerModel.getValue()))
                {
                    _sizeSpinnerModel.setValue(_sizeSpinnerModel.getNextValue());
                }
            }
            else
            {
                if(!_sizeSpinnerModel.getMinimum().equals(_sizeSpinnerModel.getValue()))
                {
                    _sizeSpinnerModel.setValue(_sizeSpinnerModel.getPreviousValue());
                }

            }
        }
    }

    private class TextAreaFocusListener implements FocusListener
    {
        @Override
        public void focusGained(final FocusEvent arg0)
        {
//            _textArea.selectAll();
        }

        @Override
        public void focusLost(final FocusEvent arg0)
        {
            makeParametersReflectPanelAndFireParametersChangeIfNeeded();
        }
    }

    private class TextRadioButtonListener implements ActionListener
    {
        @Override
        public void actionPerformed(final ActionEvent arg0)
        {
            if(_defaultTextRadioButton.isSelected())
            {
                reactToUserSelectingDefaultText();
            }
            else
            {
                reactToUserSelectingOverrideText();
            }
        }
    }

    private static final long serialVersionUID = 1L;

    public static final String PROPCHG_FONT_ALTERED = "TitleFontChangedByUser";

    public static final String PROPCHG_TEXT_ALTERED = "TitleTextChangedByUser";
    private static final String NULLSTRING = "-DEFAULT-";

    private static final Color DEFAULT_COLOR = Color.BLACK;

    public static void main(final String[] args)
    {
        final JFrame frame = new JFrame();
        frame.setPreferredSize(new Dimension(600, 350));
        frame.setMinimumSize(new Dimension(600, 350));
        final LabelChartParameters params = new LabelChartParameters();
        params.setFont(new Font("Dialog", Font.PLAIN, 18));
        params.setText("TESTING 1 2 3");
        frame.add(new TextFontSelectionPanel(params, new LabelChartParameters(), true, true));
        frame.setVisible(true);
    }

//    private boolean _ignoreComponentChanges = false;

    private final SizeSpinnerMouseWheelListener _sizeSpinnerMouseWheelListener = new SizeSpinnerMouseWheelListener();
    private final FontComboBoxMouseWheelListener _fontComboBoxMouseWheelListener = new FontComboBoxMouseWheelListener();

    /**
     * Text area show what the font look like
     */
    private ArgumentInsertingTextArea _textArea;
    /**
     * List all system available fonts
     */
    private JComboBox _fontComboBox;
    /**
     * List the an arrange of font sizes
     */
    private JSpinner _sizeSpinner;
    /**
     * The JSpinner number model
     */
    private SpinnerNumberModel _sizeSpinnerModel;
    /**
     * The font style bold, italic and plain buttons
     */
    private JToggleButton _boldButton;
    private JToggleButton _italicButton;

    /**
     * The box containers for horizontal and vertical
     */
    private JPanel _toolBar;
    private JButton _colorButton;
//    private JPanel _colorPanel = new JPanel();

    private boolean _changeFont = true;

    private boolean _changeText = true;

    private final JRadioButton _defaultFontRadioButton = new JRadioButton("Default");

    private final JRadioButton _selectedFontRadioButton = new JRadioButton("User Specified");

    private final JRadioButton _defaultTextRadioButton = new JRadioButton("Default");

    private final JRadioButton _selectedTextRadioButton = new JRadioButton("User Specified");

    private final ButtonGroup _fontRadioButtonGroup = new ButtonGroup();

    private final ButtonGroup _textRadioButtonGroup = new ButtonGroup();

    private String _textPanelBorderLabel = "Set Text";

    private String _fontPanelBorderLabel = "Set Font";

    public TextFontSelectionPanel(final GeneralPlugInParameters managedParameters,
                                  final GeneralPlugInParameters defaultParameters,
                                  final boolean changeFont,
                                  final boolean changeText)
    {
        this(managedParameters, defaultParameters, changeFont, changeText, "Select Text", "Select Font");
    }

    /**
     * Construct the font chooser with tool bar and visibility
     * 
     * @param verticalToolBar true for a vertical set of tools, false for horizontal. False is recommended.
     */
    public TextFontSelectionPanel(final GeneralPlugInParameters managedParameters,
                                  final GeneralPlugInParameters defaultParameters,
                                  final boolean changeFont,
                                  final boolean changeText,
                                  final String textPanelBorderLabel,
                                  final String fontPanelBorderLabel)
    {
        super();

        this._textPanelBorderLabel = textPanelBorderLabel;
        this._fontPanelBorderLabel = fontPanelBorderLabel;

        _changeFont = changeFont;
        _changeText = changeText;

        setDefaultParameters(defaultParameters);
        setManagedParameters(managedParameters);
        createGUI();

        addListeners();
        makePanelReflectParameters();
        setRadioButtons();
    }

//    public Color getColor()
//    {
////        return _colorPanel.getBackground();
//    }

    private void addListeners()
    {
        final ButtonActionListener bActionListener = new ButtonActionListener();

        if(_changeText)
        {
            _textArea.addFocusListener(new TextAreaFocusListener());
            // _textArea.addKeyListener(new TextAreaKeyListener());
            _defaultTextRadioButton.addActionListener(new TextRadioButtonListener());
            _selectedTextRadioButton.addActionListener(new TextRadioButtonListener());
        }
        if(_changeFont)
        {
            _sizeSpinner.addChangeListener(new SizeSpinnerChangeListener());
            _sizeSpinner.addMouseWheelListener(_sizeSpinnerMouseWheelListener);
            _fontComboBox.addActionListener(bActionListener);
            _fontComboBox.addMouseWheelListener(_fontComboBoxMouseWheelListener);
            _boldButton.addActionListener(bActionListener);
            _italicButton.addActionListener(bActionListener);
            _colorButton.addActionListener(bActionListener);
            _defaultFontRadioButton.addActionListener(new FontRadioButtonListener());
            _selectedFontRadioButton.addActionListener(new FontRadioButtonListener());
        }
    }

    public void clearTextField()
    {
        _textArea.setText("");
    }

    private void createButtons()
    {
        // Font Style
        _boldButton = new JToggleButton("<HTML><B>B</B></HTML>", false);
        _boldButton.setMnemonic(KeyEvent.VK_B);
        _boldButton.setToolTipText("Bold");
        _boldButton.setActionCommand("bold");

        _italicButton = new JToggleButton("<HTML><I>I</I></HTML>", false);
        _italicButton.setMnemonic(KeyEvent.VK_I);
        _italicButton.setToolTipText("Italic");
        _italicButton.setActionCommand("italic");

//        _colorButton = new JButton("C");
        _colorButton = new JButton(new ColorIcon(getTextAndFontModifierParameters().getColor()));
        _colorButton.setToolTipText("Change Text Color");
        _colorButton.setActionCommand("color");

        setColorButton(getTextAndFontModifierParameters().getColor());
    }

    private void createFontComboBox()
    {
        // Font list
        final GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        final String[] fontNames = ge.getAvailableFontFamilyNames();
        _fontComboBox = new JComboBox(fontNames);
        _fontComboBox.setMaximumSize(_fontComboBox.getPreferredSize());
        _fontComboBox.setMinimumSize(_fontComboBox.getPreferredSize());
        _fontComboBox.setEditable(false);
        _fontComboBox.setSelectedItem("Dialog");
        _fontComboBox.setActionCommand("changefont");
    }

    private void createFontToolbar()
    {
        createFontComboBox();
        createSizeSpinnerBox();
        createButtons();
//        _colorPanel = new JPanel();
//        _colorPanel.setPreferredSize(new Dimension(30, 30));
        final JPanel buttonPanel = new JPanel(new GridBagLayout());
        if(_changeFont)
        {
            final Insets theinsets = new Insets(0, 0, 0, 0);
//            _toolBar = Box.createHorizontalBox();
            _toolBar = new JPanel(new FlowLayout());
            _toolBar.add(_fontComboBox);
            _toolBar.add(Box.createHorizontalStrut(5));

            _toolBar.add(_sizeSpinner);
            _toolBar.add(Box.createHorizontalStrut(5));
            _toolBar.add(_boldButton);
            _toolBar.add(_italicButton);
//            _toolBar.add(Box.createHorizontalStrut(5));
            _toolBar.add(_colorButton);
//            _toolBar.add(Box.createHorizontalStrut(2) );
//            _toolBar.add(_colorPanel);
//            _colorPanel.setBackground( Color.BLUE);
            if(!_changeText)
            {
//                _toolBar.setBorder( HSwingFactory.createTitledBorder( new EtchedBorder(), "Select Font", null ) );
            }

            buttonPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(), this._fontPanelBorderLabel, null));
            _fontRadioButtonGroup.add(_defaultFontRadioButton);
            _fontRadioButtonGroup.add(_selectedFontRadioButton);
            buttonPanel.add(_defaultFontRadioButton, SwingTools.returnGridBagConstraints(0,
                                                                                         0,
                                                                                         1,
                                                                                         1,
                                                                                         1,
                                                                                         0,
                                                                                         GridBagConstraints.LINE_START,
                                                                                         GridBagConstraints.NONE,
                                                                                         theinsets,
                                                                                         0,
                                                                                         0));
            buttonPanel.add(_selectedFontRadioButton,
                            SwingTools.returnGridBagConstraints(1,
                                                                0,
                                                                1,
                                                                1,
                                                                1,
                                                                0,
                                                                GridBagConstraints.LINE_START,
                                                                GridBagConstraints.NONE,
                                                                theinsets,
                                                                0,
                                                                0));
            buttonPanel.add(_toolBar, SwingTools.returnGridBagConstraints(0,
                                                                          1,
                                                                          2,
                                                                          1,
                                                                          1,
                                                                          0,
                                                                          GridBagConstraints.LINE_START,
                                                                          GridBagConstraints.NONE,
                                                                          theinsets,
                                                                          0,
                                                                          0));
            this.add(buttonPanel, SwingTools.returnGridBagConstraints(0,
                                                                      0,
                                                                      1,
                                                                      1,
                                                                      1,
                                                                      0,
                                                                      GridBagConstraints.WEST,
                                                                      GridBagConstraints.HORIZONTAL,
                                                                      theinsets,
                                                                      0,
                                                                      0));
        }
    }

    private void createGUI()
    {
        this.setLayout(new GridBagLayout());

        createFontToolbar();
        createTextArea();

        final GridBagConstraints constraints = SwingTools.returnGridBagConstraints(0,
                                                                                   2,
                                                                                   1,
                                                                                   1,
                                                                                   1,
                                                                                   1,
                                                                                   GridBagConstraints.WEST,
                                                                                   GridBagConstraints.BOTH,
                                                                                   new Insets(0, 0, 0, 0),
                                                                                   0,
                                                                                   0);
        this.add(new BufferJPanel(), constraints);
    }

    private void createSizeSpinnerBox()
    {
        final Dimension d = new Dimension(560, 600);

        // Font size
        _sizeSpinner = new JSpinner();

        d.setSize(40, 25);
        _sizeSpinner.setMinimumSize(d);
        _sizeSpinner.setPreferredSize(d);
        _sizeSpinner.setMaximumSize(d);
        _sizeSpinnerModel = new SpinnerNumberModel(18 /* initial value */, 8 /* min */, 72 /* max */, 1 /* step */);
        _sizeSpinner.setModel(_sizeSpinnerModel);
    }

    private void createTextArea()
    {
        _textArea = new ArgumentInsertingTextArea(((ChartParameters)this.getManagedParameters()).getArguments(),
                                                  "",
                                                  4,
                                                  10);
        if(_changeText)
        {
            final JPanel textAreaPanel = new JPanel(new GridBagLayout());

            final Insets theinsets = new Insets(0, 0, 0, 0);

            //    text area in a scrollpane, needed for giant point sizes.
            //      _textArea = new JTextArea("Type a Title, select a font, size, style and color, then click a Title to be set", 4, 30);

            _textArea.setFont(new Font("Dialog", Font.PLAIN, 18));
            final JScrollPane scrollPane = new JScrollPane(_textArea,
                                                           ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED,
                                                           ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);

            scrollPane.setPreferredSize(new Dimension(300, 100));
            scrollPane.setMinimumSize(new Dimension(300, 100));

            textAreaPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(),
                                                                     this._textPanelBorderLabel,
                                                                     null));
            _textRadioButtonGroup.add(_defaultTextRadioButton);
            _textRadioButtonGroup.add(_selectedTextRadioButton);
            textAreaPanel.add(_defaultTextRadioButton,
                              SwingTools.returnGridBagConstraints(0,
                                                                  0,
                                                                  1,
                                                                  1,
                                                                  1,
                                                                  0,
                                                                  GridBagConstraints.LINE_START,
                                                                  GridBagConstraints.NONE,
                                                                  theinsets,
                                                                  0,
                                                                  0));
            textAreaPanel.add(_selectedTextRadioButton,
                              SwingTools.returnGridBagConstraints(1,
                                                                  0,
                                                                  1,
                                                                  1,
                                                                  1,
                                                                  0,
                                                                  GridBagConstraints.LINE_START,
                                                                  GridBagConstraints.NONE,
                                                                  theinsets,
                                                                  0,
                                                                  0));
            textAreaPanel.add(scrollPane, SwingTools.returnGridBagConstraints(0,
                                                                              1,
                                                                              2,
                                                                              1,
                                                                              1,
                                                                              0,
                                                                              GridBagConstraints.LINE_START,
                                                                              GridBagConstraints.HORIZONTAL,
                                                                              theinsets,
                                                                              0,
                                                                              0));

            this.add(textAreaPanel, SwingTools.returnGridBagConstraints(0,
                                                                        1,
                                                                        1,
                                                                        1,
                                                                        1,
                                                                        0,
                                                                        GridBagConstraints.WEST,
                                                                        GridBagConstraints.HORIZONTAL,
                                                                        theinsets,
                                                                        0,
                                                                        0));
        }
    }

    /**
     * Changes the size the selected text, by checking the _sizeSpinner.
     */
    private void determineSelectedFontSizeAndUpdateTextArea()
    {
        final float fontSize = getSelectedFontSize();
        final Font font = _textArea.getFont().deriveFont(fontSize);
        _textArea.setFont(font);
    }

    /**
     * Changes the style (Bold, Italic ) of the selected text by checking the style buttons
     */
    private void determineSelectedFontStyleAndUpdateTextArea()
    {
        Font selectedFont = _textArea.getFont();
        if((_boldButton.isSelected()) && (_italicButton.isSelected()))
        {
            selectedFont = _textArea.getFont().deriveFont(Font.BOLD + Font.ITALIC);
        }
        else if((!_boldButton.isSelected()) && (_italicButton.isSelected()))
        {
            selectedFont = _textArea.getFont().deriveFont(Font.ITALIC);
        }
        else if((_boldButton.isSelected()) && (!_italicButton.isSelected()))
        {
            selectedFont = _textArea.getFont().deriveFont(Font.BOLD);
        }
        else if((!_boldButton.isSelected()) && (!_italicButton.isSelected()))
        {
            selectedFont = _textArea.getFont().deriveFont(Font.PLAIN);
        }
        _textArea.setFont(selectedFont);
    }

    public void disableDefaultButtons()
    {
        _defaultFontRadioButton.setVisible(false);
        _defaultTextRadioButton.setVisible(false);
        _selectedFontRadioButton.setSelected(true);
        _selectedTextRadioButton.setSelected(true);
        reactToUserSelectingOverrideFont();
        reactToUserSelectingOverrideText();
    }

    @Override
    public void disableSubPanel()
    {
        _defaultFontRadioButton.setEnabled(false);
        _defaultTextRadioButton.setEnabled(false);
        _selectedFontRadioButton.setEnabled(false);
        _selectedTextRadioButton.setEnabled(false);

        _toolBar.setEnabled(false);
        _fontComboBox.setEnabled(false);
        _sizeSpinner.setEnabled(false);
        _boldButton.setEnabled(false);
        _italicButton.setEnabled(false);
        _colorButton.setEnabled(false);
        _textArea.setEnabled(false);
    }

    @Override
    public void enableSubPanel()
    {
    }

//    private int getFontStyleFromPanel()
//    {
//        int fontStyle = 0;
//
//        if((_boldButton.isSelected()) && (_italicButton.isSelected()))
//        {
//            fontStyle = Font.BOLD + Font.ITALIC;
//        }
//        else if((!_boldButton.isSelected()) && (_italicButton.isSelected()))
//        {
//            fontStyle = Font.ITALIC;
//        }
//        else if((_boldButton.isSelected()) && (!_italicButton.isSelected()))
//        {
//            fontStyle = Font.BOLD;
//        }
//        else if((!_boldButton.isSelected()) && (!_italicButton.isSelected()))
//        {
//            fontStyle = Font.PLAIN;
//        }
//
//        return fontStyle;
//    }

    public String getFontNameFromPanel()
    {
        return _fontComboBox.getSelectedItem().toString();
    }

    private TextFontSelectionPanel getPanel()
    {
        return this;
    }

    public int getSelectedFontSize()
    {
        return ((Number)(_sizeSpinnerModel.getValue())).intValue();
    }

    public LabelChartParameters getTextAndFontModifierParameters()
    {
        return (LabelChartParameters)getManagedParameters();
    }

    public Color getTextFieldColor()
    {
        return _textArea.getForeground();
    }

    public Font getTextFieldFont()
    {
        return _textArea.getFont();
    }

    public String getTextFieldText()
    {
        return _textArea.getText();
    }

    public boolean isBold()
    {
        return _boldButton.isSelected();
    }

    public boolean isDefaultFontSelected()
    {
        return _defaultFontRadioButton.isSelected();
    }

    public boolean isDefaultTextSelected()
    {
        return _defaultTextRadioButton.isSelected();
    }

    public boolean isItalic()
    {
        return _italicButton.isSelected();
    }

    public boolean isPlain()
    {
        return (!isBold() && !isItalic());
    }

    @Override
    public void makePanelReflectParameters()
    {
        final LabelChartParameters params = getTextAndFontModifierParameters();
        final LabelChartParameters defaultParms = (LabelChartParameters)this.getDefaultParameters();

        String defaultText = "-none-";
        if(defaultParms != null)
        {
            defaultText = defaultParms.getText();
        }

        if(_changeText)
        {
            _defaultTextRadioButton.removeActionListener(_defaultTextRadioButton.getActionListeners()[0]);
            _selectedTextRadioButton.removeActionListener(_selectedTextRadioButton.getActionListeners()[0]);
            if(params.getText() == null)
            {
                _defaultTextRadioButton.setSelected(true);
                setTextFieldText(defaultText);
            }
            else
            {
                _selectedTextRadioButton.setSelected(true);
                setTextFieldText(params.getText());
            }
            _defaultTextRadioButton.addActionListener(new TextRadioButtonListener());
            _selectedTextRadioButton.addActionListener(new TextRadioButtonListener());
        }

        Font defaultFont = new Font("SanSerif", Font.PLAIN, 12);
        if(defaultParms != null)
        {
            defaultFont = defaultParms.getFont();
        }

        if(_changeFont)
        {
            _defaultFontRadioButton.removeActionListener(_defaultFontRadioButton.getActionListeners()[0]);
            _selectedFontRadioButton.removeActionListener(_selectedFontRadioButton.getActionListeners()[0]);
            _fontComboBox.removeActionListener(_fontComboBox.getActionListeners()[0]);
            _boldButton.removeActionListener(_boldButton.getActionListeners()[0]);
            _italicButton.removeActionListener(_italicButton.getActionListeners()[0]);
            _colorButton.removeActionListener(_colorButton.getActionListeners()[0]);

            if(params.getFont() == null)
            {
                _defaultFontRadioButton.setSelected(true);
                setChosenFont(defaultFont);
            }
            else
            {
                _selectedFontRadioButton.setSelected(true);
                setChosenFont(params.getFont());
            }

            Color color = params.getColor();
            if(color == null)
            {
                color = DEFAULT_COLOR;
            }
            setButtonIconColor(color);
            _textArea.setForeground(color);

            final ButtonActionListener bActionListener = new ButtonActionListener();
            _fontComboBox.addActionListener(bActionListener);
            _boldButton.addActionListener(bActionListener);
            _italicButton.addActionListener(bActionListener);
            _colorButton.addActionListener(bActionListener);
            _defaultFontRadioButton.addActionListener(new FontRadioButtonListener());
            _selectedFontRadioButton.addActionListener(new FontRadioButtonListener());
        }
    }

    private void reactToUserSelectingDefaultFont()
    {
        _toolBar.setEnabled(false);
        _fontComboBox.setEnabled(false);
        _sizeSpinner.setEnabled(false);
        _boldButton.setEnabled(false);
        _italicButton.setEnabled(false);
        _colorButton.setEnabled(false);

        _sizeSpinner.removeMouseWheelListener(_sizeSpinnerMouseWheelListener);
        _fontComboBox.removeMouseWheelListener(_fontComboBoxMouseWheelListener);

        makeParametersReflectPanelAndFireParametersChangeIfNeeded();
        makePanelReflectParameters();
    }

    private void reactToUserSelectingDefaultText()
    {
        _textArea.setEnabled(false);
        makeParametersReflectPanelAndFireParametersChangeIfNeeded();
        makePanelReflectParameters();
        getPanel().fireParametersChanged();
    }

    private void reactToUserSelectingOverrideFont()
    {
        _toolBar.setEnabled(true);
        _fontComboBox.setEnabled(true);
        _sizeSpinner.setEnabled(true);
        _boldButton.setEnabled(true);
        _italicButton.setEnabled(true);
        _colorButton.setEnabled(true);

        _sizeSpinner.addMouseWheelListener(_sizeSpinnerMouseWheelListener);
        _fontComboBox.addMouseWheelListener(_fontComboBoxMouseWheelListener);

        makeParametersReflectPanelAndFireParametersChangeIfNeeded();
    }

    private void reactToUserSelectingOverrideText()
    {
        _textArea.setEnabled(true);
        makeParametersReflectPanelAndFireParametersChangeIfNeeded();
        makePanelReflectParameters();
    }

    /**
     * Set bold face button
     * 
     * @param b true or false
     */
    public void setBold(final boolean b)
    {
        _boldButton.setSelected(b);
    }

    private void setButtonIconColor(final Color color)
    {
        if(_colorButton != null)
        {
            _colorButton.setIcon(new ColorIcon(color));
        }
    }

    public void setChosenColor(final Color color)
    {
        if(color != null)
        {
            _textArea.setForeground(color);
        }
    }

    /**
     * Set the font to font chooser
     * 
     * @param font
     */
    public void setChosenFont(final Font font)
    {
        if(font != null)
        {
            setFontFamily(font.getFamily());
            setSelectedSize(font.getSize());

            setBold(font.isBold());
            setItalic(font.isItalic());
//
//            if(font.isBold() && !font.isItalic())
//            {
//                setBold(true);
//                setItalic(false);
//            }
//            else if(!font.isBold() && font.isItalic())
//            {
//                setItalic(true);
//                setBold(false);
//            }
//            else if(font.isBold() && font.isItalic())
//            {
//                setBold(true);
//                setItalic(true);
//            }
//            else if(!font.isBold() && !font.isItalic())
//            {
//                setBold(false);
//                setItalic(false);
//            }

            if(_textArea != null)
            {
                _textArea.setFont(font);
            }
        }
    }

    private void setColorButton(final Color color)
    {
        if(color != null)
        {
            _colorButton.setIcon(new ColorIcon(color));
        }
        else
        {
            setButtonIconColor(DEFAULT_COLOR);
        }
    }

    public void setDefaultFontRadioButton(final boolean defaultSelected)
    {
        if(defaultSelected)
        {
            _defaultFontRadioButton.setSelected(true);
            reactToUserSelectingDefaultFont();
        }
        else
        {
            _selectedFontRadioButton.setSelected(true);
            reactToUserSelectingOverrideFont();
        }
    }

    public void setDefaultTextRadioButton(final boolean defaultSelected)
    {
        if(defaultSelected)
        {
            _defaultTextRadioButton.setSelected(true);
            reactToUserSelectingDefaultText();
        }
        else
        {
            _selectedTextRadioButton.setSelected(true);
            reactToUserSelectingOverrideText();
        }
    }

//    private class TextAreaKeyListener implements KeyListener
//    {
//        public void keyPressed(KeyEvent e)
//        {
//            getPanel().fireParametersChanged();
//        }
//
//        public void keyReleased(KeyEvent e)
//        {
//        }
//
//        public void keyTyped(KeyEvent e)
//        {
//            getPanel().fireParametersChanged();
//        }
//    }

    public void setFontFamily(final String s)
    {
        _fontComboBox.setSelectedItem(s);
    }

    public void setItalic(final boolean b)
    {
        _italicButton.setSelected(b);
    }

    private void setRadioButtons()
    {
        if(_changeText)
        {
            if(this.getTextAndFontModifierParameters().getText() != null)
            {
                _selectedTextRadioButton.setSelected(true);
                _textArea.setEnabled(true);
            }
            else
            {
                _defaultTextRadioButton.setSelected(true);
                _textArea.setEnabled(false);
            }
        }
        if(_changeFont)
        {
            if(this.getTextAndFontModifierParameters().getFont() != null)
            {
                _selectedFontRadioButton.setSelected(true);
                reactToUserSelectingOverrideFont();
            }
            else
            {
                _defaultFontRadioButton.setSelected(true);
                reactToUserSelectingDefaultFont();
            }
        }
    }

    public void setSelectedSize(final int number)
    {
        _sizeSpinnerModel.setValue((Integer.valueOf(number)));
    }

    public void setTextFieldText(final String str)
    {
        //The test field should not show any html tags.  Replace them.
        String s = NULLSTRING;
        if(str != null)
        {
            s = str;
            s = s.replaceAll("<html>", "");
            s = s.replaceAll("<br>", "\n");
            s = s.replaceAll("</html>", "");
        }

        _textArea.setText(s);
    }

    protected void makeParametersReflectPanelAndFireParametersChangeIfNeeded()
    {
        if(makeParametersReflectPanel())
        {
            this.fireParametersChanged();
        }
    }

    protected boolean makeParametersReflectPanel()
    {
        boolean changeMade = false;
        if(_changeFont)
        {
            Font newFont = null;
            Color newColor = null;
            if(this._selectedFontRadioButton.isSelected())
            {
                newFont = _textArea.getFont();
                newColor = ((ColorIcon)this._colorButton.getIcon()).getColor();
            }

            if(!ohd.hseb.hefs.utils.tools.GeneralTools.checkForFullEqualityOfObjects(getTextAndFontModifierParameters().getFont(),
                                                                                     newFont))
            {
                getTextAndFontModifierParameters().setFont(newFont);
                changeMade = true;
            }
            if(!ohd.hseb.hefs.utils.tools.GeneralTools.checkForFullEqualityOfObjects(getTextAndFontModifierParameters().getColor(),
                                                                                     newColor))
            {
                getTextAndFontModifierParameters().setColor(newColor);
                changeMade = true;
            }
        }

        if(_changeText)
        {
            String newText = null;
            if(this._selectedTextRadioButton.isSelected())
            {
                newText = _textArea.getText();
            }

            if(!ohd.hseb.hefs.utils.tools.StringTools.checkForFullEqualityOfStrings(getTextAndFontModifierParameters().getText(),
                                                                                    newText,
                                                                                    true))
            {
                getTextAndFontModifierParameters().setText(newText);
                changeMade = true;
            }
        }

        return changeMade;
    }
}
