package ohd.hseb.charter.parameters.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;

import ohd.hseb.charter.ChartEngineException;
import ohd.hseb.charter.ChartTools;
import ohd.hseb.charter.ChartConstants;
import ohd.hseb.charter.parameters.LabelChartParameters;
import ohd.hseb.charter.parameters.ThresholdParameters;
import ohd.hseb.hefs.utils.arguments.ArgumentInsertingTextField;
import ohd.hseb.hefs.utils.arguments.ArgumentInsertingTextFieldComboBoxEditor;
import ohd.hseb.hefs.utils.arguments.ArgumentsProcessor;
import ohd.hseb.hefs.utils.datetime.DateComboGenericParameterPanel;
import ohd.hseb.hefs.utils.datetime.HEFSDateTools;
import ohd.hseb.hefs.utils.gui.tools.ColorTools;
import ohd.hseb.hefs.utils.gui.tools.ComponentHelper;
import ohd.hseb.hefs.utils.gui.tools.DialogHelper;
import ohd.hseb.hefs.utils.gui.tools.HSwingFactory;
import ohd.hseb.hefs.utils.gui.tools.SwingTools;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInPanelListener;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInParameters;
import ohd.hseb.hefs.utils.plugins.GenericParameterList;

/**
 * @author Gautam
 */
public class ThresholdParameterPanel extends ChartParametersPanel implements GeneralPlugInPanelListener
{
    private class ColorButtonActionListener implements ActionListener
    {
        private final Component _parent;

        public ColorButtonActionListener(final Component parent)
        {
            _parent = parent;
        }

        @Override
        public void actionPerformed(final ActionEvent arg0)
        {
            Color color = getOverRideParameters().getColor();
            color = ColorTools.chooseColor(_parent, color);
            if(color != null)
            {
                getOverRideParameters().setColor(color);
            }
            updateColorPanel();
            makeParametersReflectPanel();
            fireParametersChanged();
        }
    }

    private class ColorRadioButtonListener implements ActionListener
    {
        private boolean __defaultValue = true;

        public ColorRadioButtonListener(final boolean defaultValue)
        {
            __defaultValue = defaultValue;
        }

        @Override
        public void actionPerformed(final ActionEvent arg0)
        {
            setColorButton(__defaultValue);
            makeParametersReflectPanel();
            fireParametersChanged();
        }
    }

    private class ComboBoxListener implements ActionListener
    {
        @Override
        public void actionPerformed(final ActionEvent e)
        {
            enableDisableNumericalDateAxisValuePanel();
            makeParametersReflectPanel();
            fireParametersChanged();
        }
    }

    private class DateCheckBoxListener implements ActionListener
    {
        @Override
        public void actionPerformed(final ActionEvent e)
        {
            enableDisableDatePanels();
            makeParametersReflectPanel();
            fireParametersChanged();
        }
    }

    private class IdentifierTextFieldFocusListener implements FocusListener
    {
        @Override
        public void focusGained(final FocusEvent arg0)
        {
        }

        @Override
        public void focusLost(final FocusEvent arg0)
        {
            final String unevaluatedId = _identifierTextField.getText().trim();
            _listener.reactToIdentifierChange(getOverRideParameters(), unevaluatedId);
//            _identifierTextField.removeKeyListener( _identifierTextFieldKeyListener );
//            String unevaluatedId = _identifierTextField.getText().trim();
//            String evaluatedId = getOverRideParameters().getArguments()
//                                                        .replaceArgumentsInString(_identifierTextField.getText().trim());
//            if(!evaluatedId.isEmpty())
//            {
//                _listener.reactToIdentifierChange(getOverRideParameters(), unevaluatedId);
//            }
//            else
//            {
//                DialogHelper.displayErrorDialog(null,
//                                                "Identifier cannot be empty when arguments are evaluated.\nMake sure the needed argument is defined",
//                                                "Empty Identifier");
//                _identifierTextField.setText(getOverRideParameters().getIdentifier());
//            }
//            _identifierTextField.addKeyListener( _identifierTextFieldKeyListener );
        }
    }

    private class IdentifierTextFieldActionListener implements ActionListener
    {
        @Override
        public void actionPerformed(final ActionEvent e)
        {
            _identifierTextField.removeFocusListener(_identifierTextFieldFocusListener);
            final String unevaluatedId = _identifierTextField.getText().trim();

            final String evaluatedIdentifierString = getOverRideParameters().getArguments()
                                                                            .replaceArgumentsInString(_identifierTextField.getText()
                                                                                                                          .trim());
            if(!evaluatedIdentifierString.isEmpty())
            {
                _listener.reactToIdentifierChange(getOverRideParameters(), unevaluatedId);
            }
            else
            {
                DialogHelper.displayErrorDialog(null,
                                                "Identifier cannot be empty when arguments are evaluated.\nMake sure the needed argument is defined",
                                                "Empty Identifier");
                _identifierTextField.addFocusListener(_identifierTextFieldFocusListener);
                _identifierTextField.setText(getOverRideParameters().getIdentifier());
            }

            _identifierTextField.addFocusListener(_identifierTextFieldFocusListener);
        }
    }

//    private class IdentifierTextFieldKeyListener implements KeyListener
//    {
//        public void keyPressed(KeyEvent e)
//        {
//        }
//
//        public void keyReleased(KeyEvent e)
//        {
//            if(e.getKeyCode() == 10)
//            {
//                _identifierTextField.removeFocusListener(_identifierTextFieldFocusListener);
//                String unevaluatedId = _identifierTextField.getText().trim();
//
//                String evaluatedIdentifierString = getOverRideParameters().getArguments()
//                                                                          .replaceArgumentsInString(_identifierTextField.getText()
//                                                                                                                        .trim());
//                if(!evaluatedIdentifierString.isEmpty())
//                {
//                    _listener.reactToIdentifierChange(getOverRideParameters(), unevaluatedId);
//                }
//                else
//                {
//                    _identifierTextField.removeFocusListener(_identifierTextFieldFocusListener);
//                    DialogHelper.displayErrorDialog(null,
//                                                    "Identifier cannot be empty when arguments are evaluated.\nMake sure the needed argument is defined",
//                                                    "Empty Identifier");
//                    _identifierTextField.addFocusListener(_identifierTextFieldFocusListener);
//                    _identifierTextField.setText(getOverRideParameters().getIdentifier());
//                }
//
//                _identifierTextField.addFocusListener(_identifierTextFieldFocusListener);
//            }
//        }
//
//        public void keyTyped(KeyEvent e)
//        {
//        }
//    }

    private class LineWidthRadioButtonListener implements ActionListener
    {
        private boolean __defaultValue = true;

        public LineWidthRadioButtonListener(final boolean defaultValue)
        {
            __defaultValue = defaultValue;
        }

        @Override
        public void actionPerformed(final ActionEvent e)
        {
            setLineWidthRadioButton(__defaultValue);
            makeParametersReflectPanel();
            fireParametersChanged();
        }
    }

    private class NumericalAxisValueEndRadioButtonListener implements ActionListener
    {
        private boolean __defaultValue = true;

        public NumericalAxisValueEndRadioButtonListener(final boolean defaultValue)
        {
            __defaultValue = defaultValue;
        }

        @Override
        public void actionPerformed(final ActionEvent arg0)
        {
            setNumericalAxisValueEndRadioButton(__defaultValue);
            makeParametersReflectPanel();
            fireParametersChanged();
        }
    }

    private class NumericalAxisValueStartRadioButtonListener implements ActionListener
    {
        private boolean __defaultValue = true;

        public NumericalAxisValueStartRadioButtonListener(final boolean defaultValue)
        {
            __defaultValue = defaultValue;
        }

        @Override
        public void actionPerformed(final ActionEvent arg0)
        {
            setNumericalAxisValueStartRadioButton(__defaultValue);
            makeParametersReflectPanel();
            fireParametersChanged();
        }
    }

    private class NumericalDateComboBoxListener implements ItemListener
    {
        @Override
        public void itemStateChanged(final ItemEvent e)
        {
            if(e.getStateChange() == ItemEvent.SELECTED)
            {
                makeParametersReflectPanel();
                fireParametersChanged();
            }
        }
    }

    private class TextFieldFocusListener implements FocusListener
    {
        @Override
        public void focusGained(final FocusEvent arg0)
        {
        }

        @Override
        public void focusLost(final FocusEvent arg0)
        {
            makeParametersReflectPanel();
            fireParametersChanged();
        }
    }

    private class TextFieldKeyListener implements KeyListener
    {
        @Override
        public void keyPressed(final KeyEvent e)
        {
        }

        @Override
        public void keyReleased(final KeyEvent e)
        {
            if(e.getKeyCode() == 10)
            {
                makeParametersReflectPanel();
                fireParametersChanged();
            }
        }

        @Override
        public void keyTyped(final KeyEvent e)
        {
        }
    }

    private class ZoneComboBoxListener implements ActionListener
    {
        @Override
        public void actionPerformed(final ActionEvent e)
        {
            makeParametersReflectPanel();
            fireParametersChanged();
        }
    }

    private static final long serialVersionUID = 1L;

    private final ThresholdParameters _defaultThresholdParameters;
    private HashMap<Integer, int[]> _subPlotIndexToRangeAxisTypes = null;
    private final int _xAxisType;
    private final boolean _isNew;

    //Identifier
    private final ArgumentInsertingTextField _identifierTextField;
    private JPanel _identifierTextBox = null;

    //Visibility
    private final static String[] DEFAULT_YES_VISIBLE_CHOICES = {"Default (Yes)", "Yes", "No"};
    private final static String[] DEFAULT_NO_VISIBLE_CHOICES = {"Default (No)", "Yes", "No"};
    private final static String[] NEW_VISIBLE_CHOICES = {"Yes", "No"};
    private JComboBox _visibleComboBox;
    private JPanel _visibleComboBoxPanel = null;

    //does include threshold in calculating axis limits
    private final static String[] DEFAULT_YES_INCLUDE_IN_AXIS_LIMITS_CHOICES = {"Default (Yes)", "Yes", "No"};
    private final static String[] DEFAULT_NO_INCLUDE_IN_AXIS_LIMITS_CHOICES = {"Default (No)", "Yes", "No"};
    private final static String[] NEW_INCLUDE_IN_AXIS_LIMITS_CHOICES = {"Yes", "No"};
    private JComboBox _includeInAxisLimitsComboBox;
    private JPanel _includeInAxisLimitsComboBoxPanel = null;

    //isZone
    private final static String[] DEFAULT_YES_ZONE_CHOICES = {"Default (Yes)", "Yes", "No"};
    private final static String[] DEFAULT_NO_ZONE_CHOICES = {"Default (No)", "Yes", "No"};
    private final static String[] NEW_ZONE_CHOICES = {"Yes", "No"};
    private JComboBox _zoneComboBox;
    private JPanel _zoneComboBoxPanel = null;

    //Label
    private TextFontSelectionPanel _labelParametersPanel = null;

    //Color
    private final JPanel _colorButtonPanel = new JPanel(new GridBagLayout());
    private final JRadioButton _defaultColorRadioButton = new JRadioButton("Default");
    private final JRadioButton _selectedColorRadioButton = new JRadioButton("User Specified");

    private final ButtonGroup _colorRadioButtonGroup = new ButtonGroup();
    private final JButton _colorButton = new JButton();

    //used for JFormattedTextFields
    private static final String _decimalFormatString = "00.00";
    private final DecimalFormat _decimalFormat = new DecimalFormat(_decimalFormatString);

    //Line width
    private final JRadioButton _defaultLineWidthRadioButton = new JRadioButton("Default");
    private final JRadioButton _selectedLineWidthRadioButton = new JRadioButton("User Specified");
    private final ButtonGroup _lineWidthRadioButtonGroup = new ButtonGroup();
    private final JFormattedTextField _lineWidthTextField = new JFormattedTextField(_decimalFormat);
    private final JPanel _lineWidthPanel = new JPanel(new GridBagLayout());

    //Subplot index
    private final JComboBox _subPlotIndexComboBox = new JComboBox();
    private JPanel _subPlotIndexComboBoxPanel = null;

    //Axis id string
    private final JComboBox _axisIdStringComboBox = new JComboBox();
    private JPanel _axisIdStringComboBoxPanel = null;

    //Numerical axis values, start and end
    private final JPanel _numericalAxisValueStartPanel = new JPanel(new GridBagLayout());
    private final JRadioButton _defaultNumericalAxisValueStartRadioButton = new JRadioButton("Default");
    private final JRadioButton _selectedNumericalAxisValueStartRadioButton = new JRadioButton("User Specified");
    private final ButtonGroup _numericalAxisValueStartButtonGroup = new ButtonGroup();
    private final JComboBox _numericalAxisValueStartComboBox = new JComboBox();
    private final JPanel _numericalAxisValueEndPanel = new JPanel(new GridBagLayout());
    private final JRadioButton _defaultNumericalAxisValueEndRadioButton = new JRadioButton("Default");
    private final JRadioButton _selectedNumericalAxisValueEndRadioButton = new JRadioButton("User Specified");
    private final ButtonGroup _numericalAxisValueEndButtonGroup = new ButtonGroup();
    private final JComboBox _numericalAxisValueEndComboBox = new JComboBox();

    //Date axis values, start and end
    private final JCheckBox _unboundDateValueStartCheckBox = new JCheckBox("Unbounded");
    private DateComboGenericParameterPanel _dateAxisValueStartComboGenericPanel;
    private JPanel _dateAxisValueStartPanel = null;
    private final JCheckBox _unboundDateValueEndCheckBox = new JCheckBox("Unbounded");
    private DateComboGenericParameterPanel _dateAxisValueEndComboGenericPanel;
    private JPanel _dateAxisValueEndPanel = null;

    //Label Anchor
    public static final String[] DISPLAYED_ANCHOR_LIST = {"Default (auto)", ThresholdParameters.LABEL_ANCHOR_ARRAY[0],
        ThresholdParameters.LABEL_ANCHOR_ARRAY[1], ThresholdParameters.LABEL_ANCHOR_ARRAY[2],
        ThresholdParameters.LABEL_ANCHOR_ARRAY[3], ThresholdParameters.LABEL_ANCHOR_ARRAY[4]};
    public static final String[] DISPLAYED_NEW_ANCHOR_LIST = {ThresholdParameters.LABEL_ANCHOR_ARRAY[0],
        ThresholdParameters.LABEL_ANCHOR_ARRAY[1], ThresholdParameters.LABEL_ANCHOR_ARRAY[2],
        ThresholdParameters.LABEL_ANCHOR_ARRAY[3], ThresholdParameters.LABEL_ANCHOR_ARRAY[4]};
    private JPanel _labelAnchorComboBoxPanel = null;
    private JComboBox _labelAnchorComboBox;

    //Many, many listeners.
    private ThresholdParameterPanelListener _listener = null;
    private final TextFieldFocusListener _textFieldFocusListener = new TextFieldFocusListener();
    private final IdentifierTextFieldFocusListener _identifierTextFieldFocusListener = new IdentifierTextFieldFocusListener();
    private final TextFieldKeyListener _textFieldKeyListener = new TextFieldKeyListener();
    private final IdentifierTextFieldActionListener _identifierTextFieldActionListener = new IdentifierTextFieldActionListener();
    private final ComboBoxListener _comboBoxListener = new ComboBoxListener();
    private final NumericalDateComboBoxListener _numericalAxisValueComboBoxListener = new NumericalDateComboBoxListener();
    private final ZoneComboBoxListener _zoneComboBoxListener = new ZoneComboBoxListener();
    private final ColorButtonActionListener _colorButtonActionListener = new ColorButtonActionListener(this);
    private final ColorRadioButtonListener _defaultColorRadioButtonListener = new ColorRadioButtonListener(true);
    private final ColorRadioButtonListener _selectedColorRadioButtonListener = new ColorRadioButtonListener(false);
    private final LineWidthRadioButtonListener _defaultLineWidthRadioButtonListener = new LineWidthRadioButtonListener(true);
    private final LineWidthRadioButtonListener _selectedLineWidthRadioButtonListener = new LineWidthRadioButtonListener(false);
    private final NumericalAxisValueStartRadioButtonListener _defaultNumericalAxisValueStartRadioButtonListener = new NumericalAxisValueStartRadioButtonListener(true);
    private final NumericalAxisValueStartRadioButtonListener _selectedNumericalAxisValueStartRadioButtonListener = new NumericalAxisValueStartRadioButtonListener(false);
    private final NumericalAxisValueEndRadioButtonListener _defaultNumericalAxisValueEndRadioButtonListener = new NumericalAxisValueEndRadioButtonListener(true);
    private final NumericalAxisValueEndRadioButtonListener _selectedNumericalAxisValueEndRadioButtonListener = new NumericalAxisValueEndRadioButtonListener(false);
    private final DateCheckBoxListener _dateCheckBoxListener = new DateCheckBoxListener();

    /**
     * @param defaultParameters - Default ThresholdParameters
     * @param overRideParameters - Override ThresholdParameters
     * @param isNew - boolean. True if a new ThresholdParameter, else false
     * @param subPlotIndexToRangeAxisTypes - SubPlotIndex to RangeAxisType Hashmap
     * @param xAxisType - XAxis type
     */
    public ThresholdParameterPanel(final ThresholdParameterPanelListener listener,
                                   final ThresholdParameters defaultParameters,
                                   final ThresholdParameters overRideParameters,
                                   final boolean isNew,
                                   final HashMap<Integer, int[]> subPlotIndexToRangeAxisTypes,
                                   final int xAxisType)

    {
        _listener = listener;
        _defaultThresholdParameters = defaultParameters;
        setManagedParameters(overRideParameters);
        _isNew = isNew;

        _subPlotIndexToRangeAxisTypes = subPlotIndexToRangeAxisTypes;
        _xAxisType = xAxisType;

        if(getOverRideParameters() != null)
        {
            _identifierTextField = new ArgumentInsertingTextField(getOverRideParameters().getArguments(), "");
        }
        else
        {
            _identifierTextField = new ArgumentInsertingTextField(_defaultThresholdParameters.getArguments(), "");
        }

        createGUI();
        this.makePanelReflectParameters();
    }

    private void addListeners()
    {
        _colorButton.addActionListener(_colorButtonActionListener);
        _defaultColorRadioButton.addActionListener(_defaultColorRadioButtonListener);
        _selectedColorRadioButton.addActionListener(_selectedColorRadioButtonListener);
        _defaultLineWidthRadioButton.addActionListener(_defaultLineWidthRadioButtonListener);
        _selectedLineWidthRadioButton.addActionListener(_selectedLineWidthRadioButtonListener);
        _defaultNumericalAxisValueStartRadioButton.addActionListener(_defaultNumericalAxisValueStartRadioButtonListener);
        _selectedNumericalAxisValueStartRadioButton.addActionListener(_selectedNumericalAxisValueStartRadioButtonListener);
        _defaultNumericalAxisValueEndRadioButton.addActionListener(_defaultNumericalAxisValueEndRadioButtonListener);
        _selectedNumericalAxisValueEndRadioButton.addActionListener(_selectedNumericalAxisValueEndRadioButtonListener);

        _numericalAxisValueStartComboBox.addItemListener(_numericalAxisValueComboBoxListener);
        _numericalAxisValueEndComboBox.addItemListener(_numericalAxisValueComboBoxListener);
        _lineWidthTextField.addFocusListener(_textFieldFocusListener);
        _identifierTextField.addFocusListener(_identifierTextFieldFocusListener);
        _labelParametersPanel.addGraphicsGeneratorPlugInPanelListener(this);
        _dateAxisValueStartComboGenericPanel.addGraphicsGeneratorPlugInPanelListener(this);
        _dateAxisValueEndComboGenericPanel.addGraphicsGeneratorPlugInPanelListener(this);
        _unboundDateValueStartCheckBox.addActionListener(_dateCheckBoxListener);
        _unboundDateValueEndCheckBox.addActionListener(_dateCheckBoxListener);

        _identifierTextField.addActionListener(_identifierTextFieldActionListener);
        _lineWidthTextField.addKeyListener(_textFieldKeyListener);

        _subPlotIndexComboBox.addActionListener(_comboBoxListener);
        _axisIdStringComboBox.addActionListener(_comboBoxListener);
        _zoneComboBox.addActionListener(_zoneComboBoxListener);
        _visibleComboBox.addActionListener(_comboBoxListener);
        _includeInAxisLimitsComboBox.addActionListener(_comboBoxListener);
        _labelAnchorComboBox.addActionListener(_comboBoxListener);
    }

    /**
     * Create the GUI
     */
    private void createGUI()
    {
        this.setLayout(new GridBagLayout());
        _identifierTextField.setColumns(40);
        _identifierTextBox = new JPanel(new BorderLayout());
        _identifierTextBox.add(new JLabel("Identifier:"), BorderLayout.WEST);
        _identifierTextBox.add(_identifierTextField, BorderLayout.CENTER);
        //_identifierTextBox = HSwingFactory.createLabeledJTextField(new JLabel("Identifier:"), _identifierTextField);
        if(_defaultThresholdParameters != null)
        {
            _labelParametersPanel = new TextFontSelectionPanel(getOverRideParameters().getLabel(),
                                                               _defaultThresholdParameters.getLabel(),
                                                               true,
                                                               true);
        }
        else
        {
            _labelParametersPanel = new TextFontSelectionPanel(getOverRideParameters().getLabel(), null, true, true);
        }
        if(_isNew)
        {
            _labelParametersPanel.disableDefaultButtons();
        }

        GridBagConstraints constraints = SwingTools.returnGridBagConstraints(0,
                                                                             0,
                                                                             1,
                                                                             1,
                                                                             1,
                                                                             0,
                                                                             GridBagConstraints.NORTHWEST,
                                                                             GridBagConstraints.HORIZONTAL,
                                                                             new Insets(4, 5, 2, 2),
                                                                             0,
                                                                             0);

        this.add(_identifierTextBox, constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.NORTHWEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);

        if(_isNew)
        {
            _visibleComboBox = new JComboBox(NEW_VISIBLE_CHOICES);
            _zoneComboBox = new JComboBox(NEW_ZONE_CHOICES);
            _includeInAxisLimitsComboBox = new JComboBox(NEW_INCLUDE_IN_AXIS_LIMITS_CHOICES);
        }
        else
        {
            if(_defaultThresholdParameters.getIsZone())
            {
                _zoneComboBox = new JComboBox(DEFAULT_YES_ZONE_CHOICES);
            }
            else
            {
                _zoneComboBox = new JComboBox(DEFAULT_NO_ZONE_CHOICES);
            }
            if(_defaultThresholdParameters.getVisible())
            {
                _visibleComboBox = new JComboBox(DEFAULT_YES_VISIBLE_CHOICES);
            }
            else
            {
                _visibleComboBox = new JComboBox(DEFAULT_NO_VISIBLE_CHOICES);
            }
            if(_defaultThresholdParameters.getIncludeInAxisLimitsComputation())
            {
                _includeInAxisLimitsComboBox = new JComboBox(DEFAULT_YES_INCLUDE_IN_AXIS_LIMITS_CHOICES);
            }
            else
            {
                _includeInAxisLimitsComboBox = new JComboBox(DEFAULT_NO_INCLUDE_IN_AXIS_LIMITS_CHOICES);
            }
        }

        _visibleComboBoxPanel = HSwingFactory.createLabeledComboBox(new JLabel("Visible:"), _visibleComboBox);
        this.add(_visibleComboBoxPanel, constraints);

        constraints = SwingTools.returnGridBagConstraints(0,
                                                          2,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.NORTHWEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        _includeInAxisLimitsComboBoxPanel = HSwingFactory.createLabeledComboBox(new JLabel("Include in Axis Limits:"),
                                                                                _includeInAxisLimitsComboBox);
        this.add(_includeInAxisLimitsComboBoxPanel, constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          3,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.NORTHWEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        this.add(ComponentHelper.removeEndingBufferJPanelIfAny(_labelParametersPanel), constraints);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          4,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.NORTHWEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);

        setupColorButtonPanel();
        this.add(_colorButtonPanel, constraints);

        constraints = SwingTools.returnGridBagConstraints(0,
                                                          5,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.NORTHWEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        setupLineWidthPanel();
        this.add(_lineWidthPanel, constraints);

        if(!_isNew)
        {
            _subPlotIndexComboBox.addItem("Default (" + _defaultThresholdParameters.getSubPlotIndex() + ")");
        }
        final List<Integer> subPlotIndexKeyList = new ArrayList<Integer>(_subPlotIndexToRangeAxisTypes.keySet());
        for(final Integer subPlotIndex: subPlotIndexKeyList)
        {
            _subPlotIndexComboBox.addItem(subPlotIndex);
        }

        _subPlotIndexComboBoxPanel = HSwingFactory.createLabeledComboBox(new JLabel("SubPlot Index:"),
                                                                         _subPlotIndexComboBox);

        _subPlotIndexComboBoxPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(),
                                                                              "Select SubPlot Index",
                                                                              null));

        constraints = SwingTools.returnGridBagConstraints(0,
                                                          6,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.NORTHWEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);

        this.add(_subPlotIndexComboBoxPanel, constraints);

        if(!_isNew)
        {
            _axisIdStringComboBox.addItem("Default (" + _defaultThresholdParameters.getAxisIdString().toLowerCase()
                + ")");
        }
        _axisIdStringComboBox.addItem(ChartConstants.DOMAIN_AXIS_STRING);
        for(int i = 0; i < ChartConstants.YAXIS_XML_STRINGS.length; i++)
        {
            _axisIdStringComboBox.addItem(ChartConstants.YAXIS_XML_STRINGS[i]);
        }

        _axisIdStringComboBoxPanel = HSwingFactory.createLabeledComboBox(new JLabel("Axis Id:"), _axisIdStringComboBox);
        _axisIdStringComboBoxPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(),
                                                                              "Select Axis Id",
                                                                              null));

        constraints = SwingTools.returnGridBagConstraints(0,
                                                          7,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.NORTHWEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);

        this.add(_axisIdStringComboBoxPanel, constraints);

        if(_isNew)
        {
            _labelAnchorComboBox = new JComboBox(DISPLAYED_NEW_ANCHOR_LIST);
        }
        else
        {
            _labelAnchorComboBox = new JComboBox(DISPLAYED_ANCHOR_LIST);
        }
        _labelAnchorComboBoxPanel = HSwingFactory.createLabeledComboBox(new JLabel("Label anchor:"),
                                                                        _labelAnchorComboBox);

        final JPanel anchorPanel = new JPanel(new GridBagLayout());
        anchorPanel.add(_labelAnchorComboBoxPanel, SwingTools.returnGridBagConstraints(0,
                                                                                       0,
                                                                                       1,
                                                                                       1,
                                                                                       1,
                                                                                       0,
                                                                                       GridBagConstraints.NORTHWEST,
                                                                                       GridBagConstraints.HORIZONTAL,
                                                                                       new Insets(0, 0, 0, 0),
                                                                                       0,
                                                                                       0));
        anchorPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(), "Select label anchor", null));

        constraints = SwingTools.returnGridBagConstraints(0,
                                                          8,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.NORTHWEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);

        this.add(anchorPanel, constraints);

        _zoneComboBoxPanel = HSwingFactory.createLabeledComboBox(new JLabel("Zone:"), _zoneComboBox);

        constraints = SwingTools.returnGridBagConstraints(0,
                                                          9,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.NORTHWEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);

        this.add(_zoneComboBoxPanel, constraints);
        setupDateAxisValuePanels();
        setupNumericalAxisValuePanels();

        if(isTimeAxis())
        {
            enableDateAxisValuePanels();
            disableNumericalAxisValuePanels();
        }
        else
        {
            enableNumericalAxisValuePanels();
            disableDateAxisValuePanels();
        }
    }

    /**
     * Disable Date Axis Value Panels
     */
    private void disableDateAxisValuePanels()
    {
        _dateAxisValueStartPanel.setVisible(false);
        _dateAxisValueEndPanel.setVisible(false);
    }

    /**
     * Disable the Numerical Axis Value Panels
     */
    private void disableNumericalAxisValuePanels()
    {
        _numericalAxisValueStartPanel.setVisible(false);
        _numericalAxisValueEndPanel.setVisible(false);
    }

    @Override
    public void disableSubPanel()
    {
    }

    /**
     * Enable Date Axis Value Panels
     */
    private void enableDateAxisValuePanels()
    {
        _dateAxisValueStartPanel.setVisible(true);
        _dateAxisValueEndPanel.setVisible(isZone());
    }

    private void enableDisableDatePanels()
    {
        if(_unboundDateValueStartCheckBox.isSelected())
        {
            _dateAxisValueStartComboGenericPanel.setEnabled(false);
        }
        else
        {
            _dateAxisValueStartComboGenericPanel.setEnabled(true);
        }

        if(_unboundDateValueEndCheckBox.isSelected())
        {
            _dateAxisValueEndComboGenericPanel.setEnabled(false);
        }
        else
        {
            _dateAxisValueEndComboGenericPanel.setEnabled(true);
        }
    }

    private void enableDisableNumericalDateAxisValuePanel()
    {
        if(isTimeAxis())
        {
            enableDateAxisValuePanels();
            disableNumericalAxisValuePanels();
        }
        else
        {
            disableDateAxisValuePanels();
            enableNumericalAxisValuePanels();
        }
    }

    /**
     * Enable the Numerical Axis ValuePanels
     */
    private void enableNumericalAxisValuePanels()
    {
        _numericalAxisValueStartPanel.setVisible(true);
        _numericalAxisValueEndPanel.setVisible(isZone());
    }

    @Override
    public void enableSubPanel()
    {
    }

    @Override
    public void fireParametersChanged()
    {
        super.fireParametersChanged();
    }

    public ThresholdParameters getDefParameters()
    {
        return _defaultThresholdParameters;
    }

    public ThresholdParameters getOverRideParameters()
    {
        return (ThresholdParameters)getManagedParameters();
    }

    public boolean isOverRideParametersDifferentFromDefaultParameters()
    {
        boolean nullOverRideParameters;
        final ThresholdParameters baseEmptyParameters = new ThresholdParameters();
        baseEmptyParameters.clearParameters();
        baseEmptyParameters.setIdentifier(getOverRideParameters().getIdentifier());

//        System.out.println( "Override Parameters: " + getOverRideParameters() );
//        System.out.println( "BaseEmptyParameters: " + baseEmptyParameters );

        if(_dateAxisValueStartPanel.isVisible())
        {
            nullOverRideParameters = baseEmptyParameters.equalParametersWithTimeAxis(getOverRideParameters());
        }
        else
        {
            nullOverRideParameters = baseEmptyParameters.equalParametersWithNumericalAxis(getOverRideParameters());
        }

        return !nullOverRideParameters;
    }

    private boolean isTimeAxis()
    {
        String axisIdString = null;
        boolean timeAxis = false;

        axisIdString = getOverRideParameters().getAxisIdString();

        if(axisIdString == null)
        {
            axisIdString = _defaultThresholdParameters.getAxisIdString();
        }

        //Domain axis check.
        if(axisIdString.equalsIgnoreCase(ChartConstants.DOMAIN_AXIS_STRING))
        {
            try
            {
                ChartTools.checkCompatibilityOfAxis(_xAxisType, ChartConstants.AXIS_IS_TIME);
                timeAxis = true;
            }
            catch(final ChartEngineException e)
            {
                timeAxis = false;
            }
        }
        else
        //Range axis check.
        {
            Integer subPlotIndex = getOverRideParameters().getSubPlotIndex();
            if(subPlotIndex == null)
            {
                subPlotIndex = _defaultThresholdParameters.getSubPlotIndex();
            }

            final int[] rangeAxisTypes = _subPlotIndexToRangeAxisTypes.get(subPlotIndex);
            if(rangeAxisTypes == null)
            {
                //Occurs whenever the user-specified (maybe) Threshold subPlotIndex does not match a valid subPlotIndex.  
                //Force timeAxis to be false since we can't identify the range axis to examine.  
                timeAxis = false;
            }

            else
            {
                //Otherwise, check to see if the range axis is time and return result.
                try
                {
                    ChartTools.checkCompatibilityOfAxis(rangeAxisTypes[0],
                                                                    ChartConstants.AXIS_IS_TIME);
                    timeAxis = true;
                }
                catch(final ChartEngineException e)
                {
                    timeAxis = false;
                }
            }
        }

        return timeAxis;
    }

    private boolean isZone()
    {
        boolean isZone;

        if(getOverRideParameters().getIsZone() != null)
        {
            isZone = getOverRideParameters().getIsZone();
        }
        else
        {
            isZone = _defaultThresholdParameters.getIsZone();
        }
        return isZone;
    }

    private void makeAxisIdReflectPanel()
    {
        final String axisIdString = (String)_axisIdStringComboBox.getSelectedItem();
        if(_isNew)
        {
            getOverRideParameters().setAxisIdString(axisIdString);
        }
        else
        {
            final int axisIdIndex = _axisIdStringComboBox.getSelectedIndex();
            if(axisIdIndex == 0)
            {
                getOverRideParameters().setAxisIdString(null);
            }
            else
            {
                getOverRideParameters().setAxisIdString(axisIdString);
            }
        }
    }

    private void makeColorParameterReflectPanel()
    {
        if(_isNew)
        {
            final Color color = ((ColorIcon)_colorButton.getIcon()).getColor();
            getOverRideParameters().setColor(color);
        }
        else
        {
            if(_defaultColorRadioButton.isSelected())
            {
                getOverRideParameters().setColor(null);
            }
            else
            {
                final Color color = ((ColorIcon)_colorButton.getIcon()).getColor();
                getOverRideParameters().setColor(color);
            }
        }
    }

    private void makeDateStartAndEndParametersReflectPanel()
    {
        if(!isTimeAxis() && !_isNew)
        {
            getOverRideParameters().setDateAxisValueStart(null);
            getOverRideParameters().setDateAxisValueEnd(null);
            return;
        }

        if(_unboundDateValueStartCheckBox.isSelected())
        {
            getOverRideParameters().setDateAxisValueStart(ThresholdParameters.UNBOUNDED_STRING);
        }
        else
        {
            final String dateAxisValueStartString = _dateAxisValueStartComboGenericPanel.getValueTextFieldText();
            getOverRideParameters().setDateAxisValueStart(dateAxisValueStartString);
        }

        if(isZone())
        {
            if(_unboundDateValueEndCheckBox.isSelected())
            {
                getOverRideParameters().setDateAxisValueEnd(ThresholdParameters.UNBOUNDED_STRING);
            }
            else
            {
                final String dateAxisValueEndString = _dateAxisValueEndComboGenericPanel.getValueTextFieldText();
                getOverRideParameters().setDateAxisValueEnd(dateAxisValueEndString);
            }
        }
    }

    private void makeIsZoneParameterReflectPanel()
    {
        Boolean isZone;
        final int zoneIndex = _zoneComboBox.getSelectedIndex();

        if(_isNew)
        {
            if(zoneIndex == 0)
            {
                isZone = true;
            }
            else
            {
                isZone = false;
            }
        }
        else
        {
            if(zoneIndex == 0)
            {
                isZone = null;
            }
            else if(zoneIndex == 1)
            {
                isZone = true;
            }
            else
            {
                isZone = false;
            }
        }
        getOverRideParameters().setIsZone(isZone);
    }

    private void makeLabelAnchorParameterReflectPanel()
    {
        if(_labelAnchorComboBox.getSelectedIndex() == 0)
        {
            getOverRideParameters().setLabelAnchor(null);
        }
        else
        {
            final String labelAnchor = (String)_labelAnchorComboBox.getSelectedItem();
            getOverRideParameters().setLabelAnchor(labelAnchor);
        }
    }

    private void makeLabelParametersReflectPanel()
    {

        final LabelChartParameters chartParams = (LabelChartParameters)_labelParametersPanel.getManagedParameters();
        Font font = null;
        Color fontColor = null;
        String labelString = null;

        if(_isNew)
        {
            font = chartParams.getFont();
            fontColor = _labelParametersPanel.getTextFieldColor();
            getOverRideParameters().getLabel().setFont(font);
            getOverRideParameters().getLabel().setColor(fontColor);
        }
        else
        {
            if(_labelParametersPanel.isDefaultFontSelected())
            {
                getOverRideParameters().getLabel().setFont(null);
                getOverRideParameters().getLabel().setColor(null);
            }
            else
            {
                font = _labelParametersPanel.getTextFieldFont();
                fontColor = _labelParametersPanel.getTextFieldColor();
                getOverRideParameters().getLabel().setFont(font);
                getOverRideParameters().getLabel().setColor(fontColor);
            }
        }

        if(_isNew)
        {
            labelString = _labelParametersPanel.getTextFieldText();
            getOverRideParameters().getLabel().setText(labelString);
        }
        else
        {
            if(_labelParametersPanel.isDefaultTextSelected())
            {
                getOverRideParameters().getLabel().setText(null);
            }
            else
            {
                labelString = _labelParametersPanel.getTextFieldText();
                getOverRideParameters().getLabel().setText(labelString);
            }
        }

        chartParams.setFont(font);
        chartParams.setColor(fontColor);
        chartParams.setText(labelString);

    }

    private void makeLineWidthParameterReflectPanel()
    {
        try
        {
            if(_isNew)
            {
                final Number lineWidthNumber = (Number)_lineWidthTextField.getValue();

                final Float lineWidthFloat = lineWidthNumber.floatValue();

                getOverRideParameters().setLineWidth(lineWidthFloat);
            }
            else
            {
                if(_defaultLineWidthRadioButton.isSelected())
                {
                    getOverRideParameters().setLineWidth(null);
                }
                else
                {
                    final Number lineWidthNumber = (Number)_lineWidthTextField.getValue();

                    final Float lineWidthFloat = lineWidthNumber.floatValue();

                    getOverRideParameters().setLineWidth(lineWidthFloat);
                }
            }
        }
        catch(final NumberFormatException e)
        {
            System.out.println("LineWidth number format exception caught");
            getOverRideParameters().setLineWidth(null);
        }
        catch(final NullPointerException e)
        {
            System.out.println("LineWidth Null Pointer exception caught");
            getOverRideParameters().setLineWidth(null);
        }
    }

    private void makeNumericalStartAndEndParametersReflectPanel()
    {
        if(isTimeAxis() && !_isNew)
        {
            getOverRideParameters().setNumericalAxisValueEndStr(null);
            getOverRideParameters().setNumericalAxisValueStartStr(null);
            return;
        }

        //Start
        final String numericalAxisValueStartString = (String)_numericalAxisValueStartComboBox.getSelectedItem();
        if(_isNew)
        {
            getOverRideParameters().setNumericalAxisValueStartStr(numericalAxisValueStartString);
        }
        else
        {
            if(_defaultNumericalAxisValueStartRadioButton.isSelected())
            {
                getOverRideParameters().setNumericalAxisValueStartStr(null);
            }
            else
            {
                getOverRideParameters().setNumericalAxisValueStartStr(numericalAxisValueStartString);
            }
        }

        //End
        final String numericalAxisValueEndString = (String)_numericalAxisValueEndComboBox.getSelectedItem();
        if(_isNew)
        {
            getOverRideParameters().setNumericalAxisValueEndStr(numericalAxisValueEndString);
        }
        else
        {
            if(_defaultNumericalAxisValueEndRadioButton.isSelected())
            {
                getOverRideParameters().setNumericalAxisValueEndStr(null);
            }
            else
            {
                getOverRideParameters().setNumericalAxisValueEndStr(numericalAxisValueEndString);
            }
        }
    }

    @Override
    public void makePanelReflectParameters()
    {
        removeListeners();
        final ThresholdParameters params = getOverRideParameters();
        if(params == null)
        {
            _identifierTextField.setText(_defaultThresholdParameters.getIdentifier());
        }
        else
        {
            _identifierTextField.setText(params.getIdentifier());
        }

        updateVisibleComboBox();
        updateIncludeInAxisLimitsComputationComboBox();
        updateZoneComboBox();
        updateParamsLabelPanel();
        updateColorPanel();
        updateLineWidthPanel();
        updateSubPlotIndexPanel();
        updateAxisIdStringComboBox();
        updateLabelAnchorComboBox();

        if(isTimeAxis())
        {
            enableDateAxisValuePanels();
            disableNumericalAxisValuePanels();

            updateDateAxisValueGUI();
        }
        else
        {
            enableNumericalAxisValuePanels();
            disableDateAxisValuePanels();

            updateNumericalAxisValueStartComboBox();

            updateNumericalAxisValueEndComboBox();
        }
        addListeners();
    }

    private void makeParametersReflectPanel()
    {
        final String identifierString = _identifierTextField.getText();
        final ThresholdParameters overRideParameters = getOverRideParameters();
        if(overRideParameters != null)
        {
            overRideParameters.setIdentifier(identifierString);
        }

        makeVisibleParameterReflectPanel();
        makeIncludeInAxisLimitsComputationParameterReflectPanel();
        makeIsZoneParameterReflectPanel();
        makeLabelParametersReflectPanel();
        makeColorParameterReflectPanel();
        makeLineWidthParameterReflectPanel();
        makeSubPlotIndexParameterReflectPanel();
        makeNumericalStartAndEndParametersReflectPanel();
        makeAxisIdReflectPanel();
        makeDateStartAndEndParametersReflectPanel();
        makeLabelAnchorParameterReflectPanel();
    }

    private void makeSubPlotIndexParameterReflectPanel()
    {
        final int subPlotIndex = _subPlotIndexComboBox.getSelectedIndex();
        if(_isNew)
        {
            getOverRideParameters().setSubPlotIndex((Integer)_subPlotIndexComboBox.getSelectedItem());
        }
        else
        {
            if(subPlotIndex == 0)
            {
                getOverRideParameters().setSubPlotIndex(null);
            }
            else
            {
                getOverRideParameters().setSubPlotIndex((Integer)_subPlotIndexComboBox.getSelectedItem());
            }
        }
    }

    private void makeVisibleParameterReflectPanel()
    {
        Boolean isVisible;
        final int visibleIndex = _visibleComboBox.getSelectedIndex();
        if(_isNew)
        {
            if(visibleIndex == 0)
            {
                isVisible = true;
            }
            else
            {
                isVisible = false;
            }
        }
        else
        {
            if(visibleIndex == 0)
            {
                isVisible = null;
            }
            else if(visibleIndex == 1)
            {
                isVisible = true;
            }
            else
            {
                isVisible = false;
            }
        }
        getOverRideParameters().setVisible(isVisible);
    }

    private void makeIncludeInAxisLimitsComputationParameterReflectPanel()
    {
        Boolean isIncludeInAxisLimitsComputation;
        final int index = _includeInAxisLimitsComboBox.getSelectedIndex();
        if(_isNew)
        {
            if(index == 0)
            {
                isIncludeInAxisLimitsComputation = true;
            }
            else
            {
                isIncludeInAxisLimitsComputation = false;
            }
        }
        else
        {
            if(index == 0)
            {
                isIncludeInAxisLimitsComputation = null;
            }
            else if(index == 1)
            {
                isIncludeInAxisLimitsComputation = true;
            }
            else
            {
                isIncludeInAxisLimitsComputation = false;
            }
        }
        getOverRideParameters().setIncludeInAxisLimitsComputation(isIncludeInAxisLimitsComputation);
    }

    @Override
    public void parameterChanged(final GeneralPlugInParameters parameters)
    {
        makeParametersReflectPanel();
        fireParametersChanged();
    }

    private void removeListeners()
    {
        _colorButton.removeActionListener(_colorButtonActionListener);
        _defaultColorRadioButton.removeActionListener(_defaultColorRadioButtonListener);
        _selectedColorRadioButton.removeActionListener(_selectedColorRadioButtonListener);
        _defaultLineWidthRadioButton.removeActionListener(_defaultLineWidthRadioButtonListener);
        _selectedLineWidthRadioButton.removeActionListener(_selectedLineWidthRadioButtonListener);
        _defaultNumericalAxisValueStartRadioButton.removeActionListener(_defaultNumericalAxisValueStartRadioButtonListener);
        _selectedNumericalAxisValueStartRadioButton.removeActionListener(_selectedNumericalAxisValueStartRadioButtonListener);
        _defaultNumericalAxisValueEndRadioButton.removeActionListener(_defaultNumericalAxisValueEndRadioButtonListener);
        _selectedNumericalAxisValueEndRadioButton.removeActionListener(_selectedNumericalAxisValueEndRadioButtonListener);

        _numericalAxisValueStartComboBox.removeItemListener(_numericalAxisValueComboBoxListener);
        _numericalAxisValueEndComboBox.removeItemListener(_numericalAxisValueComboBoxListener);
        _lineWidthTextField.removeFocusListener(_textFieldFocusListener);
        _identifierTextField.removeFocusListener(_identifierTextFieldFocusListener);
        _labelParametersPanel.removeGraphicsGeneratorPlugInPanelListener(this);
        _dateAxisValueStartComboGenericPanel.removeGraphicsGeneratorPlugInPanelListener(this);
        _dateAxisValueEndComboGenericPanel.removeGraphicsGeneratorPlugInPanelListener(this);
        _unboundDateValueStartCheckBox.removeActionListener(_dateCheckBoxListener);
        _unboundDateValueEndCheckBox.removeActionListener(_dateCheckBoxListener);

        _identifierTextField.removeActionListener(_identifierTextFieldActionListener);
        _lineWidthTextField.removeKeyListener(_textFieldKeyListener);

        _subPlotIndexComboBox.removeActionListener(_comboBoxListener);
        _axisIdStringComboBox.removeActionListener(_comboBoxListener);
        _zoneComboBox.removeActionListener(_zoneComboBoxListener);
        _visibleComboBox.removeActionListener(_comboBoxListener);
        _includeInAxisLimitsComboBox.removeActionListener(_comboBoxListener);
        _labelAnchorComboBox.removeActionListener(_comboBoxListener);
    }

    private void setColorButton(final boolean setDefault)
    {
        Color bgColor = null;

        if(setDefault) // Default radio button is selected.  Get the color from the defaultParameters
        {
            _colorButton.setEnabled(false);

            bgColor = _defaultThresholdParameters.getColor();
        }
        else
        {
            _colorButton.setEnabled(true);
            bgColor = getOverRideParameters().getColor();
            if(bgColor == null)
            {
                bgColor = _defaultThresholdParameters.getColor();
            }
        }
        _colorButton.setIcon(new ColorIcon(bgColor));
    }

    private void setLineWidthRadioButton(final boolean setDefault)
    {
        Number lineWidthNumber = null;

        if(setDefault)
        {
            _defaultLineWidthRadioButton.setSelected(true);
            final Float lineWidthFloat = _defaultThresholdParameters.getLineWidth();
            lineWidthNumber = lineWidthFloat;
            _lineWidthTextField.setValue(lineWidthNumber);
            _lineWidthTextField.setEnabled(false);
        }
        else
        {
            _selectedLineWidthRadioButton.setSelected(true);
            final Float lineWidthFloat = getOverRideParameters().getLineWidth();
            if(lineWidthFloat != null)
            {
                lineWidthNumber = lineWidthFloat;
            }
            else
            {
                lineWidthNumber = _defaultThresholdParameters.getLineWidth();
            }
            _lineWidthTextField.setEnabled(true);
            _lineWidthTextField.setValue(lineWidthNumber);
        }
    }

    private void setNumericalAxisValueEndRadioButton(final boolean setDefault)
    {
        if(setDefault)
        {
            _numericalAxisValueEndComboBox.setEnabled(false);
        }
        else
        {
            _numericalAxisValueEndComboBox.setEnabled(true);
        }
    }

    /**
     * Set the Numerical Axis Value Start Radio Button
     * 
     * @param setDefault - true if set to default
     */
    private void setNumericalAxisValueStartRadioButton(final boolean setDefault)
    {
        if(setDefault)
        {
            _numericalAxisValueStartComboBox.setEnabled(false);
        }
        else
        {
            _numericalAxisValueStartComboBox.setEnabled(true);
        }
    }

    /**
     * Setup the Color Button Panel
     */
    private void setupColorButtonPanel()
    {
        final JPanel selectedColorButtonPanel = new JPanel();
        final Insets theinsets = new Insets(0, 0, 0, 0);
        int gridX = 1;

        _colorButtonPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(), "Select Color", null));
        _colorRadioButtonGroup.add(_defaultColorRadioButton);
        _colorRadioButtonGroup.add(_selectedColorRadioButton);
        if(!_isNew)
        {
            _colorButtonPanel.add(_defaultColorRadioButton,
                                  SwingTools.returnGridBagConstraints(0,
                                                                      0,
                                                                      1,
                                                                      1,
                                                                      1,
                                                                      0,
                                                                      GridBagConstraints.LINE_START,
                                                                      GridBagConstraints.NONE,
                                                                      theinsets,
                                                                      0,
                                                                      0));
            selectedColorButtonPanel.add(_selectedColorRadioButton);

            _selectedColorRadioButton.setSelected(true);
        }
        else
        {
            gridX = 0; // set it to the first column since no default radio button will be displayed
        }
        selectedColorButtonPanel.add(_colorButton);
        _colorButton.setToolTipText("Edit Color");
        _colorButtonPanel.add(selectedColorButtonPanel,
                              SwingTools.returnGridBagConstraints(gridX,
                                                                  0,
                                                                  1,
                                                                  1,
                                                                  1,
                                                                  0,
                                                                  GridBagConstraints.LINE_START,
                                                                  GridBagConstraints.NONE,
                                                                  theinsets,
                                                                  0,
                                                                  0));

    }

    /**
     * Add Date Axis Value Panels
     */
    private void setupDateAxisValuePanels()
    {
        GridBagConstraints constraints = null;
        GenericParameterList parametersStartDateList = new GenericParameterList();
        final GenericParameterList parametersEndDateList = new GenericParameterList();
        String startDate = null;
        String endDate = null;

        if(getOverRideParameters() != null)
        {
            startDate = getOverRideParameters().getDateAxisValueStart();
            if((startDate != null) && (startDate.equals(ThresholdParameters.UNBOUNDED_STRING)))
            {
                startDate = "T0";
            }
        }
        else
        {
            startDate = _defaultThresholdParameters.getDateAxisValueStart();
        }

        if(getOverRideParameters() != null)
        {
            endDate = getOverRideParameters().getDateAxisValueEnd();
            if((endDate != null) && (endDate.equals(ThresholdParameters.UNBOUNDED_STRING)))
            {
                endDate = "T0";
            }
        }
        else
        {
            endDate = _defaultThresholdParameters.getDateAxisValueEnd();
        }

        if(startDate != null)
        {
            parametersStartDateList.addParameter("dateAxisValueStart", startDate);
        }

        if(endDate != null)
        {
            parametersEndDateList.addParameter("dateAxisValueEnd", endDate);
        }

        ArgumentsProcessor argProc = getOverRideParameters().getArguments();

        if(argProc == null)
        {
            argProc = _defaultThresholdParameters.getArguments();
        }

        final String[] fixRelOptions = new String[]{DateComboGenericParameterPanel.SET_TO_FIXED,
            DateComboGenericParameterPanel.SET_TO_RELATIVE};
        final String[] dateTypeOptions = new String[]{HEFSDateTools.SYSTEM_TIME_BASIS_STR};
        _dateAxisValueStartComboGenericPanel = new DateComboGenericParameterPanel(parametersStartDateList,
                                                                                  "dateAxisValueStart",
                                                                                  argProc,
                                                                                  HEFSDateTools.SYSTEM_TIME_BASIS_STR,
                                                                                  fixRelOptions,
                                                                                  DateComboGenericParameterPanel.SET_TO_FIXED,
                                                                                  dateTypeOptions);

        constraints = SwingTools.returnGridBagConstraints(0,
                                                          10,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.NORTHWEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);
        final JPanel fillerPanel = new JPanel();
        GridBagConstraints dateConstraints = SwingTools.returnGridBagConstraints(0,
                                                                                 0,
                                                                                 1,
                                                                                 1,
                                                                                 0,
                                                                                 0,
                                                                                 GridBagConstraints.WEST,
                                                                                 GridBagConstraints.HORIZONTAL,
                                                                                 new Insets(0, 0, 0, 0),
                                                                                 0,
                                                                                 0);
        _dateAxisValueStartPanel = new JPanel(new GridBagLayout());
        _dateAxisValueStartPanel.add(_unboundDateValueStartCheckBox, dateConstraints);
        dateConstraints = SwingTools.returnGridBagConstraints(1,
                                                              0,
                                                              1,
                                                              1,
                                                              0,
                                                              0,
                                                              GridBagConstraints.WEST,
                                                              GridBagConstraints.HORIZONTAL,
                                                              new Insets(0, 0, 0, 0),
                                                              0,
                                                              0);
        _dateAxisValueStartPanel.add(_dateAxisValueStartComboGenericPanel.getEditingDisplayPanel(), dateConstraints);
        dateConstraints = SwingTools.returnGridBagConstraints(2,
                                                              0,
                                                              1,
                                                              1,
                                                              1,
                                                              0,
                                                              GridBagConstraints.WEST,
                                                              GridBagConstraints.HORIZONTAL,
                                                              new Insets(0, 0, 0, 0),
                                                              0,
                                                              0);

        _dateAxisValueStartPanel.add(fillerPanel, dateConstraints);
        _dateAxisValueStartPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(),
                                                                            "Select Date Axis Value Start",
                                                                            null));
        this.add(_dateAxisValueStartPanel, constraints);

        parametersStartDateList = new GenericParameterList();

        _dateAxisValueEndComboGenericPanel = new DateComboGenericParameterPanel(parametersEndDateList,
                                                                                "dateAxisValueEnd",
                                                                                argProc,
                                                                                HEFSDateTools.SYSTEM_TIME_BASIS_STR,
                                                                                fixRelOptions,
                                                                                DateComboGenericParameterPanel.SET_TO_FIXED,
                                                                                dateTypeOptions);

        constraints = SwingTools.returnGridBagConstraints(0,
                                                          11,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.NORTHWEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);

        dateConstraints = SwingTools.returnGridBagConstraints(0,
                                                              0,
                                                              1,
                                                              1,
                                                              0,
                                                              0,
                                                              GridBagConstraints.WEST,
                                                              GridBagConstraints.HORIZONTAL,
                                                              new Insets(0, 0, 0, 0),
                                                              0,
                                                              0);

        _dateAxisValueEndPanel = new JPanel(new GridBagLayout());
        _dateAxisValueEndPanel.add(_unboundDateValueEndCheckBox, dateConstraints);
        dateConstraints = SwingTools.returnGridBagConstraints(1,
                                                              0,
                                                              1,
                                                              1,
                                                              0,
                                                              0,
                                                              GridBagConstraints.WEST,
                                                              GridBagConstraints.HORIZONTAL,
                                                              new Insets(0, 0, 0, 0),
                                                              0,
                                                              0);

        _dateAxisValueEndPanel.add(_dateAxisValueEndComboGenericPanel.getEditingDisplayPanel(), dateConstraints);
        final JPanel fillerPanel2 = new JPanel();
        dateConstraints = SwingTools.returnGridBagConstraints(2,
                                                              0,
                                                              1,
                                                              1,
                                                              1,
                                                              0,
                                                              GridBagConstraints.WEST,
                                                              GridBagConstraints.HORIZONTAL,
                                                              new Insets(0, 0, 0, 0),
                                                              0,
                                                              0);
        _dateAxisValueEndPanel.add(fillerPanel2, dateConstraints);
        _dateAxisValueEndPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(),
                                                                          "Select Date Axis Value End",
                                                                          null));
        this.add(_dateAxisValueEndPanel, constraints);
    }

    /**
     * Setup the Line Width Panel
     */
    private void setupLineWidthPanel()
    {
        final Insets theinsets = new Insets(0, 0, 0, 0);
        final JPanel selectedLineWidthPanel = new JPanel();

        _lineWidthPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(), "Select Line Width", null));
        _lineWidthRadioButtonGroup.add(_defaultLineWidthRadioButton);
        _lineWidthRadioButtonGroup.add(_selectedLineWidthRadioButton);
        if(!_isNew)
        {
            _lineWidthPanel.add(_defaultLineWidthRadioButton,
                                SwingTools.returnGridBagConstraints(0,
                                                                    0,
                                                                    1,
                                                                    1,
                                                                    1,
                                                                    0,
                                                                    GridBagConstraints.LINE_START,
                                                                    GridBagConstraints.NONE,
                                                                    theinsets,
                                                                    0,
                                                                    0));
            selectedLineWidthPanel.add(_selectedLineWidthRadioButton);

        }

        _selectedLineWidthRadioButton.setSelected(true);

        _lineWidthTextField.setColumns(10);

        selectedLineWidthPanel.add(_lineWidthTextField);
        _lineWidthPanel.add(selectedLineWidthPanel, SwingTools.returnGridBagConstraints(1,
                                                                                        0,
                                                                                        1,
                                                                                        1,
                                                                                        1,
                                                                                        0,
                                                                                        GridBagConstraints.LINE_START,
                                                                                        GridBagConstraints.NONE,
                                                                                        theinsets,
                                                                                        0,
                                                                                        0));

    }

    /**
     * Setup the Numerical Axis Value End Button Group
     */
    private void setupNumericalAxisValueEndButtonGroup()
    {
        final Insets theinsets = new Insets(0, 0, 0, 0);
        _numericalAxisValueEndPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(),
                                                                               "Select Axis Value End",
                                                                               null));
        _numericalAxisValueEndButtonGroup.add(_defaultNumericalAxisValueEndRadioButton);
        _numericalAxisValueEndButtonGroup.add(_selectedNumericalAxisValueEndRadioButton);
        if(!_isNew)
        {
            _numericalAxisValueEndPanel.add(_defaultNumericalAxisValueEndRadioButton,
                                            SwingTools.returnGridBagConstraints(0,
                                                                                0,
                                                                                1,
                                                                                1,
                                                                                1,
                                                                                0,
                                                                                GridBagConstraints.LINE_START,
                                                                                GridBagConstraints.NONE,
                                                                                theinsets,
                                                                                0,
                                                                                0));
            _numericalAxisValueEndPanel.add(_selectedNumericalAxisValueEndRadioButton,
                                            SwingTools.returnGridBagConstraints(1,
                                                                                0,
                                                                                1,
                                                                                1,
                                                                                1,
                                                                                0,
                                                                                GridBagConstraints.LINE_START,
                                                                                GridBagConstraints.NONE,
                                                                                theinsets,
                                                                                0,
                                                                                0));
        }
        _numericalAxisValueEndComboBox.setEditor(new ArgumentInsertingTextFieldComboBoxEditor(_identifierTextField.getArguments()));

        _numericalAxisValueEndComboBox.addItem(ThresholdParameters.UNBOUNDED_STRING);
        _numericalAxisValueEndComboBox.setEditable(true);

        _numericalAxisValueEndPanel.add(_numericalAxisValueEndComboBox,
                                        SwingTools.returnGridBagConstraints(2,
                                                                            0,
                                                                            1,
                                                                            1,
                                                                            1,
                                                                            0,
                                                                            GridBagConstraints.LINE_START,
                                                                            GridBagConstraints.NONE,
                                                                            theinsets,
                                                                            0,
                                                                            0));

    }

    /**
     * Add the Numerical Axis Value Panels
     */
    private void setupNumericalAxisValuePanels()
    {
        GridBagConstraints constraints = null;
        setupNumericalAxisValueStartButtonGroup();
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          10,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.NORTHWEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);

        this.add(_numericalAxisValueStartPanel, constraints);
        setupNumericalAxisValueEndButtonGroup();
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          11,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          GridBagConstraints.NORTHWEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          new Insets(0, 0, 0, 0),
                                                          0,
                                                          0);

        this.add(_numericalAxisValueEndPanel, constraints);
        _selectedNumericalAxisValueStartRadioButton.setSelected(true);
        _selectedNumericalAxisValueEndRadioButton.setSelected(true);
    }

    /**
     * Setup the Numerical Axis Value Start Button Group
     */
    private void setupNumericalAxisValueStartButtonGroup()
    {
        final Insets theinsets = new Insets(0, 0, 0, 0);
        _numericalAxisValueStartPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(),
                                                                                 "Select Axis Value Start",
                                                                                 null));
        _numericalAxisValueStartButtonGroup.add(_defaultNumericalAxisValueStartRadioButton);
        _numericalAxisValueStartButtonGroup.add(_selectedNumericalAxisValueStartRadioButton);
        if(!_isNew)
        {
            _numericalAxisValueStartPanel.add(_defaultNumericalAxisValueStartRadioButton,
                                              SwingTools.returnGridBagConstraints(0,
                                                                                  0,
                                                                                  1,
                                                                                  1,
                                                                                  1,
                                                                                  0,
                                                                                  GridBagConstraints.LINE_START,
                                                                                  GridBagConstraints.NONE,
                                                                                  theinsets,
                                                                                  0,
                                                                                  0));
            _numericalAxisValueStartPanel.add(_selectedNumericalAxisValueStartRadioButton,
                                              SwingTools.returnGridBagConstraints(1,
                                                                                  0,
                                                                                  1,
                                                                                  1,
                                                                                  1,
                                                                                  0,
                                                                                  GridBagConstraints.LINE_START,
                                                                                  GridBagConstraints.NONE,
                                                                                  theinsets,
                                                                                  0,
                                                                                  0));

        }

        _numericalAxisValueStartComboBox.addItem(ThresholdParameters.UNBOUNDED_STRING);
        _numericalAxisValueStartComboBox.setEditable(true);
        _numericalAxisValueStartComboBox.setEditor(new ArgumentInsertingTextFieldComboBoxEditor(_identifierTextField.getArguments()));
        _numericalAxisValueStartPanel.add(_numericalAxisValueStartComboBox,
                                          SwingTools.returnGridBagConstraints(2,
                                                                              0,
                                                                              1,
                                                                              1,
                                                                              1,
                                                                              0,
                                                                              GridBagConstraints.LINE_START,
                                                                              GridBagConstraints.NONE,
                                                                              theinsets,
                                                                              0,
                                                                              0));

    }

    private void updateAxisIdStringComboBox()
    {
        final ThresholdParameters params = getOverRideParameters();

        String axisIdString = null;

        if(params != null)
        {
            axisIdString = params.getAxisIdString();
        }
        if(axisIdString != null)
        {
            _axisIdStringComboBox.setSelectedItem(axisIdString.toLowerCase());
        }
        else
        {
            _axisIdStringComboBox.setSelectedItem(_defaultThresholdParameters.getAxisIdString());
        }
    }

    private void updateColorPanel()
    {
        final ThresholdParameters params = getOverRideParameters();
        Color paramsColor = null;

        if(params != null)
        {
            paramsColor = params.getColor();
        }

        if(paramsColor == null)
        {
            _defaultColorRadioButton.setSelected(true);
            setColorButton(true);
        }
        else
        {
            _selectedColorRadioButton.setSelected(true);
            setColorButton(false);
        }
    }

    private void updateDateAxisValueGUI()
    {
        final ThresholdParameters overRideParams = getOverRideParameters();
        final String dateAxisValueStart = overRideParams.getDateAxisValueStart();
        final String dateAxisValueEnd = overRideParams.getDateAxisValueEnd();

        if((dateAxisValueStart != null) && !dateAxisValueStart.equalsIgnoreCase(ThresholdParameters.UNBOUNDED_STRING))
        {
            _unboundDateValueStartCheckBox.setSelected(false);

        }
        else
        {
            _unboundDateValueStartCheckBox.setSelected(true);
        }

        if((dateAxisValueEnd != null) && !dateAxisValueEnd.equalsIgnoreCase(ThresholdParameters.UNBOUNDED_STRING))
        {
            _unboundDateValueEndCheckBox.setSelected(false);

        }
        else
        {
            _unboundDateValueEndCheckBox.setSelected(true);
        }
        enableDisableDatePanels();
    }

    private void updateLabelAnchorComboBox()
    {
        //If override is given and its not null, then just select it.
        if(getOverRideParameters().getLabelAnchor() != null)
        {
            _labelAnchorComboBox.setSelectedItem(getOverRideParameters().getLabelAnchor());
        }
        //If it is null, then the default value is being used, so select index 0.
        else
        {
            _labelAnchorComboBox.setSelectedItem(DISPLAYED_ANCHOR_LIST[0]);
        }
    }

    private void updateLineWidthPanel()
    {
        final ThresholdParameters params = getOverRideParameters();
        Float lineWidth = null;

        if(params != null)
        {
            lineWidth = params.getLineWidth();
        }

        if(lineWidth == null)
        {
            setLineWidthRadioButton(true);
        }
        else
        {
            setLineWidthRadioButton(false);
        }
    }

    private void updateNumericalAxisValueEndComboBox()
    {
        final ThresholdParameters overRideParams = getOverRideParameters();
        String numericalAxisValueEndStr = null;

        if(overRideParams.getNumericalAxisValueEndStr() == null)
        {
            if(_defaultThresholdParameters != null)
            {
                numericalAxisValueEndStr = _defaultThresholdParameters.getNumericalAxisValueEndStr();
                _defaultNumericalAxisValueEndRadioButton.setSelected(true);
                setNumericalAxisValueEndRadioButton(true);
            }
        }
        else
        {
            numericalAxisValueEndStr = overRideParams.getNumericalAxisValueEndStr();
            _selectedNumericalAxisValueEndRadioButton.setSelected(true);
            setNumericalAxisValueEndRadioButton(false);
        }

        if((numericalAxisValueEndStr == null)
            || (numericalAxisValueEndStr.equals(ThresholdParameters.UNBOUNDED_STRING)))
        {
            _numericalAxisValueEndComboBox.setSelectedItem(ThresholdParameters.UNBOUNDED_STRING);
        }
        else
        {
            _numericalAxisValueEndComboBox.setSelectedItem(numericalAxisValueEndStr);
        }
    }

    private void updateNumericalAxisValueStartComboBox()
    {
        final ThresholdParameters overRideParams = getOverRideParameters();
        String numericalAxisValueStartStr = null;

        if(overRideParams.getNumericalAxisValueStartStr() == null)
        {
            if(_defaultThresholdParameters != null)
            {
                numericalAxisValueStartStr = _defaultThresholdParameters.getNumericalAxisValueStartStr();
                _defaultNumericalAxisValueStartRadioButton.setSelected(true);
                setNumericalAxisValueStartRadioButton(true);
            }
        }
        else
        {
            numericalAxisValueStartStr = overRideParams.getNumericalAxisValueStartStr();
            _selectedNumericalAxisValueStartRadioButton.setSelected(true);
            setNumericalAxisValueStartRadioButton(false);
        }

        if((numericalAxisValueStartStr == null)
            || (numericalAxisValueStartStr.equals(ThresholdParameters.UNBOUNDED_STRING)))
        {
            _numericalAxisValueStartComboBox.setSelectedItem(ThresholdParameters.UNBOUNDED_STRING);
        }
        else
        {
            _numericalAxisValueStartComboBox.setSelectedItem(numericalAxisValueStartStr);
        }
    }

    private void updateParamsLabelPanel()
    {
        final ThresholdParameters params = getOverRideParameters();
        boolean defaultFont = true;
        boolean defaultText = true;
        Font paramsFont = null;
        Color paramsColor = null;
        String paramsText = null;
        LabelChartParameters labelChartParameters = null;

        if(params != null)
        {
            labelChartParameters = params.getLabel();
        }

        if(labelChartParameters != null)
        {
            paramsFont = params.getLabel().getFont();
            paramsText = params.getLabel().getText();
            paramsColor = params.getLabel().getColor();
        }

        if(paramsFont == null)
        {
            _labelParametersPanel.setChosenFont(_defaultThresholdParameters.getLabel().getFont());
            defaultFont = true;
        }
        else
        {
            _labelParametersPanel.setChosenFont(paramsFont);
            defaultFont = false;
        }

        if(paramsColor == null)
        {
            _labelParametersPanel.setChosenColor(_defaultThresholdParameters.getLabel().getColor());
        }
        else
        {
            _labelParametersPanel.setChosenColor(paramsColor);
        }

        if(paramsText == null)
        {
            _labelParametersPanel.setTextFieldText(_defaultThresholdParameters.getLabel().getText());
            defaultText = true;
        }
        else
        {
            _labelParametersPanel.setTextFieldText(paramsText);
            defaultText = false;
        }

        _labelParametersPanel.setDefaultFontRadioButton(defaultFont);
        _labelParametersPanel.setDefaultTextRadioButton(defaultText);
    }

    private void updateSubPlotIndexPanel()
    {
        final ThresholdParameters params = getOverRideParameters();
        Integer subPlotIndex = null;

        if(params != null)
        {
            subPlotIndex = params.getSubPlotIndex();
        }
        if(subPlotIndex != null)
        {
            _subPlotIndexComboBox.setSelectedItem(subPlotIndex);
        }
        else
        {
            _subPlotIndexComboBox.setSelectedIndex(0);
        }
    }

    private void updateVisibleComboBox()
    {
        final ThresholdParameters params = getOverRideParameters();
        if(_isNew)
        {
            if(params.getVisible())
            {
                _visibleComboBox.setSelectedIndex(0); // set to yes
            }
            else
            {
                _visibleComboBox.setSelectedIndex(1); // set to no
            }
        }
        else
        {
            if((params == null) || (params.getVisible() == null))
            {
                _visibleComboBox.setSelectedIndex(0);
            }
            else
            {
                if(params.getVisible())
                {
                    _visibleComboBox.setSelectedIndex(1); // set to yes
                }
                else
                {
                    _visibleComboBox.setSelectedIndex(2); //set to no
                }
            }
        }
        setVisible(false);
        setVisible(true);
    }

    private void updateIncludeInAxisLimitsComputationComboBox()
    {
        final ThresholdParameters params = getOverRideParameters();
        if(_isNew)
        {
            if(params.getIncludeInAxisLimitsComputation())
            {
                _includeInAxisLimitsComboBox.setSelectedIndex(0); // set to yes
            }
            else
            {
                _includeInAxisLimitsComboBox.setSelectedIndex(1); // set to no
            }
        }
        else
        {
            if((params == null) || (params.getIncludeInAxisLimitsComputation() == null))
            {
                _includeInAxisLimitsComboBox.setSelectedIndex(0);
            }
            else
            {
                if(params.getIncludeInAxisLimitsComputation())
                {
                    _includeInAxisLimitsComboBox.setSelectedIndex(1); // set to yes
                }
                else
                {
                    _includeInAxisLimitsComboBox.setSelectedIndex(2); //set to no
                }
            }
        }
        setVisible(false);
        setVisible(true);
    }

    private void updateZoneComboBox()
    {
        final ThresholdParameters params = getOverRideParameters();

        if(_isNew)
        {
            if(params.getIsZone())
            {
                _zoneComboBox.setSelectedIndex(0);
            }
            else
            {
                _zoneComboBox.setSelectedIndex(1);
            }
        }
        else
        {
            if((params == null) || (params.getIsZone() == null))
            {
                _zoneComboBox.setSelectedIndex(0);
            }
            else
            {
                if(params.getIsZone())
                {
                    _zoneComboBox.setSelectedIndex(1);
                }
                else
                {
                    _zoneComboBox.setSelectedIndex(2);
                }
            }
        }
        setVisible(false);
        setVisible(true);
    }
}