package ohd.hseb.charter.parameters.panels;

import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;

import ohd.hseb.charter.parameters.ThresholdListParameters;
import ohd.hseb.charter.parameters.ThresholdParameters;
import ohd.hseb.hefs.utils.arguments.ArgumentsProcessor;
import ohd.hseb.hefs.utils.gui.jtable.TableTools;

public class ThresholdParametersListPanelTableModel extends AbstractTableModel
{
    private static final long serialVersionUID = 1L;

    public static String NONE_STR = "-none-";

    public final boolean _overRide;

    private final ArgumentsProcessor _argumentsProcessor;
    /**
     * THIS MUST BE A READ ONLY LIST!
     */

    private ThresholdListParameters _overrideThresholdParameters = null;
    private ThresholdListParameters _defaultThresholdParameters = null;
    private ThresholdParametersListPanelTableModelListener _listener = null;

    /**
     * @param thresholdParameters - ThresholdParameters List
     * @param overRide - Override or not
     * @param argumentsProcessor - Arguments Processor
     */
    public ThresholdParametersListPanelTableModel(ThresholdParametersListPanelTableModelListener listener,
                                                  ThresholdListParameters overrideThresholdParameters,
                                                  ThresholdListParameters defaultThresholdParameters,
                                                  boolean overRide,
                                                  ArgumentsProcessor argumentsProcessor)
    {
        this._listener = listener;
        _overrideThresholdParameters = overrideThresholdParameters;
        _defaultThresholdParameters = defaultThresholdParameters;
        _overRide = overRide;
        _argumentsProcessor = argumentsProcessor;
    }

    @Override
    public String getColumnName(int col)
    {
        if(col == 0)
        {
            return "";
        }
        else if(col == 1)
        {
            return "";
        }
        else if(col == 2)
        {
            return "Visible";
        }
        else if(col == 3)
        {
            return "Identifier";
        }
        else if((col == 4) && (_overRide))
        {
            return "Evaluated Identifier";
        }
        return "UNDEFINED";
    }

    @Override
    public int getColumnCount()
    {
        int columnCount;

        if(_overRide)
        {
            columnCount = 5;
        }
        else
        {
            columnCount = 4;
        }
        return columnCount;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex)
    {
        if(columnIndex == 0)
        {
            return JLabel.class;
        }
        if(columnIndex == 1)
        {
            return JLabel.class;
        }

        if(columnIndex == 2)
        {
            return Boolean.class;
        }

        return super.getColumnClass(columnIndex);
    }

    public boolean doesOverrideExist(String identifier)
    {
        return (_overrideThresholdParameters.retrieveThresholdParameters(identifier) != null);
    }

    public boolean doesDefaultExist(String identifier)
    {
        return (this._defaultThresholdParameters.retrieveThresholdParameters(identifier) != null);
    }

    public ThresholdParameters retrieveExistingOverrideOrBuildNewOne(String identifier)
    {
        ThresholdParameters override = this._overrideThresholdParameters.retrieveThresholdParameters(identifier);
        if(override == null)
        {
            override = new ThresholdParameters(identifier);
            ThresholdParameters defaultParms = this._defaultThresholdParameters.retrieveThresholdParameters(identifier);
            if(defaultParms == null)
            {
                override.setupDefaultParameters();
            }
            else
            {
                override.clearParameters();
            }
            override.setArguments(this._argumentsProcessor);
            this._overrideThresholdParameters.addThreshold(override);
        }
        return override;
    }

    @Override
    public void setValueAt(Object value, int row, int col)
    {
        if(col == 2)
        {
            ThresholdParameters parametersForRow = getDisplayedParameters().getThresholdParametersList().get(row);
            String identifier = parametersForRow.getIdentifier();

            //Overrides is a set of overrides for the identifier, possibly a new set if it did not previously
            //exist.
            ThresholdParameters overrides = this.retrieveExistingOverrideOrBuildNewOne(identifier);

            //Default is null or the corresponding defaults.
            ThresholdParameters defaultParms = _defaultThresholdParameters.retrieveThresholdParameters(identifier);

            final boolean visible = (Boolean)value;

            //If default is null, then the overrides must be used as is; set the visible accordingly.
            if(defaultParms == null)
            {
                overrides.setVisible(visible);
            }

            //Otherwise, set the visible in override to null if the new visible value matches default and
            //check to see if we can remove the override.
            else
            {
                if(defaultParms.getVisible() == visible)
                {
                    overrides.setVisible(null);
                }
                else
                {
                    overrides.setVisible(visible);
                }
                if(overrides.isEmpty())
                {
                    this._overrideThresholdParameters.removeThreshold(identifier);
                }
            }
            super.setValueAt(value, row, col);
            this._listener.reactToVisibleChanged(this, identifier);
            return;
        }
        super.setValueAt(value, row, col);
    }

    public ThresholdListParameters getDisplayedParameters()
    {
        if(_overRide)
        {
            return this._overrideThresholdParameters;
        }
        return this._defaultThresholdParameters;
    }

    public String getIdentifier(int rowNumber)
    {
        return getDisplayedParameters().getThresholdParametersList().get(rowNumber).getIdentifier();
    }

    public Integer getRowNumber(String identifier)
    {
        ThresholdListParameters displayedParms = getDisplayedParameters();

        for(int i = 0; i < displayedParms.getThresholdParametersList().size(); i++)
        {
            ThresholdParameters extractedParameter = displayedParms.getThresholdParametersList().get(i);
            String evaluatedIdentifier = _argumentsProcessor.replaceArgumentsInString(extractedParameter.getIdentifier());
            if(evaluatedIdentifier.equalsIgnoreCase(_argumentsProcessor.replaceArgumentsInString(identifier)))
            {
                return i;
            }
        }
        return null;
    }

    public ThresholdParameters getParamFromRow(String identifier)
    {
        ThresholdListParameters displayedParms = getDisplayedParameters();
        return displayedParms.retrieveThresholdParameters(identifier);
    }

    @Override
    public boolean isCellEditable(int row, int col)
    {
        boolean cellEditable;

        if(col == 2)
        {
            cellEditable = true;
        }
        else
        {
            cellEditable = false;
        }

        return cellEditable;
    }

    @Override
    public int getRowCount()
    {
        return this.getDisplayedParameters().getThresholdParametersList().size();
    }

    @Override
    public Object getValueAt(int row, int col)
    {
        //String identifier = _thresholdParameters.get(row).getIdentifier();
        ThresholdParameters parametersForRow = getDisplayedParameters().getThresholdParametersList().get(row);
        if(this.getDisplayedParameters().getThresholdParametersList().size() == 0)
        {
            return "";
        }
        if(col == 0)
        {
            if(!_overRide)
            {
                JLabel blankLabel = new JLabel();
                blankLabel.setName("DEFAULT");
                return blankLabel;
            }
            else
            {
                return TableTools.createDeleteIconLabel("Delete Override Threshold");
            }
        }
        else if(col == 1)
        {
            ThresholdParameters defaultParms = _defaultThresholdParameters.retrieveThresholdParameters(parametersForRow.getIdentifier());

            boolean goodParms = true;
            if(defaultParms == null)
            {
                goodParms = parametersForRow.isValidOverRideParameter(_listener.getAxisType(parametersForRow));
            }

            return TableTools.createStatusIconLabel(goodParms, "Status of Threshold Parameters");
        }
        else if(col == 2)
        {

            return getVisibilityOfThreshold(parametersForRow.getIdentifier());
        }
        else if(col == 3)
        {
            return parametersForRow.getIdentifier();
        }
        else if((col == 4) && (_overRide))
        {
            return _argumentsProcessor.replaceArgumentsInString(parametersForRow.getIdentifier());
        }
        return "--";
    }

    private boolean getVisibilityOfThreshold(String identifier)
    {
        ThresholdParameters defaultParms = this._defaultThresholdParameters.retrieveThresholdParameters(identifier);
        ThresholdParameters overrideParms = this._overrideThresholdParameters.retrieveThresholdParameters(identifier);

        if((overrideParms != null) && (overrideParms.getVisible() != null))
        {
            return overrideParms.getVisible();
        }
        if((defaultParms != null) && (defaultParms.getVisible() != null))
        {
            return defaultParms.getVisible();
        }
        return true;
    }
}