package ohd.hseb.charter.parameters.panels;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.WindowConstants;
import javax.swing.border.EtchedBorder;

import ohd.hseb.charter.parameters.TitleParameters;
import ohd.hseb.hefs.utils.gui.components.BufferJPanel;
import ohd.hseb.hefs.utils.gui.tools.ComponentHelper;
import ohd.hseb.hefs.utils.gui.tools.HSwingFactory;
import ohd.hseb.hefs.utils.gui.tools.SwingTools;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInPanelListener;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInParameters;

import org.jfree.ui.RectangleInsets;

public class TitleParametersPanel extends ChartParametersPanel implements RectangleInsetsEditingPanelListener,
ActionListener, GeneralPlugInPanelListener
{
    private static final long serialVersionUID = 1L;

    private final TextFontSelectionPanel _labelPanel;
    private final BorderParametersPanel _borderPanel;
    private final RectangleInsetsEditingPanel _textInsetsPanel;

    //horizontal alignment
    private final JComboBox _horizontalAlignmentChoices = new JComboBox(TitleParameters.buildAlignmentDisplayedStrings());

    //text alignment
    private final JComboBox _textAlignmentChoices = new JComboBox(TitleParameters.buildAlignmentDisplayedStrings());

    public TitleParametersPanel(TitleParameters managedParameters, TitleParameters defaultParameters)
    {
        this.setManagedParameters(managedParameters);
        this.setDefaultParameters(defaultParameters);

        _labelPanel = new TextFontSelectionPanel(managedParameters, defaultParameters, true, true);
        _borderPanel = new BorderParametersPanel(managedParameters.getBorder(), defaultParameters.getBorder());
        _textInsetsPanel = new RectangleInsetsEditingPanel(defaultParameters.getTextInsets());

        _labelPanel.addGraphicsGeneratorPlugInPanelListener(this);
        _borderPanel.addGraphicsGeneratorPlugInPanelListener(this);
        _textInsetsPanel.addListener(this);

        createDisplay();
        addListeners();
        makePanelReflectParameters();
    }

    protected void createDisplay()
    {
        _textInsetsPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(), "Select Text Insets", null));

        //horizontal panel
        JPanel horPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
        horPanel.add(new JLabel("Select Horizontal Alignment: "));
        horPanel.add(_horizontalAlignmentChoices);

        //text panel
        JPanel textPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
        textPanel.add(new JLabel("Select Text Alignment: "));
        textPanel.add(_textAlignmentChoices);

        this.setLayout(new GridBagLayout());
        this.add(ComponentHelper.removeEndingBufferJPanelIfAny(_labelPanel),
                 SwingTools.returnGridBagConstraints(0,
                                                        0,
                                                        1,
                                                        1,
                                                        1,
                                                        0,
                                                        GridBagConstraints.WEST,
                                                        GridBagConstraints.BOTH,
                                                        new Insets(2, 2, 2, 2),
                                                        0,
                                                        0));

        this.add(ComponentHelper.removeEndingBufferJPanelIfAny(_borderPanel),
                 SwingTools.returnGridBagConstraints(0,
                                                        1,
                                                        1,
                                                        1,
                                                        1,
                                                        0,
                                                        GridBagConstraints.WEST,
                                                        GridBagConstraints.BOTH,
                                                        new Insets(2, 2, 2, 2),
                                                        0,
                                                        0));
        this.add(this._textInsetsPanel, SwingTools.returnGridBagConstraints(0,
                                                                               2,
                                                                               1,
                                                                               1,
                                                                               1,
                                                                               0,
                                                                               GridBagConstraints.WEST,
                                                                               GridBagConstraints.BOTH,
                                                                               new Insets(2, 2, 2, 2),
                                                                               0,
                                                                               0));
        this.add(horPanel, SwingTools.returnGridBagConstraints(0,
                                                                  3,
                                                                  1,
                                                                  1,
                                                                  1,
                                                                  0,
                                                                  GridBagConstraints.WEST,
                                                                  GridBagConstraints.BOTH,
                                                                  new Insets(2, 2, 2, 2),
                                                                  0,
                                                                  0));
        this.add(textPanel, SwingTools.returnGridBagConstraints(0,
                                                                   4,
                                                                   1,
                                                                   1,
                                                                   1,
                                                                   0,
                                                                   GridBagConstraints.WEST,
                                                                   GridBagConstraints.BOTH,
                                                                   new Insets(2, 2, 2, 2),
                                                                   0,
                                                                   0));
        this.add(new BufferJPanel(), SwingTools.returnGridBagConstraints(0,
                                                                            5,
                                                                            1,
                                                                            1,
                                                                            1,
                                                                            1,
                                                                            GridBagConstraints.WEST,
                                                                            GridBagConstraints.BOTH,
                                                                            new Insets(0, 0, 0, 0),
                                                                            0,
                                                                            0));
    }

    protected void addListeners()
    {
        this._textInsetsPanel.addListener(this);
        this._horizontalAlignmentChoices.addActionListener(this);
        this._textAlignmentChoices.addActionListener(this);
    }

    protected void removeListeners()
    {
        this._textInsetsPanel.removeListener(this);
        this._horizontalAlignmentChoices.removeActionListener(this);
        this._textAlignmentChoices.removeActionListener(this);
    }

    public TitleParameters getParameters()
    {
        return (TitleParameters)this.getManagedParameters();
    }

    public TitleParameters getDefaults()
    {
        return (TitleParameters)this.getDefaultParameters();
    }

    private boolean makeHorizontalAlignmentParameterReflectPanel()
    {
        String newValue = null;
        if(this._horizontalAlignmentChoices.getSelectedIndex() > 0)
        {
            newValue = (String)this._horizontalAlignmentChoices.getSelectedItem();
        }
        if(!ohd.hseb.hefs.utils.tools.StringTools.checkForFullEqualityOfStrings(newValue,
                                                                          getParameters().getHorizontalAlignment(),
                                                                          false))
        {
            getParameters().setHorizontalAlignment(newValue);
            return true;
        }
        return false;
    }

    private void makeHorizontalAlignmentPanelReflectParameters()
    {
        this.removeListeners();
        if(this.getParameters().getHorizontalAlignment() == null)
        {
            _horizontalAlignmentChoices.setSelectedIndex(0);
        }
        else
        {
            _horizontalAlignmentChoices.setSelectedItem(this.getParameters().getHorizontalAlignment());
        }
        this.addListeners();
    }

    private boolean makeTextAlignmentParameterReflectPanel()
    {
        String newValue = null;
        if(_textAlignmentChoices.getSelectedIndex() > 0)
        {
            newValue = (String)this._textAlignmentChoices.getSelectedItem();
        }
        if(!ohd.hseb.hefs.utils.tools.StringTools.checkForFullEqualityOfStrings(newValue,
                                                                          getParameters().getTextAlignment(),
                                                                          false))
        {
            getParameters().setTextAlignment(newValue);
            return true;
        }
        return false;
    }

    private void makeTextAlignmentPanelReflectParameters()
    {
        this.removeListeners();
        if(this.getParameters().getTextAlignment() == null)
        {
            this._textAlignmentChoices.setSelectedIndex(0);
        }
        else
        {
            this._textAlignmentChoices.setSelectedItem(this.getParameters().getTextAlignment());
        }
        this.addListeners();
    }

    private boolean makeTextInsetsParameterReflectPanel()
    {
        RectangleInsets newInsets = this._textInsetsPanel.buildInsets();
        if(!ohd.hseb.hefs.utils.tools.GeneralTools.checkForFullEqualityOfObjects(newInsets, getParameters().getTextInsets()))
        {
            getParameters().setTextInsets(newInsets);
            return true;
        }
        return false;
    }

    private void makeTextInsetsPanelReflectParameters()
    {
        this._textInsetsPanel.makePanelReflectInsets(getParameters().getTextInsets());
    }

    protected boolean makeParametersReflectPanel()
    {
        boolean changeMade = false;
        changeMade = _borderPanel.makeParametersReflectPanel() || changeMade;
        changeMade = _labelPanel.makeParametersReflectPanel() || changeMade;
        changeMade = this.makeTextInsetsParameterReflectPanel() || changeMade;
        changeMade = this.makeHorizontalAlignmentParameterReflectPanel() || changeMade;
        changeMade = this.makeTextAlignmentParameterReflectPanel() || changeMade;
        return changeMade;
    }

    @Override
    public void makePanelReflectParameters()
    {
        this._labelPanel.makePanelReflectParameters();
        this._borderPanel.makePanelReflectParameters();
        this.makeHorizontalAlignmentPanelReflectParameters();
        this.makeTextAlignmentPanelReflectParameters();
        this.makeTextInsetsPanelReflectParameters();
    }

    @Override
    public void disableSubPanel()
    {
        _horizontalAlignmentChoices.setEnabled(false);
        _textAlignmentChoices.setEnabled(false);
        this._borderPanel.disableSubPanel();
        this._labelPanel.disableSubPanel();
        this._textInsetsPanel.disableSubPanel();
    }

    @Override
    public void enableSubPanel()
    {
        //Don't work with this for now.
    }

    @Override
    public void reactToPossibleChange()
    {
        if(this.makeTextInsetsParameterReflectPanel())
        {
            this.fireParametersChanged();
        }
        this.makeTextInsetsPanelReflectParameters();
    }

    @Override
    public void actionPerformed(ActionEvent e)
    {
        if(e.getSource() == this._horizontalAlignmentChoices)
        {
            if(makeHorizontalAlignmentParameterReflectPanel())
            {
                fireParametersChanged();
            }
            this.makeHorizontalAlignmentPanelReflectParameters();
        }
        else if(e.getSource() == this._textAlignmentChoices)
        {
            if(makeTextAlignmentParameterReflectPanel())
            {
                fireParametersChanged();
            }
            this.makeTextAlignmentPanelReflectParameters();
        }
    }

    @Override
    public void parameterChanged(GeneralPlugInParameters parameters)
    {
        this.fireParametersChanged();
    }

    public static void main(String[] args)
    {
        final TitleParameters parms = new TitleParameters("border");
        TitleParameters defaultParms = new TitleParameters("border");
        defaultParms.setupDefaultParameters();
        TitleParametersPanel panel = new TitleParametersPanel(parms, defaultParms);
        JFrame display = new JFrame();
        display.setContentPane(panel);
        display.setSize(500, 500);
        display.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        display.setVisible(true);

        panel.addGraphicsGeneratorPlugInPanelListener(new GeneralPlugInPanelListener()
        {

            @Override
            public void parameterChanged(GeneralPlugInParameters parameters)
            {
                System.out.println("####>> PARAMDS -- " + parms);
            }

        });
    }
}
