package ohd.hseb.charter.plotter;

import org.jfree.chart.plot.XYPlot;

import ohd.hseb.charter.parameters.DataSourceDrawingParameters;
import ohd.hseb.charter.parameters.SeriesDrawingParameters;

/**
 * A plotter is responsible for drawing a plot type on an XY Plot. For the factory to work, all subclasses of this must
 * be placed within ohd.hseb.charter.plotter.instances.<br>
 * <br>
 * Sometimes a plotter must take the data in the JFreeChart and construct new data in order to display a plot (see
 * TimeHistogramXYChartPlotter and XYBoxWhiskerXYChartPlotter). In those cases, be sure to handle missing values in the
 * JFreeChart data appropriately. Missing values will be denoted either with null or NaN values, so you must check for
 * those instances.
 * 
 * @author herrhd
 */
public interface XYChartPlotter
{

    /**
     * The object returned should have a dummy non-null value for any of the series drawing parameters that can be used
     * to modify the series appearance. For example, since the area under lines plot does not use the line width, the
     * object return should have null set for the line width.
     * 
     * @return SeriesDrawingParameters Elements that are not null in this dummy object do affect the series appearance.
     */
    public SeriesDrawingParameters specifyApplicableParameters();

    /**
     * This is called by the ChartEngine to plot a data source. All plotters must implement this method!
     * 
     * @param plot The plot on which to draw it.
     * @param datasetIndexWithinPlot The index of the data set within the plot to apply the parameters to.
     * @param parameters The drawing parameters, dictating line color, symbol, etc.
     * @throws XYChartPlotterException If a problem occurs, such as bad parameters, unfound data sets, etc.
     */
    public void applyPlotterSettings(XYPlot plot, int datasetIndexWithinPlot, DataSourceDrawingParameters parameters) throws XYChartPlotterException;
}
