package ohd.hseb.charter.plotter;

import java.util.List;

import ohd.hseb.hefs.utils.plugins.DefaultFactory;
import ohd.hseb.hefs.utils.plugins.DefaultFactoryException;

public class XYChartPlotterFactory
{

    public final static String DEFAULT_PLOTTER_PACKAGE = "ohd.hseb.charter.plotter.instances";
    public final static String DEFAULT_PLOTTER_SUFFIX = "XYChartPlotter";

    @SuppressWarnings("rawtypes")
    private final static DefaultFactory INTERNAL_FACTORY = new DefaultFactory(DEFAULT_PLOTTER_PACKAGE,
                                                                              DEFAULT_PLOTTER_SUFFIX);

    public static XYChartPlotter loadXYChartPlotter(final String classNameOrType) throws XYChartPlotterException
    {
        try
        {
            return (XYChartPlotter)INTERNAL_FACTORY.loadInstance(classNameOrType);
        }
        catch(final DefaultFactoryException e)
        {
            throw new XYChartPlotterException("Cannot load plotter: " + e.getMessage());
        }
    }

    @SuppressWarnings("unchecked")
    public static List<String> obtainListOfPlottersInDefaultPackage() throws XYChartPlotterException
    {
        try
        {
            final List<String> results = INTERNAL_FACTORY.obtainListOfClassesWithSuffixInDefaultPackage();
            
            //Remove the internal plotters before returning.  This list is hardcoded!!!
            results.remove("Bar");
            results.remove("ScatterBoxWhisker");
            
            return results;
        }
        catch(final DefaultFactoryException e)
        {
            throw new XYChartPlotterException("Cannot obtain list of aggregators: " + e.getMessage());
        }
    }
}
