package ohd.hseb.charter.plotter.instances;

import java.awt.Color;

import ohd.hseb.charter.ChartConstants;
import ohd.hseb.charter.jfreechartoverride.GraphGenXYAreaRenderer;
import ohd.hseb.charter.parameters.DataSourceDrawingParameters;
import ohd.hseb.charter.parameters.SeriesDrawingParameters;
import ohd.hseb.charter.plotter.XYChartPlotter;
import ohd.hseb.charter.plotter.XYChartPlotterException;

import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;

/**
 * This plotter will add one dataset to the XYPlot it is given in the apply method. The index of the dataset will be at
 * the end and it will be a repeat of the original. The original data set will be plotted using a
 * LineAndScatterXYChartPlotter, while the new data set will be rendered via a GraphGenXYAreaRenderer. This allows for
 * shapes and lines to be drawn on top of the areas.
 * 
 * @author herrhd
 */
public class AreaUnderLinesXYChartPlotter implements XYChartPlotter
{

    @Override
    public void applyPlotterSettings(final XYPlot plot,
                                     final int datasetIndexWithinPlot,
                                     final DataSourceDrawingParameters parameters) throws XYChartPlotterException
    {
        //Add a copy of the dataset to the plot.
        final int newDatasetIndex = plot.getDatasetCount();
        plot.setDataset(newDatasetIndex, plot.getDataset(datasetIndexWithinPlot));
        plot.mapDatasetToRangeAxis(newDatasetIndex, parameters.getYAxisIndex());

        //Create a renderer for the line and scatter based on parameters
        //Pass in true so that blocks show up in the legend.
        final LineAndScatterXYChartPlotter lineAndScatterPlotter = new LineAndScatterXYChartPlotter(true);
        lineAndScatterPlotter.applyPlotterSettings(plot, datasetIndexWithinPlot, parameters);
        for(int i = 0; i < plot.getDataset(datasetIndexWithinPlot).getSeriesCount(); i++)
        {
            plot.getRenderer(datasetIndexWithinPlot).setSeriesVisibleInLegend(i, false);
        }

        //Setup the area plotting for the new data set!!!
        final GraphGenXYAreaRenderer renderer = new GraphGenXYAreaRenderer();
        renderer.setBaseCreateEntities(false);
        renderer.setConnectedLineAndShapeRenderer(datasetIndexWithinPlot,
                                                  (XYLineAndShapeRenderer)plot.getRenderer(datasetIndexWithinPlot));
        for(int i = 0; i < plot.getDataset(newDatasetIndex).getSeriesCount(); i++)
        {
            final Boolean b = parameters.getSeriesDrawingParametersForSeriesIndex(i).getShowInLegend();
            if(b != null)
            {
                renderer.setSeriesVisibleInLegend(i, b);
            }

            //Fill color
            final Color c = parameters.getSeriesDrawingParametersForSeriesIndex(i).getFillColor();
            if(parameters.getSeriesDrawingParametersForSeriesIndex(i).getShapeFilled())
            {
                renderer.setSeriesPaint(i, c);
            }
            else
            {
                renderer.setSeriesPaint(i, new Color(255, 255, 255, 0));
            }
        }
        plot.setRenderer(newDatasetIndex, renderer);
    }

    @Override
    public SeriesDrawingParameters specifyApplicableParameters()
    {
        final SeriesDrawingParameters dummyParms = new SeriesDrawingParameters(-1);
        dummyParms.setShowInLegend(true);
        dummyParms.setLineColor(Color.red);
        dummyParms.setLineWidth(1.0f);
        dummyParms.setFillColor(Color.black);
        dummyParms.setShapeName("HANK");
        dummyParms.setShapeSize(ChartConstants.DEFAULT_SHAPE_SIZE);
        dummyParms.setShapeFilled(true);
        dummyParms.setIncludeInPlot(true);
        dummyParms.setNameInLegend("HANK2");
        dummyParms.setBoxWidth(null);
        dummyParms.setBarWidth(null);
        return dummyParms;
    }
}
