package ohd.hseb.charter.plotter.instances;

import java.awt.Color;

import ohd.hseb.charter.ChartConstants;
import ohd.hseb.charter.jfreechartoverride.GraphGenXYStepAreaRenderer;
import ohd.hseb.charter.jfreechartoverride.GraphGenXYStepRenderer;
import ohd.hseb.charter.parameters.DataSourceDrawingParameters;
import ohd.hseb.charter.parameters.SeriesDrawingParameters;
import ohd.hseb.charter.plotter.XYChartPlotter;
import ohd.hseb.charter.plotter.XYChartPlotterException;

import org.jfree.chart.plot.XYPlot;

/**
 * This plotter will result in two new datasets added to the XYPlot it is given. Both area added at the end and are
 * repeats of the original. The origial data set (at the index provided to the apply method) will be plotted using a
 * StepXYChartPlotter. That plotter adds the first new dataset: the original is plotted as a scatter plot and the new
 * one is plotted as a step plot. This plotter will add the second new dataset afterwards, which is rendered using a
 * GraphGenXYStepAreaRenderer.
 * 
 * @author herrhd
 */
public class AreaUnderStepsXYChartPlotter implements XYChartPlotter
{

    @Override
    public void applyPlotterSettings(final XYPlot plot,
                                     final int datasetIndexWithinPlot,
                                     final DataSourceDrawingParameters parameters) throws XYChartPlotterException
    {
        //Create a renderer for the lines and shapes using the StepXYChartPlotter.
        //That plotter sets up two renderers.  For the dataset with in datasetIndexWithinPlot, it sets
        //up a line-and-scatter renderer with the lines turned off.  At the slote plot.getDatasetCount()
        //it sets up a GraphGenXYStepRenderer.  I need to turn its legend entries off.
        //The legend items that come out of this will still be drawn, but via the area renderer (below) getLegendItem() method.
        final StepXYChartPlotter stepPlotter = new StepXYChartPlotter(true); //So that blocks show up in the legend.
        stepPlotter.applyPlotterSettings(plot, datasetIndexWithinPlot, parameters);
        final int stepRendererDatasetIndex = plot.getDatasetCount() - 1;
        for(int i = 0; i < plot.getDataset(datasetIndexWithinPlot).getSeriesCount(); i++)
        {
            plot.getRenderer(stepRendererDatasetIndex).setSeriesVisibleInLegend(i, false);
        }

        //Add a copy of the dataset to the plot.
        final int stepAreaRendererDatasetIndex = plot.getDatasetCount();
        plot.setDataset(stepAreaRendererDatasetIndex, plot.getDataset(datasetIndexWithinPlot));
        plot.mapDatasetToRangeAxis(stepAreaRendererDatasetIndex, parameters.getYAxisIndex());

        //Setup the GraphGenXYStepAreaRenderer that will be used and specify its connected
        //GraphGenXYStepRenderer, and no outlining.
        final GraphGenXYStepAreaRenderer renderer = new GraphGenXYStepAreaRenderer();
        renderer.setBaseCreateEntities(false);
        renderer.setConnectedStepRenderer(stepRendererDatasetIndex,
                                          (GraphGenXYStepRenderer)plot.getRenderer(stepRendererDatasetIndex));
        renderer.setOutline(false);

        //Activities specific to the step-area renderer being used.
        for(int i = 0; i < plot.getDataset(stepAreaRendererDatasetIndex).getSeriesCount(); i++)
        {
            final Boolean b = parameters.getSeriesDrawingParametersForSeriesIndex(i).getShowInLegend();
            if(b != null)
            {
                renderer.setSeriesVisibleInLegend(i, b);
            }

            //Area fill color
            final Color c = parameters.getSeriesDrawingParametersForSeriesIndex(i).getFillColor();
            if(parameters.getSeriesDrawingParametersForSeriesIndex(i).getShapeFilled())
            {
                renderer.setSeriesPaint(i, c);
            }
            else
            {
                renderer.setSeriesPaint(i, new Color(255, 255, 255, 0));
            }

            renderer.setSeriesShape(i,
                                    ChartConstants.getShape("square",
                                                                    parameters.getSeriesDrawingParametersForSeriesIndex(i)
                                                                              .getShapeSize()));
        }
        plot.setRenderer(stepAreaRendererDatasetIndex, renderer);
    }

    @Override
    public SeriesDrawingParameters specifyApplicableParameters()
    {
        final SeriesDrawingParameters dummyParms = new SeriesDrawingParameters(-1);
        dummyParms.setShowInLegend(true);
        dummyParms.setLineColor(Color.red);
        dummyParms.setLineWidth(1.0f);
        dummyParms.setFillColor(Color.black);
        dummyParms.setShapeName("HANK");
        dummyParms.setShapeSize(ChartConstants.DEFAULT_SHAPE_SIZE);
        dummyParms.setShapeFilled(true);
        dummyParms.setIncludeInPlot(true);
        dummyParms.setNameInLegend("HANK2");
        dummyParms.setBoxWidth(null);
        dummyParms.setBarWidth(null);
        return dummyParms;
    }
}
