package ohd.hseb.charter.plotter.instances;

import java.awt.BasicStroke;
import java.awt.Color;

import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;

import ohd.hseb.charter.datasource.instances.CategoricalXYBarDataset;
import ohd.hseb.charter.parameters.DataSourceDrawingParameters;
import ohd.hseb.charter.parameters.SeriesDrawingParameters;
import ohd.hseb.charter.plotter.XYChartPlotter;
import ohd.hseb.charter.plotter.XYChartPlotterException;

/**
 * Plotter for XY categorical plots plotted as overlapping bars.
 * @author Hank.Herr
 *
 */
public class BarXYChartPlotter implements XYChartPlotter
{

    @Override
    public void applyPlotterSettings(final XYPlot plot,
                                     final int datasetIndexWithinPlot,
                                     final DataSourceDrawingParameters parameters) throws XYChartPlotterException
    {
        final XYBarRenderer renderer = new XYBarRenderer();

        for(int i = 0; i < plot.getDataset(datasetIndexWithinPlot).getSeriesCount(); i++)
        {
            final Boolean b = parameters.getSeriesDrawingParametersForSeriesIndex(i).getShowInLegend();
            if(b != null)
            {
                renderer.setSeriesVisibleInLegend(i, b);
            }

            //Fill Color
            final Color c = parameters.getSeriesDrawingParametersForSeriesIndex(i).getFillColor();
            renderer.setSeriesPaint(i, c);

            //Outline line width and color.
            final Float width = parameters.getSeriesDrawingParametersForSeriesIndex(i).getLineWidth();
            if(width <= 0)
            {
                renderer.setDrawBarOutline(false);
            }
            else
            {
                renderer.setDrawBarOutline(true);
                renderer.setSeriesOutlineStroke(i, new BasicStroke(width));
                renderer.setSeriesOutlinePaint(i,
                                               parameters.getSeriesDrawingParametersForSeriesIndex(i).getLineColor());
            }
        }

        plot.setDataset(datasetIndexWithinPlot,
                        new CategoricalXYBarDataset(plot.getDataset(datasetIndexWithinPlot),
                                                    parameters.getSeriesDrawingParametersForSeriesIndex(0)
                                                              .getBoxWidth(),
                                                    parameters.getSeriesDrawingParametersForSeriesIndex(0)
                                                              .getBarWidth()));
        plot.setRenderer(datasetIndexWithinPlot, renderer);
    }

    @Override
    public SeriesDrawingParameters specifyApplicableParameters()
    {
        final SeriesDrawingParameters dummyParms = new SeriesDrawingParameters(-1);
        dummyParms.setShowInLegend(true);
        dummyParms.setLineColor(Color.red);
        dummyParms.setLineWidth(1.0f);
        dummyParms.setFillColor(Color.black);
        dummyParms.setShapeName(null);
        dummyParms.setShapeSize(null);
        dummyParms.setShapeFilled(null);
        dummyParms.setIncludeInPlot(true);
        dummyParms.setNameInLegend("series");
        dummyParms.setBoxWidth(0.9d);//Will be misused as the overlap proportion.
        dummyParms.setBarWidth(0.9f);//Fixed box width in relation to axis.
        return dummyParms;
    }
}
