package ohd.hseb.charter.plotter.instances;

import java.awt.BasicStroke;
import java.awt.Color;

import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;

import ohd.hseb.charter.datasource.instances.TimeSeriesArraysXYDataSet;
import ohd.hseb.charter.parameters.DataSourceDrawingParameters;
import ohd.hseb.charter.parameters.SeriesDrawingParameters;
import ohd.hseb.charter.plotter.XYChartPlotter;
import ohd.hseb.charter.plotter.XYChartPlotterException;

public class TimeHistogramXYChartPlotter implements XYChartPlotter
{

    @Override
    public void applyPlotterSettings(final XYPlot plot, final int datasetIndexWithinPlot, final DataSourceDrawingParameters parameters) throws XYChartPlotterException
    {
        if(!(plot.getDataset(datasetIndexWithinPlot) instanceof TimeSeriesArraysXYDataSet))
        {
            throw new XYChartPlotterException("The data to plot must be time series to be plotted as TimeHistogram plot type, but is not.");
        }

        final XYBarRenderer renderer = new XYBarRenderer();

        for(int i = 0; i < plot.getDataset(datasetIndexWithinPlot).getSeriesCount(); i++)
        {
            if(i == 0)
            {
                renderer.setMargin(1.0D - parameters.getSeriesDrawingParametersForSeriesIndex(i).getBarWidth());
            }

            final Boolean b = parameters.getSeriesDrawingParametersForSeriesIndex(i).getShowInLegend();
            if(b != null)
            {
                renderer.setSeriesVisibleInLegend(i, b);
            }

            //Fill Color
            final Color c = parameters.getSeriesDrawingParametersForSeriesIndex(i).getFillColor();
            renderer.setSeriesPaint(i, c);

            //Outline line width and color.
            final Float width = parameters.getSeriesDrawingParametersForSeriesIndex(i).getLineWidth();
            if(width <= 0)
            {
                renderer.setDrawBarOutline(false);
            }
            else
            {
                renderer.setDrawBarOutline(true);
                renderer.setSeriesOutlineStroke(i, new BasicStroke(width));
                renderer.setSeriesOutlinePaint(i, parameters.getSeriesDrawingParametersForSeriesIndex(i).getLineColor());
            }
        }

        plot.setRenderer(datasetIndexWithinPlot, renderer);
    }

    @Override
    public SeriesDrawingParameters specifyApplicableParameters()
    {
        final SeriesDrawingParameters dummyParms = new SeriesDrawingParameters(-1);
        dummyParms.setShowInLegend(true);
        dummyParms.setLineColor(Color.red);
        dummyParms.setLineWidth(1.0f);
        dummyParms.setFillColor(Color.black);
        dummyParms.setShapeName(null);
        dummyParms.setShapeSize(null);
        dummyParms.setShapeFilled(null);
        dummyParms.setIncludeInPlot(true);
        dummyParms.setNameInLegend("HANK2");
        dummyParms.setBoxWidth(null);
        dummyParms.setBarWidth(0.9f);
        return dummyParms;
    }
}
