package ohd.hseb.charter.translator;

import ohd.hseb.charter.parameters.AxisParameters;
import ohd.hseb.charter.parameters.panels.ChartParametersPanel;

/**
 * Interface implemented by any translator plug-in.
 * 
 * @author herrhd
 */
public interface AxisTranslator
{
    public double[] computeTranslatedValue(double[] originalValues);

    public double[] computeTranslatedRawValue(double[] originalValues);

    public double[] computeOriginalValue(double[] translatedValues);

    public double computeTranslatedValue(double originalValues);

    public double computeOriginalValue(double translatedValues);

    public void setParameters(AxisTranslatorParameters parameters);

    /**
     * The AxisTranslatorParameters is a GenericParameterList. This is called to initialize the required and used
     * parameters from the constructor of any subclass in order to setup the required and used properties of the
     * GenericParameterList.
     * 
     * @param parameters
     */
    public void initializeRequiredAndUsedParameters();

    /**
     * Called to verify validity of parameters by checking to make sure all required parameters exist. The
     * DefaultAxisTranslator does this. A subclass can override it for specific checks, but should always call the
     * DefaultAxisTranslator version of this.
     * 
     * @throws AxisTranslatorException
     */
    public void checkParametersForValidity() throws AxisTranslatorException;

    /**
     * Called to eliminate any unneeded parameter from the underlying GenericParameterList.
     */
    public void clearAllButUsedParameters();

    /**
     * Called to make sure any required parameters are set, even if to useless values, in the underlying
     * GenericParameterList.
     */
    public void ensureRequiredParametersArePresent();

    /**
     * @return The name of the translator, used by the factory and XML to identify a translator.
     */
    public String getName();

    /**
     * @param axisContainingTranslator The axis parameters of the axis containing the translator, which can be used to
     *            identify the opposite axis in a ChartEngine, if needed.
     * @param managedParameters The AxisTranslatorParameters to manage.
     * @param defaultParameters The default AxisTranslatorParameters to use for the translator. This will most often be
     *            set to null.
     * @return
     */
    public ChartParametersPanel buildEditingPanel(AxisParameters axisContainingTranslator,
                                                  AxisTranslatorParameters managedParameters,
                                                  AxisTranslatorParameters defaultParameters);

    /**
     * @param unitIn The unit to translate.
     * @return A translation of the unit, or the unit itself if no translation is needed. This has been developed
     *         specifically for the purpose of being able to apply rating curves to CMSD and CFSD data while the axis
     *         also displays CMS and CFS. The *D unites should be translated to "CMS" and "CFS" respectively prior to
     *         use. This method is used within
     *         {@link AxisTranslatorParameters#getSingleOtherAxisUnitsIfOnlyOneDefined(AxisTranslator)} when determining
     *         the units of the other axis.
     */
    public String translateUnitIfNecessary(final String unitIn);
}
