package ohd.hseb.charter.translator;

/**
 * Default implementation of {@link AxisTranslator}. Its {@link #translateUnitIfNecessary(String)} method returns the
 * provide unit string.
 * 
 * @author hank.herr
 */
public abstract class DefaultAxisTranslator implements AxisTranslator
{

    private AxisTranslatorParameters _translatorParameters = new AxisTranslatorParameters();

    private String[] _requiredParameters = {};

    private String[] _usedParameters = {};

    /**
     * Called to set the required parameters for a plug-in.
     * 
     * @param parameters
     */
    public void setRequiredParameters(final String[] parameters)
    {
        this._requiredParameters = parameters;
    }

    /**
     * Called to set the used parameters for a plug-in, which must include the required parameters as a subset.
     * 
     * @param parameters
     */
    public void setUsedParameters(final String[] parameters)
    {
        _usedParameters = parameters;
    }

    @Override
    public void checkParametersForValidity() throws AxisTranslatorException
    {
        try
        {
            _translatorParameters.checkForExistenceOfParameters(_requiredParameters);
        }
        catch(final Exception e)
        {
            throw new AxisTranslatorException("Parameters are invalid: " + e.getMessage());
        }
    }

    @Override
    public void clearAllButUsedParameters()
    {
        this.getParameters().clearParametersExceptForThese(_usedParameters);
    }

    @Override
    public void ensureRequiredParametersArePresent()
    {
        for(int i = 0; i < this._requiredParameters.length; i++)
        {
            this.getParameters().ensureTheseParametersExist(_requiredParameters);
        }
    }

    @Override
    public void setParameters(final AxisTranslatorParameters parameters)
    {
        this._translatorParameters = parameters;
    }

    public AxisTranslatorParameters getParameters()
    {
        return this._translatorParameters;
    }

    @Override
    public double[] computeTranslatedValue(final double[] originalValues)
    {
        final double[] results = new double[originalValues.length];
        for(int i = 0; i < originalValues.length; i++)
        {
            results[i] = this.computeTranslatedValue(originalValues[i]);
        }
        return results;
    }

    @Override
    public double[] computeTranslatedRawValue(final double[] originalValues)
    {
        return computeTranslatedValue(originalValues);
    }

    @Override
    public double[] computeOriginalValue(final double[] translatedValues)
    {
        final double[] results = new double[translatedValues.length];
        for(int i = 0; i < translatedValues.length; i++)
        {
            results[i] = this.computeOriginalValue(translatedValues[i]);
        }
        return results;
    }

    /**
     * @return Returns the provided unit by default.
     */
    @Override
    public String translateUnitIfNecessary(final String unitIn)
    {
        return unitIn;
    }
}
