package ohd.hseb.charter.translator.plugins;

import java.util.Iterator;

public abstract class ComparableTools
{
    public static <T extends Comparable<T>> T max(Iterable<T> comparables)
    {
        Iterator<T> iterator = comparables.iterator();
        if(!iterator.hasNext())
        {
            return null;
        }
        T max = iterator.next();
        while(iterator.hasNext())
        {
            T newValue = iterator.next();
            if(max.compareTo(newValue) < 0)
            {
                max = newValue;
            }
        }
        return max;
    }

    public static <T extends Comparable<T>> T max(T... comparables)
    {
        if(comparables.length == 0)
        {
            return null;
        }
        T max = comparables[0];
        for(int i = 1; i < comparables.length; i++)
        {
            if(max.compareTo(comparables[i]) < 0)
            {
                max = comparables[i];
            }
        }
        return max;
    }

    public static <T extends Comparable<T>> T min(T... comparables)
    {
        if(comparables.length == 0)
        {
            return null;
        }
        T max = comparables[0];
        for(int i = 1; i < comparables.length; i++)
        {
            if(max.compareTo(comparables[i]) > 0)
            {
                max = comparables[i];
            }
        }
        return max;
    }
}
