package ohd.hseb.charter.translator.plugins;

import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

import ohd.hseb.charter.parameters.panels.ChartParametersPanel;
import ohd.hseb.charter.translator.AxisTranslatorParameters;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInPanelListener;
import ohd.hseb.hefs.utils.plugins.GeneralPlugInParameters;
import ohd.hseb.hefs.utils.plugins.GenericParameter;

public class LinearAxisTranslatorPanel extends ChartParametersPanel implements PropertyChangeListener
{
    private static final long serialVersionUID = 1L;

    private JFormattedTextField _coefficientField;
    private JFormattedTextField _constantField;

    public LinearAxisTranslatorPanel(AxisTranslatorParameters managedParameters,
                                     AxisTranslatorParameters defaultParameters)
    {
        //Before anything else, make sure the two parameters exist in managed parameters and have numerical values set.
        //First, the coefficient.
        if(!managedParameters.doesParameterExist(LinearAxisTranslator.COEFF_PARAMETER))
        {
            managedParameters.addParameter(LinearAxisTranslator.COEFF_PARAMETER, "1.0");
        }
        else
        {
            try
            {
                Double.parseDouble(managedParameters.getParameterWithName(LinearAxisTranslator.COEFF_PARAMETER)
                                                    .getValue());
            }
            catch(NumberFormatException e)
            {
                managedParameters.getParameterWithName(LinearAxisTranslator.COEFF_PARAMETER).setValue(1.0);
            }
        }

        //Now the constant.
        if(!managedParameters.doesParameterExist(LinearAxisTranslator.CONSTANT_PARAMETER))
        {
            managedParameters.addParameter(LinearAxisTranslator.CONSTANT_PARAMETER, "0.0");
        }
        else
        {
            try
            {
                Double.parseDouble(managedParameters.getParameterWithName(LinearAxisTranslator.CONSTANT_PARAMETER)
                                                    .getValue());
            }
            catch(NumberFormatException e)
            {
                managedParameters.getParameterWithName(LinearAxisTranslator.CONSTANT_PARAMETER).setValue(0.0);
            }
        }

        setManagedParameters(managedParameters);
        setDefaultParameters(defaultParameters);
        createDisplay();
        makePanelReflectParameters();
    }

    private GenericParameter getCoefficientParameter()
    {
        return getParameters().getParameterWithName(LinearAxisTranslator.COEFF_PARAMETER);
    }

    private GenericParameter getConstantParameter()
    {
        return getParameters().getParameterWithName(LinearAxisTranslator.CONSTANT_PARAMETER);
    }

    private void createDisplay()
    {
        _coefficientField = new JFormattedTextField();
        _coefficientField.setValue(Double.valueOf(getCoefficientParameter().getValueAsDouble()));
        _coefficientField.setColumns(10);
        _coefficientField.addPropertyChangeListener("value", this);

        _constantField = new JFormattedTextField();
        _constantField.setValue(Double.valueOf(getConstantParameter().getValueAsDouble()));
        _constantField.setColumns(10);
        _constantField.addPropertyChangeListener("value", this);

        this.setLayout(new FlowLayout(FlowLayout.LEFT));
        this.add(new JLabel("Coefficient: "));
        this.add(_coefficientField);
        this.add(new JLabel("Constant: "));
        this.add(_constantField);
    }

    public AxisTranslatorParameters getParameters()
    {
        return (AxisTranslatorParameters)this.getManagedParameters();
    }

    @Override
    public void makePanelReflectParameters()
    {
        try
        {
            _coefficientField.setValue(getCoefficientParameter().getValueAsDouble());
        }
        catch(NumberFormatException e)
        {
            _coefficientField.setValue(1.0D);
        }

        try
        {
            _constantField.setValue(getConstantParameter().getValueAsDouble());
        }
        catch(NumberFormatException e)
        {
            _constantField.setValue(0.0D);
        }
    }

    @Override
    public void disableSubPanel()
    {
        this._coefficientField.setEnabled(false);
        this._constantField.setEnabled(false);
    }

    @Override
    public void enableSubPanel()
    {
        this._coefficientField.setEnabled(true);
        this._constantField.setEnabled(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0)
    {
        if(arg0.getSource() == this._coefficientField)
        {
            getCoefficientParameter().setValue((Double)_coefficientField.getValue());
            this.fireParametersChanged();
        }
        else if(arg0.getSource() == this._constantField)
        {
            getConstantParameter().setValue((Double)_constantField.getValue());
            this.fireParametersChanged();
        }
    }

    public static void main(String[] args)
    {
        AxisTranslatorParameters parms = new AxisTranslatorParameters();
        parms.setTranslatorName("Linear");
        parms.addParameter("coefficient", "2.0");
        parms.addParameter("constant", "-1.0");

        LinearAxisTranslatorPanel panel = new LinearAxisTranslatorPanel(parms, null);
        panel.addGraphicsGeneratorPlugInPanelListener(new GeneralPlugInPanelListener()
        {

            @Override
            public void parameterChanged(GeneralPlugInParameters parameters)
            {
                System.out.println("####>> " + parameters);
            }

        });
        JOptionPane.showMessageDialog(null, panel);
    }

}
