/*
 * Created on Aug 6, 2003
 * Chip Gobs
 */
package ohd.hseb.db;

import java.sql.*;
import java.util.*;
import java.util.Date;

import ohd.hseb.time.DateTime;
import ohd.hseb.util.fews.OHDConstants;


/**
 * @author Chip Gobs
 * This class is the abstract super class of all generated subclasses.
 * It provides some common methods that do not need to be implemented by
 * each generated class. 
 */
public abstract class DbTable 
{
	private String _tableName;
	private Database _database;
	
	
    public abstract List select(String where) throws SQLException;

 
	protected DbTable(Database database)
	{
	   _database = database;	
	}
	
	protected Database getDatabase()
	{
		return _database;
	}
	
	protected Statement getStatement()
	{
	    return _database.getStatement();	
	}
	
	protected  Connection getConnection()
	{
	    return _database.getConnection();
	}
	
	protected void setDatabase(Database database)
	{
	    _database = database;	
	}
    
 	
    public String getTableName()
    {
        return _tableName;    	
    }
    
	public void setTableName(String tableName)
	{
		   _tableName = tableName;    	
	}
    
	
	//	*****************************************************************************
	//	  printRecordList() - this method is called with a List of CurPrecipRecord
	//		  objects and prints them to standard out
	//	*****************************************************************************

	public void printRecordList(List recordList)
	{
			DbRecord record = null;

			for(int ctr=0; ctr<recordList.size(); ctr++)
			{
				record = (DbRecord)recordList.get(ctr);
				System.out.println( record.toString() );
			}

			System.out.println(recordList.size() + " record(s) returned from printRecord. ");

	} // end of printRecordList method

// ---------------------------------------------------------	
	public String getStringFromDate(java.sql.Date date)
	{
		return DbTimeHelper.getStringFromDate(date); 
	}	
//-------------------------------------------------------
	public long getLongTimeFromDateTimeString(String timeString)
	{
		return DbTimeHelper.getLongTimeFromDateTimeString(timeString);
	}
//	---------------------------------------------------------	

	public long getLongTimeFromDateString(String timeString)
	{
		return DbTimeHelper.getLongTimeFromDateString(timeString);
	}
//		---------------------------------------------------------	
	public String getDateTimeStringFromLongTime(long time)
	{
	    return DateTime.getDateTimeStringFromLong(time, OHDConstants.GMT_TIMEZONE); 
	}
//	---------------------------------------------------------	
	
    public String getDateStringFromLongTime(long time)
	{
		return DbTimeHelper.getDateStringFromLongTime(time); 
	}
    
//	---------------------------------------------------------	

	public String getStringFromTimestamp(Timestamp timestamp)
	{
	    return DbTimeHelper.getStringFromTimestamp(timestamp);
	}

//  ---------------------------------------------------------   

    public String getTrimmedString(String string)
    {
        if (string != null)
        {
            string = string.trim();    
        }    
        
        return string;
    }

	// *****************************************************************************
	//	getTimeStampFromString() is used to convert DateTime year to sec variables
	//	It is typically called from a concrete generated class to 
	//  get the time in the database in UTC - which is to say, the time the database
	//  already stores it as.
	// *****************************************************************************
	public Date getDateTimeFromString(String timeString)
	{
		return DbTimeHelper.getDateTimeFromString(timeString);
	}

	// *****************************************************************************
	//	getDateFromString() is used to convert Date year to day variables
	//	It is typically called from a concrete generated class to 
	//  get the time in the database in UTC - which is to say, the time the database
	//  already stores it as.
	// *****************************************************************************
	public Date getDateFromString(String timeString)
	{
		return DbTimeHelper.getDateFromString(timeString);
	}

//	*****************************************************************************
//	  selectCount returns the count of records in the database
//	  that meet the select criteria in the where clause.
//	*****************************************************************************

	public int selectCount(String where) throws SQLException
	{
		int recordCount = -1;
	

		// Create the SQL statement and issue it
	
		// construct the select statment
		String selectStatement = "SELECT count(*) FROM "  + 
								 getTableName() + " " + where;

		// get the result set back from the query to the database
		ResultSet rs = _database.getStatement().executeQuery(selectStatement);

		// loop through the result set
		while (rs.next())
		{
			//store the recordCount
			recordCount = rs.getInt(1);
		}
			// Close the result set
		rs.close();
	
		// return a List which holds the CurPrecipRecord objects
		return recordCount;

	} // end of selectCount method


}
