package ohd.hseb.grid;

import ohd.hseb.util.fews.OHDConstants;

final public class NetcdfConstants
{
    private NetcdfConstants()
    {
        /*
         * This class only contains static constants and methods, so an instance of this class should never be created.
         * If not providing this private constructor, users still can create objects of this class by using the
         * invisible default constructor provided by Java, which is wrong. Now, with this private constructor, the
         * default constructor by Java is destroyed. Now, nobody from outside of this class can create the object of
         * this class
         */
    }

    /** NETCDF "x" */
    public final static String NETCDF_X_VAR_NAME = "x";
    /** NETCDF "y" */
    public final static String NETCDF_Y_VAR_NAME = "y";

    /** NETCDF "lon" */
    public final static String NETCDF_LON_VAR_NAME = "lon";
    /** NETCDF "lat" */
    public final static String NETCDF_LAT_VAR_NAME = "lat";

    /** NETCDF "time" */
    public final static String NETCDF_TIME_VAR_NAME = "time";
    /** NETCDF "duration" */
    public final static String NETCDF_DURATION_VAR_NAME = "duration";
    /** NETCDF "THRESHR" */
    public final static String NETCDF_THRESHOLD_RUNOFF_VAR_NAME = "THRESHR";
    /** NETCDF "FFG" */
    public final static String NETCDF_FFG_VAR_NAME = "FFG";
    /** char_index */
    public final static String NETCDF_CHAR_INDEX_DIM_NAME = "char_index";

    /** The mesh length at 60 degree North latitude is 4762.5 Meter */
    public final static float NETCDF_GRID_LENGTH_IN_METER = 4762.5f;
    /** NORTH POLE ROW 1601 */
    public final static int NORTH_POLE_HRAP_Y = 1601;
    /** NORTH POLE Column 401 */
    public final static int NORTH_POLE_HRAP_X = 401;

    /** 1000 It is for storing the String of OPERATION_CONTENTS */
    public static final int NETCDF_MAX_STRING_LENGTH = 1000;

    /** 125 For regular string */
    public static final int NETCDF_REGULAR_STRING_MAX_LENGTH = 125;

    /** -999.0f */
    public static final float FLOAT_MISSING_VALUE = (float)OHDConstants.MISSING_DATA;

    public static final String STRING_MISSING_VALUE = "";

    /** MISSING */
    public static final String MISSING_STR = "MISSING";

    /** IN */
    public static final String UNIT_INCH = "IN";

    /** 9.96921E36 */
    public static final double NETCDF_DEFAULT_MISSING_VALUE = 9.96921E36;
    public final static String LATOFFIRSTGRIDPOINT = "latOfFirstGridPoint";
    public final static String LONOFFIRSTGRIDPOINT = "lonOfFirstGridPoint";
    public final static String LONORIGIN = "lonOrigin";
    public final static String XCELLSIZE = "xCellSize";
    public final static String YCELLSIZE = "yCellSize";
    public final static String XCELLSIZE_VAL = "4762";
    public final static String YCELLSIZE_VAL = "4762";
    public final static String LONORIGIN_VAL = "-105000";

    /** "inputNetcdfParamsFileDir" */
    public final static String INPUT_NETCDF_PARAMSFILE_DIR = "inputNetcdfParamsFileDir";

    /** "outputNetcdfFile" */
    public final static String OUTPUT_NETCDF_FILE = "outputNetcdfFile";

    /** "FillValue" */
    public final static String FILL_VALUE_ATT = "FillValue";

    /** "MASK" */
    public final static String MASK_VAR_NAME = "MASK";

    /** "Prec" */
    public final static String PRECIP_VAR_NAME = "Prec";

    /** "Tmax" */
    public final static String TMAX_VAR_NAME = "Tmax";

    /** "Tmin" */
    public final static String TMIN_VAR_NAME = "Tmin";
}
