package ohd.hseb.grid;

import net.jcip.annotations.Immutable;

@Immutable
public class RfcHrapGrid
{
    private final int _westCol; //x
    private final int _southRow; //y
    private final int _colNum;
    private final int _rowNum;

    /**
     * @param westCol
     * @param southRow
     * @param colNum
     * @param rowNum
     */
    public RfcHrapGrid(final int westCol, final int southRow, final int colNum, final int rowNum)
    {
        _westCol = westCol;
        _southRow = southRow;
        _colNum = colNum;
        _rowNum = rowNum;
    }

    public int getMaxRow()
    {
        return _southRow + _rowNum;
    }

    public int getMaxColumn()
    {
        return _westCol + _colNum;
    }

    public int getColNum()
    {
        return _colNum;
    }

    public int getRowNum()
    {
        return _rowNum;
    }

    /** get Polar Stereographic Y coordinate with units of meters based on the row number in this rfc, starting at 0 */
    public int getYSter(final int rowIndex)
    {
        final int hrapy = _southRow + rowIndex;

        final int yster = GridUtilities.getPolarStereoYFromHrapRow(hrapy);

        return yster;
    }

    /** get Polar Stereographic X coordinate with units of meters based on the column number in this rfc, starting at 0 */
    public int getXSter(final int colIndex)
    {
        final int hrapx = _westCol + colIndex;

        final int xster = GridUtilities.getPolarStereoXFromHrapColumn(hrapx);

        return xster;
    }

    /**
     * Convert from RFC local column(starting at 0) to national HRAP column
     * 
     * @param localCol
     * @return
     */
    public int getHrapColumn(final int localCol)
    {
        return _westCol + localCol;
    }
}
