/*
 * Created on Jul 2, 2003
 */
package ohd.hseb.measurement;

/**
 * @author gobsc This class is basically an enum for the possible types of MeasuringUnits. distance, volume, flow
 */
final public class MeasuringUnitType
{

    public static final MeasuringUnitType length = new MeasuringUnitType("L");
    public static final MeasuringUnitType discharge = new MeasuringUnitType("L3/T");
    public static final MeasuringUnitType volume = new MeasuringUnitType("L3");
    public static final MeasuringUnitType elapsedTime = new MeasuringUnitType("TIME");
    public static final MeasuringUnitType temperature = new MeasuringUnitType("TEMP");
    public static final MeasuringUnitType speed = new MeasuringUnitType("L/T");
    public static final MeasuringUnitType direction = new MeasuringUnitType("DIR");
    public static final MeasuringUnitType unitless = new MeasuringUnitType("DLES");

    private String _name = null;

    //private constructor
    private MeasuringUnitType(final String typeName)
    {
        _name = typeName;
    }

    public String getName()
    {
        return _name;
    }

    @Override
    public String toString()
    {
        return _name;

    } //toString

}
