/*
 * Created on Oct 14, 2003
 */
package ohd.hseb.measurement;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Chip Gobs This is a simple Holder class for a TimeSeries object It will forward TimeSeriesEvents to the
 *         listeners. It won't notify the listener with the same Receiver as the Event's source.
 */
final public class RegularTimeSeriesHolder
{
    private RegularTimeSeries _timeSeries;
    private final List<TimeSeriesListener> _listenerList = new ArrayList<TimeSeriesListener>();

    private long _eventCount = 0;

    public void setTimeSeries(final RegularTimeSeries timeSeries)
    {
        _timeSeries = timeSeries;
    }

    public void forwardEvent(final TimeSeriesEvent event)
    {
        event.setEventId(_eventCount);

        notifyListeners(event);

        _eventCount++;
    }

    public RegularTimeSeries getTimeSeries()
    {
        return _timeSeries;
    }

    public void addListener(final TimeSeriesListener listener)
    {
        _listenerList.add(listener);
    }

    public void removeListener(final TimeSeriesListener listener)
    {
        _listenerList.remove(listener);
    }

    private void notifyListeners(final TimeSeriesEvent event)
    {
        for(int i = 0; i < _listenerList.size(); i++)
        {
            final TimeSeriesListener listener = _listenerList.get(i);

            if(listener.getReceiver() != event.getSource())
            {
                listener.handleTimeSeriesEvent(event);
            }
        }
    }

}
