package ohd.hseb.model.sacsma;

import java.util.EnumSet;

import ohd.hseb.util.fews.DataType;
import ohd.hseb.util.fews.OHDConstants;

/**
 * All SacSma MODS depends on LSTCMPDY. All the mods must be earlier or equal to LSTCMPDY. Any mods after LSTCMPDY are
 * ignored.
 */
public enum SacSma_MODS
{
    UZTWD(DataType.UZTWD_DATATYPE), //unit MM upper tension water deficit 
    LZTWD(DataType.LZTWD_DATATYPE), //unit MM lower tension water deficit
    UZTWCADJ(DataType.UZTWCADJ_DATATYPE), //unit MM adjusted (increase/decrease) upper tension water
    LZTWCADJ(DataType.LZTWCADJ_DATATYPE), //unit MM adjusted lower tension water
    UZTWC(OHDConstants.SAC_STATE_UZTWC), //unit MM
    UZFWC(OHDConstants.SAC_STATE_UZFWC), //unit MM
    LZTWC(OHDConstants.SAC_STATE_LZTWC), //unit MM
    LZFPC(OHDConstants.SAC_STATE_LZFPC), //unit MM
    LZFSC(OHDConstants.SAC_STATE_LZFSC), //unit MM
    ADIMC(OHDConstants.SAC_STATE_ADIMC), //unit MM
    FGIX(DataType.FGIX_DATATYPE), //unit DEGC
    SACBASEF(OHDConstants.SAC_MOD_BASEF); //unit unitlessReal

    public static final EnumSet<SacSma_MODS> SACCO_MODS = EnumSet.range(UZTWD, FGIX); //FGIX MOD was not SACCO MODS, included here to single out SACBASEF_MOD

    final private String _dataType; //will not be changed

    private SacSma_MODS(final String modType)
    {
        _dataType = modType;
    }

    public String getDataType()
    {
        return _dataType;
    }

}
