package ohd.hseb.ohdfewsadapter.util.readWriteBinaryData;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

import ohd.hseb.util.io.EndianConvertingInputStream;
/**
 * Read a binary file and store the float data into an array list
 * @author <a href="mailto:Raymond.Chui@noaa.gov">Raymond.Chui@noaa.gov</a>
 * @since CHPS, July, 2008
 * @version 1.0
 *
 */
public class ReadTimeSeriesBinaryFile {
	
	
	/** store the binary float data into this array list */
	private ArrayList<Float> _arrayList;
	
	/**
	 * Constructor
	 * @param binaryFileName - input binary file name
	 * @throws FileNotFoundException
	 */
	public ReadTimeSeriesBinaryFile() {	
		_arrayList = new ArrayList<Float>();
	}
	
	/**
	 * Read the binary float data and store them into an array list
	 * @throws IOException
	 * @throws FileNotFoundException
	 */
	public void readBinaryFile(final String binaryFileName) throws IOException,
	        FileNotFoundException {
		FileInputStream fileInputStream = new FileInputStream(new File(binaryFileName));
		EndianConvertingInputStream binaryReader = new EndianConvertingInputStream(fileInputStream);
		    float floatData;		
			while (fileInputStream.available() > 0) {
			    floatData = binaryReader.readFloatSwap();
			    //System.out.println("float = " + floatData);
			    _arrayList.add(Float.valueOf(floatData));
			}
			fileInputStream.close();
			binaryReader.close();
	} // end method
	
	/**
	 * Get the array list
	 * @return An array list object
	 */
	public ArrayList<Float> getArrayLinkList() {
		return _arrayList;
	}
	/**
	 * Set an array list
	 * @param arrayList -- set this array list
	 */
	public void setArrayList(ArrayList<Float> arrayList) {
		_arrayList = arrayList;
	}
}