package ohd.hseb.ohdfewsadapter.util.readWriteBinaryData;

import java.io.FileNotFoundException;
import java.io.IOException;

import javax.xml.parsers.ParserConfigurationException;


import ohd.hseb.ohdfewsadapter.util.FEWSXMLSAXHandler;
import ohd.hseb.util.xml.OHDXmlUtils;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/**
 * This class is read an XML file and store the whole document into
 * a 3W DOM Document object by the FEWSXMLSAXHandler
 * <a href="mailto:Raymond.Chui@noaa.gov">chuir</a>
 * @since CHPS, July 2008
 * @version 1.0
 * @see FEWSXMLSAXHandler
 *
 */
public class ReadTimeSeriesXMLFile {
	/** the default SAX handler */
	FEWSXMLSAXHandler _defaultHandler;
	/**
	 * The constructor
	 */
	public ReadTimeSeriesXMLFile() {
		
		_defaultHandler = new FEWSXMLSAXHandler();
	}
	
	/**
	 * Read the XML file and store it into 3W DOM Document object by the default handler
	 * @param xmlFile -- the input XML file
	 * @throws ParserConfigurationException
	 * @throws SAXException
	 * @throws IOException
	 */
	public void readXMLFile(final String xmlFile) throws 
	    ParserConfigurationException, 
	    SAXException, 
	    IOException,
	    FileNotFoundException {
		OHDXmlUtils.parse(xmlFile, _defaultHandler);
	}
	
	/**
	 * Get the handler
	 * @return - default handler
	 */
	public FEWSXMLSAXHandler getDefaultHandler() {
		return _defaultHandler;
	}
	/**
	 * Set handler
	 * @param defaultHandler - default handler
	 */
	public void setDefaultHandler(FEWSXMLSAXHandler defaultHandler) {
		_defaultHandler = defaultHandler;
	}
	/**
	 * Get the 3W DOM Document object
	 * @return - document object
	 */
	public Document getXMLDocument() {
		return _defaultHandler.getDocument();
	}
	/**
	 * Set the 3W DOM Document object
	 * @param document - document object
	 */
	public void setXMLDocument(Document document) {
		_defaultHandler.setDocument(document);
	}
	/**
	 * Get the debugging level
	 * @return debug level
	 */
	public int getDebugLevel() {
		return _defaultHandler.getFEWSDebug();
	}
	/**
	 * Set the debugging level
	 * @param debugLevel - debug level
	 */
	public void setDebugLevel(int debugLevel) {
		_defaultHandler.setFEWSDebug(debugLevel);
	}
}