package ohd.hseb.ohdfewsadapter.util.readWriteBinaryData;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

import javax.xml.parsers.ParserConfigurationException;

import ohd.hseb.ohdfewsadapter.util.FEWSXMLDOMUtilities;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;
/**
 * This class let you read a time series XML file, then split it into
 * a binary file with event data and a XML file with series headers
 * @author <a href="mailto:Raymond.Chui@noaa.gov">Raymond.Chui@noaa.gov</a>
 * @since CHPS, August, 2008
 * @version 1.0
 * @see ReadTimeSeriesXMLFile, WriteTimeSeriesBinaryFile
 *
 */
public class SplitTimeSeriesXML2BinaryAndHeaderFiles {
	/** XML 3W DOM document */
	private Document _document;
	/** Write to this binary file name*/
	private String _binaryFileName;
	/** Write to this XML file name*/
	private String _xmlFileName;
	/** Debug level 0- 9 */
	private int _FEWSDEBUG = -1;
	/** save the binary data */
	private ArrayList<Float> _arrayList;
	
	/**
	 * Constructor with document, binary and XML file names
	 * @param document - the 3W DOM document
	 * @param binaryFileName - binary file name
	 * @param xmlFileName - XML file name
	 */
	public SplitTimeSeriesXML2BinaryAndHeaderFiles(Document document,
			String binaryFileName,
			String xmlFileName) {
		
		setDocument(document);
		setBinaryFileName(binaryFileName);
		setXMLFileName(xmlFileName);
		_arrayList = new ArrayList<Float>();
	}
	/**
	 * Constructor with binary and XML file names
	 * @param binaryFileName - binary file name
	 * @param xmlFileName - XML file name
	 */
	public SplitTimeSeriesXML2BinaryAndHeaderFiles(
			String binaryFileName,
			String xmlFileName) {
		
		setBinaryFileName(binaryFileName);
		setXMLFileName(xmlFileName);
		_arrayList = new ArrayList<Float>();
	}
	/**
	 * Set debug level
	 * @param FEWSDEBUG - debug level 0 - 9
	 */
	public void setDebug(int level) {
		_FEWSDEBUG = level;
	}
	/**
	 * Get debug level
	 * @return debug level
	 */
	public int getDebug() {
		return _FEWSDEBUG;
	}
	/**
	 * Read an input time serires XML file
	 * @param xmlFileName - input XML file name
	 * @throws FileNotFoundException
	 * @throws ParserConfigurationException
	 * @throws SAXException
	 * @throws IOException
	 */
	public void readTextXMLFile(final String xmlFileName) throws 
	    FileNotFoundException, 
	    ParserConfigurationException, 
	    SAXException, 
	    IOException {
		
		ReadTimeSeriesXMLFile readTimeSeriesXMLFile = new ReadTimeSeriesXMLFile();
		readTimeSeriesXMLFile.readXMLFile(xmlFileName);
		setDocument(readTimeSeriesXMLFile.getXMLDocument());
	}
	/**
	 * Split the time series XML file into a binary event data file
	 * and series headers XML file
	 * @throws NumberFormatException
	 * @throws IOException
	 */
	public void split() throws 
	    NumberFormatException, 
	    IOException {
		
		// Part I, write event data into a binary file
		WriteTimeSeriesBinaryFile writeTimeSeriesBinaryFile = new WriteTimeSeriesBinaryFile(_document);
		writeTimeSeriesBinaryFile.writeBinaryFile(_binaryFileName);
		setArrayList(writeTimeSeriesBinaryFile.getArrayList());
		
		// Part II, write remain document into an XML file
		File outFile = new File(_xmlFileName);
    	if (outFile.exists())
    		outFile.delete();
    	RandomAccessFile out = new RandomAccessFile(outFile, "rw");
    	FEWSXMLDOMUtilities domUtilites = new FEWSXMLDOMUtilities(out);
    	StringBuilder stringBuilder = new StringBuilder();
    	domUtilites.clearStack();
		domUtilites.traverseXMLDocument(_document, stringBuilder, "    ");
		domUtilites.writeBytes(stringBuilder);
		out.close();
	}
	
	public void setDocument(Document document) {
		_document = document;
	}
	public Document getDocument() {
		return _document;
	}
	public void setBinaryFileName(String binaryFileName) {
		_binaryFileName = binaryFileName;
	}
	public String getBinaryFileName() {
		return _binaryFileName;
	}
	public void setXMLFileName(String xmlFileName) {
		_xmlFileName = xmlFileName;
	}
	public String getXMLFileName() {
		return _xmlFileName;
	}
	/**
	 * Get the array list
	 * @return An array list object
	 */
	public ArrayList<Float> getArrayList() {
		return _arrayList;
	}
	/**
	 * Set an array list
	 * @param arrayList -- set this array list
	 */
	public void setArrayList(ArrayList<Float> arrayList) {
		_arrayList = arrayList;
	}
}