package ohd.hseb.ohdfewsadapter.util.readWriteBinaryData;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

import ohd.hseb.util.io.EndianConvertingOutputStream;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
/**
 * This class is write the time series event data into a binary file
 * @author <a href="mailto:Raymond.Chui@noaa.gov">Raymond.Chui@noaa.gov</a>
 * @since CHPS, August, 2008
 * @version 1.0
 * @see EndianConvertingOutputStream
 *
 */
public class WriteTimeSeriesBinaryFile {
	/** 3W DOM document */
	private Document _document;
	/** debug level 0 -9 */
	private int _FEWSDEBUG = -1;
	/** Store the data into this array list */
	private ArrayList<Float> _arrayList;
	
	/**
	 * Constructor with set the document object
	 * @param document
	 */
	public WriteTimeSeriesBinaryFile(Document document) {
		setDocument(document);
		_arrayList = new ArrayList<Float>();
	}
	/**
	 * Set the document object
	 * @param document -- document object
	 */
	public void setDocument(Document document) {
		_document = document;
	}
	/**
	 * Get the document object
	 * @return document object
	 */
	public Document getDocument() {
		return _document;
	}
	/**
	 * Set debug level
	 * @param FEWSDEBUG - debug level 0 - 9
	 */
	public void setDebug(int level) {
		_FEWSDEBUG = level;
	}
	/**
	 * Get debug level
	 * @return debug level
	 */
	public int getDebug() {
		return _FEWSDEBUG;
	}
	/**
	 * Get the array list
	 * @return An array list object
	 */
	public ArrayList<Float> getArrayList() {
		return _arrayList;
	}/**
	 * Set an array list
	 * @param arrayList -- set this array list
	 */
	public void setArrayList(ArrayList<Float> arrayList) {
		_arrayList = arrayList;
	}
	
	/**
	 * Write the time series event data into a binary file
	 * @param binaryFileName - binary file name
	 * @throws IOException
	 */
	public void writeBinaryFile(final String binaryFileName) throws IOException {
		FileOutputStream fileOutputStream = new FileOutputStream(new File(binaryFileName));
		EndianConvertingOutputStream binaryWriter = new EndianConvertingOutputStream(fileOutputStream);
		
		Element timeSeries = (Element)_document.getFirstChild();
		NodeList serieses = timeSeries.getElementsByTagName("series");
		for (int i = 0; i < serieses.getLength(); i++) {
			Element series = (Element)serieses.item(i);
			NodeList events = series.getElementsByTagName("event");
			while (events.getLength() > 0) {
				Element event = (Element)events.item(0);
				Attr value = event.getAttributeNode("value");
				float floatValue = Float.parseFloat(value.getNodeValue());
				if (_FEWSDEBUG > 0)
					System.out.println("float = " + floatValue);
				binaryWriter.writeFloatSwap(floatValue);
				_arrayList.add(Float.valueOf(floatValue)); // save for later use
				series.removeChild(event);
				//events = series.getElementsByTagName("event");
			} // end while loop
		} // end outer for loop
		binaryWriter.close();
		fileOutputStream.close();
	}
}