package ohd.hseb.ohdfewsadapter.util.timeseriesconverter;

/**
 * A class has all the constant variables for FewsOptFileConverter object
 * 
 * @author <a href="mailto:Raymond.Chui@noaa.gov">Raymond.Chui@noaa.gov</a>
 * @version 1.0
 * @since CHPS Created: April, 2008
 * @see FewsTimeSeriesConverter
 */
final public class FewsTimeseriesConverterConstants
{
    private FewsTimeseriesConverterConstants()
    {
        /*
         * This class only contains static constants and methods, so an instance of this class should never be created.
         * If not providing this private constructor, users still can create objects of this class by using the
         * invisible default constructor provided by Java, which is wrong. Now, with this private constructor, the
         * default constructor by Java is destroyed. Now, nobody from outside of this class can create the object of
         * this class
         */
    }

    public final static String[] headerCard1 = {"fileDescription", "parameterId", "type", "units", "timeStep",
        "locationId", "longName"};
    public final static int fileName = 0;
    public final static int dataType = 1;
    public final static int dimension = 2;
    public final static int unit = 3;
    public final static int timeStep = 4;
    public final static int statationID = 5;
    public final static int statationDescription = 6;

    public final static int[] headerCard1Index = {0, // file name column 0 - 11
        14, // data type code 14 - 17
        19, // data dimension 19 - 22
        24, // data units code 24 - 27
        29, // data time interval 29 - 30
        34 // time series identifier 34 - 45
    };

    public final static String[] headerCard2 = {"startMonth", "startYear", "endMonth", "endYear", "flag", "format"};
    public final static int startMonth = 0;
    public final static int startYear = 1;
    public final static int endMonth = 2;
    public final static int endYear = 3;
    public final static int column = 4;
    public final static int format = 5;

    public final static String[] valueCard = {"statationID", "monthYear", "day", "value"};
    public final static int statationIDColumn = 0;
    public final static int monthYear = 1;
    public final static int day = 2;
    public final static int value = 3;

    public final static String[] timeSeriesHeader = {"type", "locationId", "parameterId", "qualifierId", "timeStep",
        "startDate", "endDate", "missVal", "longName", "stationName", "units", "sourceOrganisation", "sourceSystem",
        "fileDescription", "creationDate", "creationTime", "region"};
}