package ohd.hseb.ohdfewsadapter.util.timeseriesconverter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class FewsTimeseriesScriptGenerator
{
    private static BufferedReader reader = null;
    private static BufferedWriter debugWriter = null;
    private static BufferedWriter genXmlWriter = null;

    private static final String DOWNSTREAM = "DOWNSTREAM";
    private static final String UNDEFINED = "undefined";
    private static final String INPUT = "INPUT";
    private static final String OUTPUT = "OUTPUT";
    private static final String END = "END";
    private static final String DEF_TS = "DEF-TS";
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");;
    private static Date forecastDate = null;
    private static Date endDate = null;
    private static Date startDate = null;
    private static String ofsLevel = null;

    public static void main(final String[] args) throws IOException
    {
        String inputDirectory = System.getProperty("inputDir");
        // if input directory is not defined, then try to get from 1st argument
        if(inputDirectory == null || inputDirectory.equals(""))
        {
            try
            {
                inputDirectory = args[0];
            }
            catch(final Exception e)
            { // if there is no 1st argument, then assume from "input" directory
                inputDirectory = "input";
            }
        }
        final File inputDir = new File(inputDirectory);
        if(!inputDir.exists())
        {
            System.err.println("Input directory " + inputDir + " does not exist");
            return;
        }

        if(!inputDir.isDirectory())
        {
            System.err.println(inputDirectory + " is not a directory");
            return;
        }

        final String configTextFile = System.getProperty("configFile");
        File configFile = null;
        // if config file is not defined, then try to get from input directory "config.txt" file
        if(configTextFile == null || configTextFile.equals(""))
        {
            configFile = new File(inputDir.getAbsoluteFile(), "config.txt");
            if(!configFile.exists())
            {
                System.err.println("Config file not found in directory: " + inputDir.getName());
                return;
            }
        }
        else
        { // get config file by defined
            configFile = new File(configTextFile);
            if(!configFile.exists())
            {
                System.err.println(configTextFile + " config file not found");
                return;
            }
        }

        final BufferedReader configReader = new BufferedReader(new FileReader(configFile));
        //simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        // read the config file
        for(String line = null; (line = configReader.readLine()) != null;)
        {
            final String[] split = line.split("=");
            if(split[0].equals("startDate"))
            {
                //simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try
                {
                    startDate = simpleDateFormat.parse(split[1]);
                }
                catch(final ParseException e)
                {
                    System.err.println("Unable to parse date " + split[1] + " with pattern "
                        + simpleDateFormat.toPattern());

                    configReader.close();
                    throw new RuntimeException(e);
                }
            }
            if(split[0].equals("forecastDate"))
            {
                try
                {
                    forecastDate = simpleDateFormat.parse(split[1]);
                }
                catch(final ParseException e)
                {
                    System.err.println("Unable to parse date " + split[1] + " with pattern "
                        + simpleDateFormat.toPattern());

                    configReader.close();
                    throw new RuntimeException(e);
                }
            }
            if(split[0].equals("endDate"))
            {
                try
                {
                    endDate = simpleDateFormat.parse(split[1]);
                }
                catch(final ParseException e)
                {
                    System.err.println("Unable to parse date " + split[1] + " with pattern "
                        + simpleDateFormat.toPattern());

                    configReader.close();
                    throw new RuntimeException(e);
                }
            }
            if(split[0].equals("ofsLevel"))
            {
                ofsLevel = split[1];
            }
        }

        configReader.close();

        if(ofsLevel == null || ofsLevel.equals(""))
        {
            System.err.println("There is no OFS Level definded in config file, ofsLevel = " + ofsLevel);
            return;
        }

        final String outputTextDir = System.getProperty("outputDir");
        File outputDir = null;
        // if output directory is not defined, then presume under input/output directory
        if(outputTextDir == null || outputTextDir.equals(""))
        {
            outputDir = new File(inputDir.getAbsoluteFile(), "output");
            if(!outputDir.exists()) // if it not exists, then create it
            {
                if(!outputDir.mkdir())
                {
                    System.err.println("Unable to create output directory in directory" + inputDir.getName());
                    return;
                }
            }
        }
        else
        // get output directory by defined
        {
            outputDir = new File(outputTextDir);
            if(!outputDir.isDirectory())
            {
                System.err.println(outputTextDir + " is not a directory");
                return;
            }
            else if(!outputDir.exists())
            {
                if(!outputDir.mkdir())
                {
                    System.err.println("Unable to create output directory in directory" + outputTextDir);
                    return;
                }
            }
        }

        System.out.println("Start input/output extraction util");
        final File[] list = inputDir.listFiles();
        for(int i = 0; i < list.length; i++)
        {
            final File segmentsFile = list[i];
            if(!segmentsFile.isFile())
            {
                continue;
            }
            System.out.println("Start processing file:" + segmentsFile.toString());
            final File debugOutput = new File(outputDir, segmentsFile.getName() + ".io.txt");
            final File genXmlOutput = new File(outputDir, segmentsFile.getName() + "_gen.sh");
            System.out.println("Writing output to " + debugOutput.getName());
            String segment = null;
            try
            {
                reader = new BufferedReader(new FileReader(segmentsFile));
                debugWriter = new BufferedWriter(new FileWriter(debugOutput));
                genXmlWriter = new BufferedWriter(new FileWriter(genXmlOutput));
                boolean processDefTs = false;
                boolean checkRenaming = false;
                String name = null;
                String parameter = null;
                String timeStep = null;
//                String type = null;
                for(String line; (line = reader.readLine()) != null;)
                {
                    final String[] splittedLine = line.split("\\s+");

                    if(splittedLine[0].equals(DOWNSTREAM) && !processDefTs)
                    {
                        segment = segmentFound(splittedLine);
                    }
                    else if(splittedLine[0].equals(DEF_TS))
                    {
                        processDefTs = true;
                    }
                    else if(processDefTs && splittedLine.length > 3 && splittedLine[3].equals(INPUT))
                    {
                        name = splittedLine[0];
                        parameter = splittedLine[1];
                        timeStep = splittedLine[2];
//                        type = INPUT;
                        checkRenaming = true;
                        System.out.println("Input detected " + name + "-" + parameter + "-" + timeStep);
                    }
                    else if(processDefTs && splittedLine.length > 3 && splittedLine[3].equals(OUTPUT))
                    {
                        name = splittedLine[0];
                        parameter = splittedLine[1];
                        timeStep = splittedLine[2];
//                        type = OUTPUT;
                        checkRenaming = true;
                        System.out.println("Output detected " + name + "-" + parameter + "-" + timeStep);
                    }
                    else if(splittedLine[0].equals(END) && processDefTs)
                    {
                        System.out.println("Finishined processing " + segment);
                        processDefTs = false;
                        debugWriter.write("End " + segment);
                        debugWriter.newLine();
                    }
                    else if(checkRenaming)
                    {
                        checkRenaming = false;
                        final String preprocessedName = splittedLine[0];
                        final String preprocessedParameter = splittedLine[1];
                        if(!name.equals(preprocessedName))
                        {
                            System.out.println("Time series name " + name + "-" + parameter + "-" + timeStep
                                + "  is renamed to " + preprocessedName);
                            name = preprocessedName;
                        }
                        if(!preprocessedParameter.equals(parameter))
                        {
                            System.out.println("Time series parameter " + name + "-" + parameter + "-" + timeStep
                                + "  is renamed to " + preprocessedParameter);
                            parameter = preprocessedParameter;
                        }
                        final Calendar cal = Calendar.getInstance();
                        try
                        {
                            cal.setTime(startDate);
                        }
                        catch(final NullPointerException npe)
                        {
                            System.err.println("There is no start Date defined in config file, startDate = "
                                + npe.getMessage());
                            return;
                        }
                        final int timeStepValue = Integer.valueOf(timeStep).intValue();
                        cal.add(Calendar.HOUR, timeStepValue);
                        String endDateFormat = "";
                        try
                        {
                            endDateFormat = simpleDateFormat.format(endDate);
                        }
                        catch(final NullPointerException npe)
                        {
                            System.err.println("There is no end Date defined in config file, endDate = "
                                + npe.getMessage());
                            return;
                        }
                        String forecastDateFormat = "";
                        try
                        {
                            forecastDateFormat = simpleDateFormat.format(forecastDate);
                        }
                        catch(final NullPointerException npe)
                        {
                            System.err.println("There is no forecast Date defined in config file, forecastDate = "
                                + npe.getMessage());
                            return;
                        }

                        final String id = name;
                        //String id = type + "_" + name + "_" + parameter + "_" + timeStep;
                        genXmlWriter.write("fews_xml_timeseries_converter.script -id " + id + " -type " + parameter
                            + "  -format ts -ofsLevel " + ofsLevel + " -output " + outputDir.getName() + '/' + name
                            + "_" + parameter + "_" + timeStep + ".xml  -startDate '"
                            + simpleDateFormat.format(cal.getTime()) + "' -endDate '" + endDateFormat
                            + "' -forecastDate '" + forecastDateFormat + "'" + " -createTextFile false");
                        genXmlWriter.newLine();
                        debugWriter.write(id);
                        debugWriter.newLine();
                    }
                }
            }
            catch(final FileNotFoundException e)
            {
                e.printStackTrace();
            }
            finally
            {
                reader.close();
                genXmlWriter.close();
                debugWriter.close();
            }

        }
    }

    private static String segmentFound(final String[] splittedLine) throws IOException
    {
        String segment;
        segment = splittedLine.length > 1 ? splittedLine[1] : UNDEFINED;
        System.out.println("Start processing:" + segment);
        debugWriter.write("Start " + segment);
        debugWriter.newLine();
        return segment;
    }
}
