package ohd.hseb.ohdgriddedmodels;

import ohd.hseb.grid.RfcGrid;
import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.IParameters;

/**
 * This class is for handling gridded parameters. It is loaded from a NETCDF file and the parameter information of each
 * pixel are stored at {@link #_rfcGrid}.
 */
public class GriddedParameters implements IParameters
{
    protected RfcGrid _rfcGrid;

    protected Logger _logger;

    public GriddedParameters()
    {
        //empty
    }

    public GriddedParameters(final String netcdfParamFileName, final Logger logger) throws Exception
    {

        _logger = logger;

        this.loadParameters(netcdfParamFileName);
    }

    public void loadParameters(final String netcdfParamFileName) throws Exception
    {
        _rfcGrid = new RfcGrid(netcdfParamFileName, _logger);

        _logger.log(Logger.DEBUG, "Loaded the gridded parameters from the NETCDF file: " + netcdfParamFileName);
    }

    /**
     * Output each pixel's parameters to a NETCDF file.
     */
    public void writeParameters(final String outputStateNetcdfFileName, final Logger logger) throws Exception
    {
        _rfcGrid.writeOutNetcdfFile(outputStateNetcdfFileName);

        _logger.log(Logger.DEBUG, "Output the state to the NETCDF file: " + outputStateNetcdfFileName);
    }

    /**
     * Prints out the following information to console:<br>
     * State time = 2011-05-24 13:48:00 GMT<br>
     * West column= 850<br>
     * South row= 470<br>
     * Colunm number= 200<br>
     * Row number= 200<br>
     * 
     * @throws Exception
     */
    public void printVariableRange() throws Exception
    {
        _rfcGrid.printVariableRange();
    }

    /**
     * Prints out every pixel containing non-missing values in the format like:<br>
     * HRAP_ROW= 620 HRAP_COLUMN= 924 LZPK= 9.1<br>
     * HRAP_ROW= 620 HRAP_COLUMN= 924 LZFPM= 7.6<br>
     * HRAP_ROW= 620 HRAP_COLUMN= 924 FROZEN_GROUND_CALC_OPTION= 1.0<br>
     * 
     * @throws Exception
     */
    public void printOutGridsValues() throws Exception
    {
        _rfcGrid.printOutGridsValues();
    }

    @Override
    public void setLogger(final Logger logger)
    {
        _logger = logger;
    }

    /**
     * Returns the internal grid.
     */
    public RfcGrid getGrid()
    {
        return _rfcGrid;
    }

}
