package ohd.hseb.ohdgriddedmodels.apicont;

import ohd.hseb.ohdgriddedmodels.GriddedParameters;
import ohd.hseb.ohdmodels.apicont.APIContModelConstants;
import ohd.hseb.ohdmodels.apicont.APIContModelParameters;
import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.OHDConstants;

public class APIContGriddedModelParameters extends GriddedParameters
{
    public APIContGriddedModelParameters()
    {
        //empty
    }

    public APIContGriddedModelParameters(final String netcdfParamsFile, final Logger logger) throws Exception
    {
        super(netcdfParamsFile, logger);
    }

    /**
     * @param apiContParams
     * @param hrapCol
     * @param hrapRow
     * @throws Exception
     */
    public void setApiContModelParameters(final APIContModelParameters apiContParams,
                                          final int hrapCol,
                                          final int hrapRow) throws Exception
    {
        // card 1
        if(apiContParams.isParamExisting(APIContModelParameters.DrainageArea_RunoffZone))
        {
            super._rfcGrid.setDoubleVariable(APIContModelParameters.DrainageArea_RunoffZone,
                                             hrapCol,
                                             hrapRow,
                                             apiContParams.getDoubleDataParameter(APIContModelParameters.DrainageArea_RunoffZone));
        }
        //card 2

        /**
         * originally, this parameter is String type and it can has three choices: "WKN", "AEI" and "ATI". Since ASC
         * files can only have numbers, so i use integer 0 for "WKN", 1 for "AEI" and 2 for "ATI".
         */
        final String firstQuaVarStr = apiContParams.getStringDataParameter(APIContModelParameters.FirstQuadrantVariation);
        int firstQuaVarInt;

        if(firstQuaVarStr.equalsIgnoreCase(APIContModelConstants.FIRST_QUADRANT_VARIATION_WKN))
        {
            firstQuaVarInt = 0;
        }
        else if(firstQuaVarStr.equalsIgnoreCase(APIContModelConstants.FIRST_QUADRANT_VARIATION_AEI))
        {
            firstQuaVarInt = 1;
        }
        else if(firstQuaVarStr.equalsIgnoreCase(APIContModelConstants.FIRST_QUADRANT_VARIATION_ATI))
        {
            firstQuaVarInt = 2;
        }
        else
        {
            throw new Exception("The API-CONT parameter[" + APIContModelParameters.FirstQuadrantVariation + "] value["
                + firstQuaVarStr + "] is not recognized. It can only be WKN, AEI or ATI.");
        }

        super._rfcGrid.setIntVariable(APIContModelParameters.FirstQuadrantVariation, hrapCol, hrapRow, firstQuaVarInt);

        if(apiContParams.isParamExisting(APIContModelParameters.Sums))
        {
            super._rfcGrid.setIntVariable(APIContModelParameters.Sums,
                                          hrapCol,
                                          hrapRow,
                                          apiContParams.getIntDataParameter(APIContModelParameters.Sums));
        }
        // card 3
        // Only needed only when first quadrant variation is AEI, or ATI or 
        // frozen ground is FRZE
        String firstQuadrantVariation = null;
        String frozenGround = null;
        if(apiContParams.isParamExisting(APIContModelParameters.FirstQuadrantVariation))
        {
            firstQuadrantVariation = apiContParams.getStringDataParameter(APIContModelParameters.FirstQuadrantVariation);
        }
        if(apiContParams.isParamExisting(APIContModelParameters.FrozenGround))
        {
            frozenGround = apiContParams.getStringDataParameter(APIContModelParameters.FrozenGround);
        }

        if((firstQuadrantVariation != null && (firstQuadrantVariation.equalsIgnoreCase(APIContModelConstants.FIRST_QUADRANT_VARIATION_AEI) || firstQuadrantVariation.equalsIgnoreCase(APIContModelConstants.FIRST_QUADRANT_VARIATION_ATI)))
            || (frozenGround != null && frozenGround.equalsIgnoreCase("FRZE")))
        {
            super._rfcGrid.setDoubleVariable(APIContModelParameters.PEADJ,
                                             hrapCol,
                                             hrapRow,
                                             apiContParams.getDoubleDataParameter(APIContModelParameters.PEADJ));
            double elevationDifference = 0.0;
            if(apiContParams.isParamExisting(APIContModelParameters.elevationDifference))
            {
                elevationDifference = apiContParams.getDoubleDataParameter(APIContModelParameters.elevationDifference);
                super._rfcGrid.setDoubleVariable(APIContModelParameters.elevationDifference,
                                                 hrapCol,
                                                 hrapRow,
                                                 elevationDifference);
            }
            if(elevationDifference != 0.0)
            {
                super._rfcGrid.setDoubleVariable(APIContModelParameters.lapseRateMaximum,
                                                 hrapCol,
                                                 hrapRow,
                                                 apiContParams.getDoubleDataParameter(APIContModelParameters.lapseRateMaximum));
                super._rfcGrid.setDoubleVariable(APIContModelParameters.lapseRateMinimum,
                                                 hrapCol,
                                                 hrapRow,
                                                 apiContParams.getDoubleDataParameter(APIContModelParameters.lapseRateMinimum));
            }
        }
        // card 4
        // Only is needed when Areal Extent Of Snow Cover, or Snow Water Equivalent data are available

        // card 5
        // Only needed when storm run-off, or ground water run-off or discharge,  or AI or API or FI are to be generated

        // card 5A
        // Only needed when API contents or AEI, ATI, or percent surface run-off or FEI
        // are to be generated              
        // card 6
        super._rfcGrid.setDoubleVariable(APIContModelParameters.PXADJ,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.PXADJ));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.AIXW,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.AIXW));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.AIXD,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.AIXD));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.CW,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.CW));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.CD,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.CD));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.SMIX,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.SMIX));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.CS,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.CS));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.FRSX,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.FRSX));
        // card 6A
        super._rfcGrid.setDoubleVariable(APIContModelParameters.PIMPV,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.PIMPV));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.APIK,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.APIK));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.PEX,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.PEX));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.PEN,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.PEN));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.EFC,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.EFC));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.RIVA,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.RIVA));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.RVAI,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.RVAI));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.APIX,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.APIX));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.APIKS,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.APIKS));
        // card 7
        String FirstQuadrantVariation = null;
        if(apiContParams.isParamExisting(APIContModelParameters.FirstQuadrantVariation))
        {
            FirstQuadrantVariation = apiContParams.getStringDataParameter(APIContModelParameters.FirstQuadrantVariation);
        }
        if(FirstQuadrantVariation != null
            && FirstQuadrantVariation.indexOf(APIContModelConstants.FIRST_QUADRANT_VARIATION_WKN) >= 0)
        {
            super._rfcGrid.setDoubleVariable(APIContModelParameters.WKW,
                                             hrapCol,
                                             hrapRow,
                                             apiContParams.getDoubleDataParameter(APIContModelParameters.WKW));
            super._rfcGrid.setDoubleVariable(APIContModelParameters.WKD,
                                             hrapCol,
                                             hrapRow,
                                             apiContParams.getDoubleDataParameter(APIContModelParameters.WKD));
        }
        else if(FirstQuadrantVariation != null
            && FirstQuadrantVariation.indexOf(APIContModelConstants.FIRST_QUADRANT_VARIATION_AEI) >= 0)
        {
            super._rfcGrid.setDoubleVariable(APIContModelParameters.AEIX,
                                             hrapCol,
                                             hrapRow,
                                             apiContParams.getDoubleDataParameter(APIContModelParameters.AEIX));
            super._rfcGrid.setDoubleVariable(APIContModelParameters.AEIN,
                                             hrapCol,
                                             hrapRow,
                                             apiContParams.getDoubleDataParameter(APIContModelParameters.AEIN));

            super._rfcGrid.setDoubleVariable(APIContModelParameters.AEIK,
                                             hrapCol,
                                             hrapRow,
                                             apiContParams.getDoubleDataParameter(APIContModelParameters.AEIK));
        }
        else if(FirstQuadrantVariation != null
            && FirstQuadrantVariation.indexOf(APIContModelConstants.FIRST_QUADRANT_VARIATION_ATI) >= 0)
        {
            super._rfcGrid.setDoubleVariable(APIContModelParameters.ATIX,
                                             hrapCol,
                                             hrapRow,
                                             apiContParams.getDoubleDataParameter(APIContModelParameters.ATIX));
            super._rfcGrid.setDoubleVariable(APIContModelParameters.ATIN,
                                             hrapCol,
                                             hrapRow,
                                             apiContParams.getDoubleDataParameter(APIContModelParameters.ATIN));
            super._rfcGrid.setDoubleVariable(APIContModelParameters.ATIR,
                                             hrapCol,
                                             hrapRow,
                                             apiContParams.getDoubleDataParameter(APIContModelParameters.ATIR));
        }
        //card 8
        super._rfcGrid.setDoubleVariable(APIContModelParameters.BFPK,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.BFPK));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.BFIK,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.BFIK));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.BFIM,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.BFIM));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.AICR,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.AICR));
        super._rfcGrid.setDoubleVariable(APIContModelParameters.CG,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getDoubleDataParameter(APIContModelParameters.CG));
        // card 9
        // Contains frozen ground parameters. Only use Card 9 if Card
        // frozen ground equals 'FRZE'.        

    }

    /**
     * Set the same ApiContModelParameters at a range of pixels: on the same row, from start column to the end column,
     * including both of them.
     */
    public void setApiContModelParameters(final APIContModelParameters apiContModelParams,
                                          final int hrapStartCol,
                                          final int hrapEndCol,
                                          final int hrapRow) throws Exception
    {
        for(int columnIndex = hrapStartCol; columnIndex <= hrapEndCol; columnIndex++)
        {
            this.setApiContModelParameters(apiContModelParams, columnIndex, hrapRow);
        }
    }

    public void setOptFile(final APIContModelParameters apiContParams, final int hrapCol, final int hrapRow) throws Exception
    {
        //for legacy model, it only needs "OPERATION_CONTENTS". It does not care about other parameters
        super._rfcGrid.setStringVariable(OHDConstants.OPERATION_CONTENTS_TAG,
                                         hrapCol,
                                         hrapRow,
                                         apiContParams.getOptFile());
    }

    /**
     * Returns all decks in one String, separated by "\n".
     * 
     * @throws Exception
     */
    public String getOptFile(final int hrapCol, final int hrapRow) throws Exception
    {
        return super._rfcGrid.getStringVariable(OHDConstants.OPERATION_CONTENTS_TAG, hrapCol, hrapRow);
    }
}
