package ohd.hseb.ohdgriddedmodels.apicont;

import ohd.hseb.ohdgriddedmodels.GriddedState;
import ohd.hseb.ohdmodels.apicont.APIContModelState;
import ohd.hseb.util.Logger;

public class APIContGriddedModelState extends GriddedState
{
    public APIContGriddedModelState()
    {
        //empty
    }

    public APIContGriddedModelState(final String netcdfStateFile, final Logger logger) throws Exception
    {
        super(netcdfStateFile, logger);
    }

    /**
     * Set APIContModelState at the specific pixel. All the state values are stored in Map<String, Object> _statesMap in
     * State object.
     */
    public void setApiContModelState(final APIContModelState apiContModelState, final int hrapCol, final int hrapRow) throws Exception
    {
        for(final String stateName: APIContModelState.ApiCont_STATE_NAMES)
        {
            super._rfcGridWithTime.setDoubleVariable(stateName,
                                                hrapCol,
                                                hrapRow,
                                                apiContModelState.getDoubleDataState(stateName)); //extracting values from Map<String, Object> _statesMap in State object
        }
    }

    /**
     * Set the same ApiContModelState at a range of pixels: on the same row, from start column to the end column,
     * including both of them.
     */
    public void setApiContModelState(final APIContModelState apiContModelState,
                                     final int hrapStartCol,
                                     final int hrapEndCol,
                                     final int hrapRow) throws Exception
    {
        for(int columnIndex = hrapStartCol; columnIndex <= hrapEndCol; columnIndex++)
        {
            this.setApiContModelState(apiContModelState, columnIndex, hrapRow);
        }
    }

    /**
     * Get APIContModelState at the specific pixel.
     */
    public APIContModelState getApiContModelState(final int hrapCol, final int hrapRow) throws Exception
    {
        final APIContModelState apiContModelState = new APIContModelState();

        apiContModelState.insertStateAsString(APIContModelState.API,
                                              String.valueOf(super._rfcGridWithTime.getDoubleVariable(APIContModelState.API,
                                                                                                 hrapCol,
                                                                                                 hrapRow)));
        apiContModelState.insertStateAsString(APIContModelState.baseflowIndex,
                                              String.valueOf(super._rfcGridWithTime.getDoubleVariable(APIContModelState.baseflowIndex,
                                                                                                 hrapCol,
                                                                                                 hrapRow)));
        apiContModelState.insertStateAsString(APIContModelState.baseflowStorageContents,
                                              String.valueOf(super._rfcGridWithTime.getDoubleVariable(APIContModelState.baseflowStorageContents,
                                                                                                 hrapCol,
                                                                                                 hrapRow)));
        apiContModelState.insertStateAsString(APIContModelState.FEI,
                                              String.valueOf(super._rfcGridWithTime.getDoubleVariable(APIContModelState.FEI,
                                                                                                 hrapCol,
                                                                                                 hrapRow)));
        apiContModelState.insertStateAsString(APIContModelState.FIRST_QUADRANT_INDEX,
                                              String.valueOf(super._rfcGridWithTime.getDoubleVariable(APIContModelState.FIRST_QUADRANT_INDEX,
                                                                                                 hrapCol,
                                                                                                 hrapRow)));
        apiContModelState.insertStateAsString(APIContModelState.surfaceMoistureIndex,
                                              String.valueOf(super._rfcGridWithTime.getDoubleVariable(APIContModelState.surfaceMoistureIndex,
                                                                                                 hrapCol,
                                                                                                 hrapRow)));

        return apiContModelState;
    }
}
