package ohd.hseb.ohdgriddedmodels.snow17;

import ohd.hseb.ohdgriddedmodels.GriddedState;
import ohd.hseb.ohdmodels.snow17.Snow17ModelConstants;
import ohd.hseb.ohdmodels.snow17.Snow17ModelState;
import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.OHDUtilities;

public class Snow17GriddedModelState extends GriddedState
{
    public Snow17GriddedModelState()
    {
        //empty
    }

    public Snow17GriddedModelState(final String netcdfStateFile, final Logger logger) throws Exception
    {
        super(netcdfStateFile, logger);
    }

    /**
     * Set Snow17ModelState at the specific pixel.
     */
    public void setSnow17ModelState(final Snow17ModelState snow17ModelState, final int hrapCol, final int hrapRow) throws Exception
    {

        super._rfcGridWithTime.setDoubleVariable(Snow17ModelState.ACCMAX_TAG,
                                                 hrapCol,
                                                 hrapRow,
                                                 snow17ModelState.getMaxWeSinceSnow());

        super._rfcGridWithTime.setDoubleVariable(Snow17ModelState.AEADJ_TAG,
                                                 hrapCol,
                                                 hrapRow,
                                                 snow17ModelState.getSnowArealExtentAdjustment());

        super._rfcGridWithTime.setDoubleVariable(Snow17ModelState.LIQW_TAG,
                                                 hrapCol,
                                                 hrapRow,
                                                 snow17ModelState.getLiquidWaterInSnowPack());

        super._rfcGridWithTime.setDoubleVariable(Snow17ModelState.NEGHS_TAG,
                                                 hrapCol,
                                                 hrapRow,
                                                 snow17ModelState.getNegHeatStorage());

        super._rfcGridWithTime.setDoubleVariable(Snow17ModelState.SB_TAG,
                                                 hrapCol,
                                                 hrapRow,
                                                 snow17ModelState.getArealWaterEquivBeforeSnow());

        super._rfcGridWithTime.setDoubleVariable(Snow17ModelState.SBAESC_TAG,
                                                 hrapCol,
                                                 hrapRow,
                                                 snow17ModelState.getAescBeforeSnow());

        super._rfcGridWithTime.setDoubleVariable(Snow17ModelState.SBWS_TAG,
                                                 hrapCol,
                                                 hrapRow,
                                                 snow17ModelState.getWaterEquivalentUnderSnowCover());

        super._rfcGridWithTime.setDoubleVariable(Snow17ModelState.SNDPT_TAG,
                                                 hrapCol,
                                                 hrapRow,
                                                 snow17ModelState.getSnowDepth());

        super._rfcGridWithTime.setDoubleVariable(Snow17ModelState.SNTMP_TAG,
                                                 hrapCol,
                                                 hrapRow,
                                                 snow17ModelState.getAverageSnowTemp());

        super._rfcGridWithTime.setDoubleVariable(Snow17ModelState.STORGE_TAG,
                                                 hrapCol,
                                                 hrapRow,
                                                 snow17ModelState.getExcessLiquidWaterInStorage());

        super._rfcGridWithTime.setDoubleVariable(Snow17ModelState.TAPREV_TAG,
                                                 hrapCol,
                                                 hrapRow,
                                                 snow17ModelState.getTaprev());

        super._rfcGridWithTime.setDoubleVariable(Snow17ModelState.TINDEX_TAG,
                                                 hrapCol,
                                                 hrapRow,
                                                 snow17ModelState.getTempIndex());

        super._rfcGridWithTime.setDoubleVariable(Snow17ModelState.WE_TAG,
                                                 hrapCol,
                                                 hrapRow,
                                                 snow17ModelState.getWaterEquivalentOfSolidSnow());

        super._rfcGridWithTime.setStringVariable(OHDConstants.EXLAGARRAY_TAG,
                                                 hrapCol,
                                                 hrapRow,
                                                 OHDUtilities.getStringLineFromDoubleArray(snow17ModelState.getExlagArray()));
    }

    /**
     * Set the same Snow17ModelState at a range of pixels: on the same row, from start column to the end column,
     * including both of them.
     */
    public void setSnow17ModelState(final Snow17ModelState snow17ModelState,
                                    final int hrapStartCol,
                                    final int hrapEndCol,
                                    final int hrapRow) throws Exception
    {
        for(int columnIndex = hrapStartCol; columnIndex <= hrapEndCol; columnIndex++)
        {
            this.setSnow17ModelState(snow17ModelState, columnIndex, hrapRow);
        }
    }

    /**
     * Return a Snow17ModelState object at the specific pixel. Returns NULL if one of the state has missing value.
     */
    public Snow17ModelState getSnow17ModelState(final int hrapCol, final int hrapRow) throws Exception
    {
        //first of all, check if there is missing value
        for(final String snow17StateName: Snow17ModelConstants.SNOW17_STATE_NAMES)
        {
            if(snow17StateName == OHDConstants.EXLAGARRAY_TAG)
            {//EXLAG_ARRAY is a double array, stored as a string separated by space in netcdf file, skip checking isValueMissing()
                continue;
            }

            if(super._rfcGridWithTime.isValueMissing(snow17StateName, hrapCol, hrapRow))
            {
                _logger.log(Logger.WARNING, snow17StateName + " has missing value at HRAP_COL[" + hrapCol
                    + "], HRAP_ROW[" + hrapRow + "]");

                return null;
            }
        }

        final Snow17ModelState snow17ModelState = new Snow17ModelState();

        snow17ModelState.setWaterEquivalentOfSolidSnow(super._rfcGridWithTime.getDoubleVariable(Snow17ModelState.WE_TAG,
                                                                                                hrapCol,
                                                                                                hrapRow));
        snow17ModelState.setNegHeatStorage(super._rfcGridWithTime.getDoubleVariable(Snow17ModelState.NEGHS_TAG,
                                                                                    hrapCol,
                                                                                    hrapRow));
        snow17ModelState.setLiquidWaterInSnowpack(super._rfcGridWithTime.getDoubleVariable(Snow17ModelState.LIQW_TAG,
                                                                                           hrapCol,
                                                                                           hrapRow));
        snow17ModelState.setTempIndex(super._rfcGridWithTime.getDoubleVariable(Snow17ModelState.TINDEX_TAG,
                                                                               hrapCol,
                                                                               hrapRow));
        snow17ModelState.setMaxWeSinceSnow(super._rfcGridWithTime.getDoubleVariable(Snow17ModelState.ACCMAX_TAG,
                                                                                    hrapCol,
                                                                                    hrapRow));
        snow17ModelState.setSnowDepth(super._rfcGridWithTime.getDoubleVariable(Snow17ModelState.SNDPT_TAG,
                                                                               hrapCol,
                                                                               hrapRow));
        snow17ModelState.setAverageSnowTemp(super._rfcGridWithTime.getDoubleVariable(Snow17ModelState.SNTMP_TAG,
                                                                                     hrapCol,
                                                                                     hrapRow));

        snow17ModelState.setTaprev(super._rfcGridWithTime.getDoubleVariable(Snow17ModelState.TAPREV_TAG,
                                                                            hrapCol,
                                                                            hrapRow));
        snow17ModelState.setArealWaterEquivBeforeSnow(super._rfcGridWithTime.getDoubleVariable(Snow17ModelState.SB_TAG,
                                                                                               hrapCol,
                                                                                               hrapRow));
        snow17ModelState.setAescBeforeSnow(super._rfcGridWithTime.getDoubleVariable(Snow17ModelState.SBAESC_TAG,
                                                                                    hrapCol,
                                                                                    hrapRow));
        snow17ModelState.setWaterEquivalentUnderSnowCover(super._rfcGridWithTime.getDoubleVariable(Snow17ModelState.SBWS_TAG,
                                                                                                   hrapCol,
                                                                                                   hrapRow));
        snow17ModelState.setExcessLiquidWaterInStorage(super._rfcGridWithTime.getDoubleVariable(Snow17ModelState.STORGE_TAG,
                                                                                                hrapCol,
                                                                                                hrapRow));
        snow17ModelState.setSnowArealExtentAdjustment(super._rfcGridWithTime.getDoubleVariable(Snow17ModelState.AEADJ_TAG,
                                                                                               hrapCol,
                                                                                               hrapRow));
        snow17ModelState.setExlagArray(super._rfcGridWithTime.getDoubleArrayVariable(OHDConstants.EXLAGARRAY_TAG,
                                                                                     hrapCol,
                                                                                     hrapRow));

        snow17ModelState.setDateTime(getDateTime());

        return snow17ModelState;
    }
}
