package ohd.hseb.ohdgriddedmodels.snow17;

import ohd.hseb.ohdgriddedmodels.GriddedParameters;
import ohd.hseb.ohdmodels.snow17.Snow17ModelConstants;
import ohd.hseb.ohdmodels.snow17.Snow17ModelParameters;
import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.OHDConstants;

public class Snow17GriddedParameters extends GriddedParameters
{
    public Snow17GriddedParameters()
    {
        //empty
    }

    public Snow17GriddedParameters(final String netcdfParamsFile, final Logger logger) throws Exception
    {
        super(netcdfParamsFile, logger);
    }

    /**
     * Set Snow17ModelParameters at specific pixel into the netcdf file. Only relevant parameters are stored.
     */
    public void setSnow17ModelParams(final Snow17ModelParameters snow17ModelParams, final int hrapCol, final int hrapRow) throws Exception
    {
        //set 17 variables
        super._rfcGrid.setDoubleVariable(Snow17ModelParameters.MV_TAG,
                                         hrapCol,
                                         hrapRow,
                                         snow17ModelParams.getMeltFactorVariationIndicator());
        super._rfcGrid.setDoubleVariable(Snow17ModelParameters.MBASE_TAG,
                                         hrapCol,
                                         hrapRow,
                                         snow17ModelParams.getBaseTemperature());
        super._rfcGrid.setDoubleVariable(Snow17ModelParameters.TAELEV_TAG,
                                         hrapCol,
                                         hrapRow,
                                         snow17ModelParams.getElevationWithAirTemp());
        super._rfcGrid.setDoubleVariable(Snow17ModelParameters.ELEV_TAG,
                                         hrapCol,
                                         hrapRow,
                                         snow17ModelParams.getElevation());
        super._rfcGrid.setDoubleVariable(Snow17ModelParameters.TIPM_TAG,
                                         hrapCol,
                                         hrapRow,
                                         snow17ModelParams.getTemperatureIndex());
        super._rfcGrid.setDoubleVariable(Snow17ModelParameters.SCF_TAG,
                                         hrapCol,
                                         hrapRow,
                                         snow17ModelParams.getSnowCorrectionFactor());
        super._rfcGrid.setDoubleVariable(Snow17ModelParameters.PXTEMP_TAG,
                                         hrapCol,
                                         hrapRow,
                                         snow17ModelParams.getDelineationTemperature());
        super._rfcGrid.setDoubleVariable(Snow17ModelParameters.SI_TAG,
                                         hrapCol,
                                         hrapRow,
                                         snow17ModelParams.getArealWeUnderFullSnowCover());
        super._rfcGrid.setDoubleVariable(Snow17ModelParameters.PXADJ_TAG,
                                         hrapCol,
                                         hrapRow,
                                         snow17ModelParams.getPxadj());
        super._rfcGrid.setDoubleVariable(Snow17ModelParameters.UADJ_TAG,
                                         hrapCol,
                                         hrapRow,
                                         snow17ModelParams.getWindFuncParameter());
        super._rfcGrid.setDoubleVariable(Snow17ModelParameters.MFMIN_TAG,
                                         hrapCol,
                                         hrapRow,
                                         snow17ModelParams.getMinMeltFactor());
        super._rfcGrid.setDoubleVariable(Snow17ModelParameters.MFMAX_TAG,
                                         hrapCol,
                                         hrapRow,
                                         snow17ModelParams.getMaxMeltFactor());
        super._rfcGrid.setDoubleVariable(Snow17ModelParameters.NMF_TAG,
                                         hrapCol,
                                         hrapRow,
                                         snow17ModelParams.getNegMeltFactor());
        super._rfcGrid.setDoubleVariable(Snow17ModelParameters.ALAT_TAG,
                                         hrapCol,
                                         hrapRow,
                                         snow17ModelParams.getLatitude());
        super._rfcGrid.setDoubleVariable(Snow17ModelParameters.PLWHC_TAG,
                                         hrapCol,
                                         hrapRow,
                                         snow17ModelParams.getPercentLiquidWaterHoldingCap());
        super._rfcGrid.setDoubleVariable(Snow17ModelParameters.DAYGM_TAG,
                                         hrapCol,
                                         hrapRow,
                                         snow17ModelParams.getDailyGroundMelt());
        super._rfcGrid.setDoubleArrayVariable(OHDConstants.ADC_TAG, hrapCol, hrapRow, snow17ModelParams.getAdc());

    }

    /**
     * Set the same Snow17ModelParams at a range of pixels: on the same row, from start column to the end column,
     * including both of them.
     */
    public void setSnow17ModelParams(final Snow17ModelParameters snow17ModelParams,
                                     final int hrapStartCol,
                                     final int hrapEndCol,
                                     final int hrapRow) throws Exception
    {
        for(int columnIndex = hrapStartCol; columnIndex <= hrapEndCol; columnIndex++)
        {
            this.setSnow17ModelParams(snow17ModelParams, columnIndex, hrapRow);
        }
    }

    /**
     * Return a Snow17ModelParameters object at the specific pixel. Returns NULL if one of the parameters has missing
     * value.
     */
    public Snow17ModelParameters getSnow17ModelParameters(final int hrapCol, final int hrapRow) throws Exception
    {
        //first of all, check if there is missing value
        for(final String snow17ParamName: Snow17ModelConstants.SNOW17_PARAM_NAMES)
        {
            if(snow17ParamName.equals(OHDConstants.ADC_TAG))
            {//ADC is a double array, stored as a string separated by space in netcdf file, skip checking isValueMissing()
                continue;
            }

            if(super._rfcGrid.isValueMissing(snow17ParamName, hrapCol, hrapRow))
            {
                _logger.log(Logger.WARNING, snow17ParamName + " has missing value at HRAP_COL[" + hrapCol
                    + "], HRAP_ROW[" + hrapRow + "]");

                return null;
            }
        }

        final Snow17ModelParameters snow17Params = new Snow17ModelParameters();

        snow17Params.setMeltFactorVariationIndicator((int)super._rfcGrid.getDoubleVariable(Snow17ModelParameters.MV_TAG,
                                                                                           hrapCol,
                                                                                           hrapRow));
        snow17Params.setBaseTemperature(super._rfcGrid.getDoubleVariable(Snow17ModelParameters.MBASE_TAG,
                                                                         hrapCol,
                                                                         hrapRow));
        snow17Params.setElevationWithAirTemp(super._rfcGrid.getDoubleVariable(Snow17ModelParameters.TAELEV_TAG,
                                                                              hrapCol,
                                                                              hrapRow));
        snow17Params.setElevation(super._rfcGrid.getDoubleVariable(Snow17ModelParameters.ELEV_TAG, hrapCol, hrapRow));
        snow17Params.setTemperatureIndex(super._rfcGrid.getDoubleVariable(Snow17ModelParameters.TIPM_TAG,
                                                                          hrapCol,
                                                                          hrapRow));
        snow17Params.setSnowCorrectionFactor(super._rfcGrid.getDoubleVariable(Snow17ModelParameters.SCF_TAG,
                                                                              hrapCol,
                                                                              hrapRow));
        snow17Params.setDelineationTemperature(super._rfcGrid.getDoubleVariable(Snow17ModelParameters.PXTEMP_TAG,
                                                                                hrapCol,
                                                                                hrapRow));
        snow17Params.setArealWeUnderFullSnowCover(super._rfcGrid.getDoubleVariable(Snow17ModelParameters.SI_TAG,
                                                                                   hrapCol,
                                                                                   hrapRow));
        snow17Params.setPxadj(super._rfcGrid.getDoubleVariable(Snow17ModelParameters.PXADJ_TAG, hrapCol, hrapRow));
        snow17Params.setWindFuncParameter(super._rfcGrid.getDoubleVariable(Snow17ModelParameters.UADJ_TAG,
                                                                           hrapCol,
                                                                           hrapRow));
        snow17Params.setMinMeltFactor(super._rfcGrid.getDoubleVariable(Snow17ModelParameters.MFMIN_TAG,
                                                                       hrapCol,
                                                                       hrapRow));
        snow17Params.setMaxMeltFactor(super._rfcGrid.getDoubleVariable(Snow17ModelParameters.MFMAX_TAG,
                                                                       hrapCol,
                                                                       hrapRow));
        snow17Params.setNegMeltFactor(super._rfcGrid.getDoubleVariable(Snow17ModelParameters.NMF_TAG, hrapCol, hrapRow));
        snow17Params.setLatitude(super._rfcGrid.getDoubleVariable(Snow17ModelParameters.ALAT_TAG, hrapCol, hrapRow));
        snow17Params.setPercentLiquidWaterHoldingCap(super._rfcGrid.getDoubleVariable(Snow17ModelParameters.PLWHC_TAG,
                                                                                      hrapCol,
                                                                                      hrapRow));
        snow17Params.setDailyGroundMelt(super._rfcGrid.getDoubleVariable(Snow17ModelParameters.DAYGM_TAG,
                                                                         hrapCol,
                                                                         hrapRow));
        snow17Params.setAdc(super._rfcGrid.getDoubleArrayVariable(OHDConstants.ADC_TAG, hrapCol, hrapRow));

        return snow17Params;
    }

}
