package ohd.hseb.ohdmodels.apicont;

import ohd.hseb.util.fews.ohdmodels.LegacyModelParameters;

/**
 * To extend the legacy model parameters
 * 
 * @author <a href="mailto:Raymond.Chui@noaa.gov">Raymond.Chui@noaa.gov</a>
 * @see LegacyModelParameters
 * @version 1.0
 * @since February, 2009
 */

final public class APIContModelParameters extends LegacyModelParameters
{
    // card 1
    public final static String descriptionRunoffZone = "DESCRIPTION_RUNOFF_ZONE";
    public final static String TS_Time_Step = "TS_TIME_STEP";

//    public final static String TS_Runoff_ID = "TS_RUNOFF_ID";
//    public final static String TS_Runoff_Type = "TS_RUNOFF_TYPE";
    public final static String DrainageArea_RunoffZone = "DRAINAGEAREA_RUNOFFZONE";
    // card 2
    public final static String FirstQuadrantVariation = "FIRST_QUADRANT_VARIATION";
    public final static String FrozenGround = "FROZEN_GROUND";
    public final static String ArealExtentOfSnowCover = "AREAL_EXTENT_OF_SNOW_COVER";
    public final static String SnowWaterEquivalent = "SNOW_WATER_EQUIVALENT";
    public final static String StormRunoff = "STORM_RUNOFF";
    public final static String GroundWaterRunofforDischarge = "GROUND_WATER_RUNOFF_OR_DISCHARGE";
    public final static String AntecedentIndex = "ANTECEDENT_INDEX";
    public final static String API = "API"; // Antecedent Precipitation Index
    public final static String FI = "FI"; // FrostIndex
    public final static String APIContents = "API_CONTENTS";
    public final static String AEIorATI = "AEI_ATI"; // Antecedent_Evaporation_Index or Antecedent_Temperature_Index
    public final static String PercentSurfaceRunoff = "PERCENT_SURFACE_RUNOFF";
    public final static String FEI = "FROST_EFFICIENCY_INDEX"; // FrostEfficiencyIndex 
    public final static String PROT = "PROT";
    public final static String Sums = "SUMS";

    public final static String isCalibration = "IsCalibration"; // for card 11 if yes

    // card 3
    public final static String PE = "PE";
    public final static String PEType = "PE_TYPE";
    public final static String PEADJ = "PEADJ";
    public final static String airTemperatureID = "AIR_TEMPERATURE_ID";
    public final static String airTemperatureType = "AIR_TEMPERATURE_TYPE";
    public final static String airTemperatureTimeStep = "AIR_TEMPERATURE_TIME_STEP";
    public final static String elevationDifference = "ELEVATION_DIFFERENCE";
    public final static String lapseRateMaximum = "LAPSE_RATE_MAXIMUM";
    public final static String lapseRateMinimum = "LAPSE_RATE_MINIMUM";
    // card 4
    public final static String snowCoverArealExtentID = "SNOW_COVER_AREAL_EXTENT_ID";
    public final static String snowCoverArealExtentTimeStep = "SNOW_COVER_AREAL_EXTENT_TIME_STEP";
    public final static String waterEquivalentID = "WATER-EQUIVALENT_ID";
    public final static String waterEquivalentTimeStep = "WATER-EQUIVALENT_TIME_STEP";
    // card 5
    public final static String stormRunoffID = "STORM_RUNOFF_ID";
    public final static String groundwaterRunoffOrDischargeID = "GROUNDWATER_RUNOFF_DISCHARGE_ID";
    public final static String AI_ID = "AI_ID";
    public final static String AI_TimeStep = "AI_TIME_STEP";
    public final static String API_ID = "API_ID";
    public final static String API_TimeStep = "API_TIME_STEP";
    public final static String FrostIndexID = "FROST_INDEX_ID";
    public final static String FrostIndexTimeStep = "FROST_INDEX_TIME_STEP";
    // card 5A
    public final static String APIContentsID = "API_CONTENTS_ID";
    public final static String APIContentsTimeStep = "API_CONTENTS_TIME_STEP";
    public final static String AEIorATI_ID = "AEI_ATI_ID";
    public final static String AEIorATI_TimeStep = "AEI_ATI_TIME_STEP";
    public final static String PercentSurfaceRunoff_ID = "PERCENT_SURFACE_RUNOFF_ID";
    public final static String FrostEfficiencyIndexID = "FROST_EFFICIENCY_INDEX_ID";
    public final static String FrostEfficiencyIndexTimeStep = "FROST_EFFICIENCY_INDEX_TIME_STEP";
    // card 6
    public final static String PXADJ = "PXADJ";
    public final static String AIXW = "AIXW";
    public final static String AIXD = "AIXD";
    public final static String CW = "CW";
    public final static String CD = "CD";
    public final static String SMIX = "SMIX";
    public final static String CS = "CS";
    public final static String FRSX = "FRSX";
    // card 6A
    public final static String PIMPV = "PIMPV";
    public final static String APIK = "APIK";
    public final static String PEX = "PEX";
    public final static String PEN = "PEN";
    public final static String EFC = "EFC";
    public final static String RIVA = "RIVA";
    public final static String RVAI = "RVAI";
    public final static String APIX = "APIX";
    public final static String APIKS = "APIKS";
    // card 7
    public final static String WKW = "WKW";
    public final static String WKD = "WKD";
    public final static String AEIX = "AEIX";
    public final static String AEIN = "AEIN";
    public final static String AEIK = "AEIK";
    public final static String ATIX = "ATIX";
    public final static String ATIN = "ATIN";
    public final static String ATIR = "ATIR";
    // card 8
    public final static String BFPK = "BFPK";
    public final static String BFIK = "BFIK";
    public final static String BFIM = "BFIM";
    public final static String AICR = "AICR";
    public final static String CG = "CG";
    // card 9
    public final static String CSOIL = "CSOIL";
    public final static String CSNOW = "CSNOW";
    public final static String GHC = "GHC";
    public final static String FICR = "FICR";
    public final static String CF_FEI = "CF_FEI";
    public final static String CP_FEI = "CP_FEI";
    public final static String CT_FEI = "CT_FEI";
    public final static String EFA = "EFA";
    // card 10, this card contains initial carryover, it had defined in APIContModelState 
    // card 11
    public final static String beginningMonth = "Beginning_Month";
    public final static String beginningYear = "Beginning_Year";
    public final static String endingMonth = "Ending_Month";
    public final static String endingYear = "Ending_Year";

    public final static String beginningMonth_2nd = "Beginning_Month_2nd";
    public final static String beginningYear_2nd = "Beginning_Year_2nd";
    public final static String endingMonth_2nd = "Ending_Month_2nd";
    public final static String endingYear_2nd = "Ending_Year_2nd";

    public final static String beginningMonth_3rd = "Beginning_Month_3rd";
    public final static String beginningYear_3rd = "Beginning_Year_3rd";
    public final static String endingMonth_3rd = "Ending_Month_3rd";
    public final static String endingYear_3rd = "Ending_Year_3rd";

    public final static int theDouble = 0;
    public final static int theInteger = 1;

    public final static String emptySlot = "Empty Slot";
}