package ohd.hseb.ohdmodels.apicont;

import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.ohdmodels.ModelState;

/**
 * To extends the model state class
 * 
 * @author <a href="mailto:Raymond.Chui@noaa.gov">Raymond.Chui@noaa.gov</a>
 * @version 1.0
 * @since February, 2009
 */
public class APIContModelState extends ModelState
{
    public final static String API = "ANTECEDENT_PRECIPITATION_INDEX"; // API
    // ANTECEDENT_TEMPERATURE_INDEX (ATI) or ANTECEDENT_EVAPORATION_INDEX (AEI)
    public final static String FIRST_QUADRANT_INDEX = "FIRST_QUADRANT_INDEX";
    public final static String surfaceMoistureIndex = "SURFACE_MOISTURE_INDEX";
    public final static String baseflowStorageContents = "BASEFLOW_STORAGE_CONTENTS";
    public final static String baseflowIndex = "BASEFLOW_INDEX";
    public final static String FEI = "FROST_EFFICIENCY_INDEX";
    public final static String FI = OHDConstants.FINDEX_TAG;

    /**
     * API-CONT 6 state names: "ANTECEDENT_PRECIPITATION_INDEX", "FIRST_QUADRANT_INDEX", "SURFACE_MOISTURE_INDEX",
     * "BASEFLOW_STORAGE_CONTENTS", "BASEFLOW_INDEX" and "FROST_EFFICIENCY_INDEX"
     */
    public final static String[] ApiCont_STATE_NAMES = new String[]{API, //
        FIRST_QUADRANT_INDEX, //
        surfaceMoistureIndex, //
        baseflowStorageContents, //
        baseflowIndex, //
        FI, // 
        FEI};

    public APIContModelState()
    {
        super();
    }
}