package ohd.hseb.ohdmodels.baseflow;

import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.ModelException;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.ohdmodels.ModelParameters;

/**
 * @author champ
 */
final public class BaseflowJavaModelParameters extends ModelParameters
{
    // Card 1
    public final static String UNIT = "UNIT";
    public final static String OUTPUT_TIMESERIE_TIME_STEP = "TS_TIME_STEP";
    public final static String AREA = "AREA";
    public final static String CONSTANT = "CONSTANT";
    public final static String BASEFLOW_OPTION_INDICATOR = "BASEFLOW_OPTION_INDICATOR";

    public final static String OUTPUT_TIMESERIE_ID = OHDConstants.TS_ID;
    public final static String OUTPUT_TIMESERIE_TYPE = OHDConstants.TS_TYPE;

    public final static String PREVIOUS_BASEFLOW = "PREVIOUS_BASEFLOW";
    public final static String PREVIOUS_RECESSION_COEFFICIENT = "PREVIOUS_RECESSION_COEFFICIENT";
    public final static String RECESSION_COEFFICIENT_ID = "RECESSION_COEFFICIENT_ID";
    public final static String RECESSION_COEFFICIENT_TYPE = "RECESSION_COEFFICIENT_TYPE";

    public final static double RECESSION_COEFICIENT_MINIMUM = 0.5;
    public final static double RECESSION_COEFICIENT_MAXIMUM = 0.999;
    public final static String RECESSION_COEFICIENT_DATA_TYPE = "PCTD";

    public final static String NO_VARIABLE_BASEFLOW = "0";
    public final static String SINGLE_BASEFLOW_RECESSION_COEFF = "1";
    public final static String RECESSION_COEFF_SUPLIED_AS_TIMESERIE = "2";

    // Constant values to convert from english to metric units
    final static double AREA_TO_METRIC_UNITS = 2.58999;
    final static double CONSTANT_BASEFLOW_TO_METRIC_UNITS = 0.028317;

    private String inputUnitType;
    private String timeSeriesId;
    private String timeSerieDataType;
    private int timeSeriesInterval;
    private double operationArea = 0;
    private double constantAmount = 0;
    private String variableOptionIndicator;

    //Optional values set by flag
//    private double previousRecessionCoefficient = 0;
//    private double previousBaseflow = 0;
//    private double recessionCoefficient = 0;
    private String recessionCoefficientTimeSeriesId;
    private String recessionCoefficientTimeSeriesDataType;

    @Override
    public void extractValuesFromMap() throws Exception
    {

        if(isParamExisting(UNIT))
        {
            this.setInputUnitType(Integer.valueOf(getIntDataParameter(UNIT)).toString());
        }
        else
        {
            throw new ModelException("THE UNIT TYPE MUST BE METRIC/ENGLISH. THE VALUE WAS NOT DEFINED");
        }

        if(isParamExisting(OUTPUT_TIMESERIE_ID))
        {
            this.setTimeSeriesId(getStringDataParameter(OUTPUT_TIMESERIE_ID));
        }

        if(isParamExisting(OUTPUT_TIMESERIE_TIME_STEP))
        {
            this.setTimeSeriesInterval(getIntDataParameter(OUTPUT_TIMESERIE_TIME_STEP));
        }

        if(isParamExisting(OUTPUT_TIMESERIE_TYPE))
        {
            this.setTimeSerieDataType(getStringDataParameter(OUTPUT_TIMESERIE_TYPE));
        }

        if(isParamExisting(AREA))
        {
            this.setOperationArea(getDoubleDataParameter(AREA));
        }
        else
        {
            throw new ModelException("THE AREA MUST EXCEED ZERO SQUARE. NO VALUE WAS DEFINED");
        }

        if(isParamExisting(CONSTANT))
        {
            this.setConstantAmount(getDoubleDataParameter(CONSTANT));
        }
        else
        {
            throw new ModelException("Constant BaseFlow must be greater than or equal to Zero (CMS or CFS). NO VALUE WAS DEFINED");
        }

//        if(isParamExisting(PREVIOUS_BASEFLOW))
//        {
//            this.setPreviousBaseFlow(getDoubleDataParameter(PREVIOUS_BASEFLOW));
//        }
//
//        if(isParamExisting(PREVIOUS_RECESSION_COEFFICIENT))
//        {
//            this.setPreviosRecessionCoefficient(getDoubleDataParameter(PREVIOUS_RECESSION_COEFFICIENT));
//        }

        if(isParamExisting(RECESSION_COEFFICIENT_ID))
        {
            this.setRecessionCoefficientTimeSeriesId(getStringDataParameter(RECESSION_COEFFICIENT_ID));
        }

        if(isParamExisting(RECESSION_COEFFICIENT_TYPE))
        {
            this.setRecessionCoefficientTimeSeriesDataType(getStringDataParameter(RECESSION_COEFFICIENT_TYPE));
        }

        if(isParamExisting(BASEFLOW_OPTION_INDICATOR))
        {
            this.setVariableOptionIndicator(Integer.valueOf(getIntDataParameter(BASEFLOW_OPTION_INDICATOR)).toString());
        }
        else
        {
            throw new ModelException("The variable BaseFlow option indicator must be equal one of the following values: 0, 1, 2. NO VALUE WAS DEFINED");
        }
    }

    /*
     * validate parameters...
     */
    public void validateParams() throws ModelException, Exception
    {
        if(this.getInputUnitType() != OHDConstants.UNIT_METRIC && this.getInputUnitType() != OHDConstants.UNIT_ENGLISH)
        {
            _logger.log(Logger.FATAL,
                        "THE UNIT TYPE MUST BE " + OHDConstants.UNIT_METRIC + "/" + OHDConstants.UNIT_ENGLISH
                            + ". THE VALUE ENTERED WAS " + this.getInputUnitType());
            throw new ModelException("THE UNIT TYPE MUST BE METRIC/ENGLISH. THE VALUE ENTERED WAS "
                + this.getInputUnitType());
        }

        if(this.getOperationArea() < 0.0)
        {
            _logger.log(Logger.FATAL,
                        "The area must exceed Zero Square (kilometers or miles). The value entered was "
                            + this.getOperationArea());
            throw new ModelException("The area must exceed Zero Square (kilometers or miles). The value entered was "
                + this.getOperationArea());
        }
        else if(this.getInputUnitType() == OHDConstants.UNIT_ENGLISH)
        {
            // Convert from English to metric units
            this.setOperationArea(this.getOperationArea() * AREA_TO_METRIC_UNITS);
//            //this.setConstantAmount(this.getConstantAmount() * CONSTANT_BASEFLOW_TO_METRIC_UNITS);
//            if(this.getVariableOptionIndicator().equals(SINGLE_BASEFLOW_RECESSION_COEFF))
//                this.setPreviousBaseFlow(this.getPreviousBaseFlow() * CONSTANT_BASEFLOW_TO_METRIC_UNITS);
//            if(this.getVariableOptionIndicator().equals(RECESSION_COEFF_SUPLIED_AS_TS))
//                this.setPreviosRecessionCoefficient(this.getPreviousRecessionCoefficient()
//                    * CONSTANT_BASEFLOW_TO_METRIC_UNITS);
        }

        if(this.getConstantAmount() < 0.0)
        {
            _logger.log(Logger.FATAL,
                        "Constant BaseFlow must be greater than or equal to Zero (CMS or CFS). The value entered was "
                            + this.getConstantAmount());
            throw new ModelException("Constant BaseFlow must be greater than or equal to Zero (CMS or CFS). The value entered was "
                + this.getConstantAmount());
        }
        else if(this.getInputUnitType() == OHDConstants.UNIT_ENGLISH)
        {
            // Convert from English to metric units 
            this.setConstantAmount(this.getConstantAmount() * CONSTANT_BASEFLOW_TO_METRIC_UNITS);
        }

        // The following values are only validated if carryover is present.

        //TODO: replace the values of 0, 1 and 2 for final values - Maybe this validation is not required.

        if(!this.getVariableOptionIndicator().equals(NO_VARIABLE_BASEFLOW)
            && !this.getVariableOptionIndicator().equals(SINGLE_BASEFLOW_RECESSION_COEFF)
            && !this.getVariableOptionIndicator().equals(RECESSION_COEFF_SUPLIED_AS_TIMESERIE))
        {
            _logger.log(Logger.FATAL,
                        "The variable BaseFlow option indicator must be equal one of the following values: 0, 1, 2. The value entered was "
                            + this.getVariableOptionIndicator());
            throw new ModelException("The variable BaseFlow option indicator must be equal one of the following values: 0, 1, 2. The value entered was "
                + this.getVariableOptionIndicator());
        }

//        if(this.getVariableOptionIndicator().equals(SINGLE_BASEFLOW_RECESSION_COEFF)
//            && this.getPreviousRecessionCoefficient() < RECESSION_COEFICIENT_MINIMUM
//            && this.getPreviousRecessionCoefficient() > RECESSION_COEFICIENT_MAXIMUM)
//        {
//            _logger.log(Logger.FATAL,
//                        "The Constant Recession Coeficient for BaseFlow must be equal a value between "
//                            + RECESSION_COEFICIENT_MINIMUM + " and " + RECESSION_COEFICIENT_MAXIMUM
//                            + " inclusively. The value entered was " + this.getPreviousRecessionCoefficient());
//            throw new ModelException("The Constant Recession Coeficient for BaseFlow must be equal a value between "
//                + RECESSION_COEFICIENT_MINIMUM + " and " + RECESSION_COEFICIENT_MAXIMUM
//                + " inclusively. The value entered was " + this.getPreviousRecessionCoefficient());
//        }
//
//        if(this.getVariableOptionIndicator().equals(RECESSION_COEFF_SUPLIED_AS_TS)
//            && this.getPreviousRecessionCoefficient() < RECESSION_COEFICIENT_MINIMUM
//            && this.getPreviousRecessionCoefficient() > RECESSION_COEFICIENT_MAXIMUM)
//        {
//            _logger.log(Logger.FATAL,
//                        "Baseflow Recession Coeficient limits are " + RECESSION_COEFICIENT_MINIMUM + " and "
//                            + RECESSION_COEFICIENT_MAXIMUM + " inclusively. The value entered was "
//                            + this.getPreviousRecessionCoefficient());
//            throw new ModelException("Baseflow Recession Coeficient limits are " + RECESSION_COEFICIENT_MINIMUM
//                + " and " + RECESSION_COEFICIENT_MAXIMUM + " inclusively. The value entered was "
//                + this.getPreviousRecessionCoefficient());
//        }
//
//        if(this.getPreviousBaseFlow() < this.getPreviousRecessionCoefficient())
//        {
//            _logger.log(Logger.WARNING,
//                        "Total previous Baseflow must be equal or exceed the constant baseflow of "
//                            + this.getPreviousRecessionCoefficient()
//                            + " (CFS or CMS). The total previous Baseflow value entered was "
//                            + this.getPreviousBaseFlow()
//                            + " (CMS or CFS). Total previous Baseflow was set equal to constant Baseflow before being stored as carryover");
//        }

    }

    /**
     * @return the inputUnitType
     */
    public String getInputUnitType()
    {
        return this.inputUnitType;
    }

    /**
     * @param inputUnitType the inputUnitType to set
     */
    public void setInputUnitType(final String inputUnitType)
    {
        if(inputUnitType.equals("1"))
        {
            this.inputUnitType = OHDConstants.UNIT_METRIC;
        }
        else
        {
            this.inputUnitType = OHDConstants.UNIT_ENGLISH;
        }
    }

    /**
     * @return the flowTimeSeriesId
     */
    public String getTimeSeriesId()
    {
        return timeSeriesId;
    }

    /**
     * @param flowTimeSeriesId the flowTimeSeriesId to set
     */
    public void setTimeSeriesId(final String timeSeriesId)
    {
        this.timeSeriesId = timeSeriesId;
    }

    /**
     * @return the flowTimeSerieDataType
     */
    public String getTimeSerieDataType()
    {
        return timeSerieDataType;
    }

    /**
     * @param flowTimeSerieDataType the flowTimeSerieDataType to set
     */
    public void setTimeSerieDataType(final String timeSerieDataType)
    {
        this.timeSerieDataType = timeSerieDataType;
    }

    /**
     * @return the baseFlowTimeSeriesInterval
     */
    public double getTimeSeriesInterval()
    {
        return timeSeriesInterval;
    }

    /**
     * @param baseFlowTimeSeriesInterval the baseFlowTimeSeriesInterval to set
     */
    public void setTimeSeriesInterval(final int timeSeriesInterval)
    {
        this.timeSeriesInterval = timeSeriesInterval;
    }

    /**
     * @return the operationArea
     */
    public double getOperationArea()
    {
        return operationArea;
    }

    /**
     * @param operationArea the operationArea to set
     */
    public void setOperationArea(final double operationArea)
    {
        this.operationArea = operationArea;
    }

    /**
     * @return the constantAmount
     */
    public double getConstantAmount()
    {
        return constantAmount;
    }

    /**
     * @param constantAmount the constantAmount to set
     */
    public void setConstantAmount(final double constantAmount)
    {
        this.constantAmount = constantAmount;
    }

    /**
     * @return the variableOptionIndicator
     */
    public String getVariableOptionIndicator()
    {
        return variableOptionIndicator;
    }

    /**
     * @param variableOptionIndicator the variableOptionIndicator to set
     */
    public void setVariableOptionIndicator(final String variableOptionIndicator)
    {
        this.variableOptionIndicator = variableOptionIndicator;
    }

//    /**
//     * @return the PreviousRecessionCoefficient
//     */
//    public double getPreviousRecessionCoefficient()
//    {
//        return previousRecessionCoefficient;
//    }
//
//    /**
//     * @param constantRecessionCoefficient the constantRecessionCoefficient to set
//     */
//    public void setPreviosRecessionCoefficient(final double previousRecessionCoefficient)
//    {
//        this.previousRecessionCoefficient = previousRecessionCoefficient;
//    }
//
//    /**
//     * @return the PreviousBaseflow
//     */
//    public double getPreviousBaseFlow()
//    {
//        return previousBaseflow;
//    }
//
//    /**
//     * @param initialTotalPrevious the PreviousBaseflow to set
//     */
//    public void setPreviousBaseFlow(final double previousBaseflow)
//    {
//        this.previousBaseflow = previousBaseflow;
//    }

    /**
     * @return the recessionCoefficientTimeSeriesId
     */
    public String getRecessionCoefficientTimeSeriesId()
    {
        return recessionCoefficientTimeSeriesId;
    }

    /**
     * @param recessionCoefficientTimeSeriesId the recessionCoefficientTimeSeriesId to set
     */
    public void setRecessionCoefficientTimeSeriesId(final String recessionCoefficientTimeSeriesId)
    {
        this.recessionCoefficientTimeSeriesId = recessionCoefficientTimeSeriesId;
    }

    /**
     * @return the recessionCoefficientTimeSeriesDataType
     */
    public String getRecessionCoefficientTimeSeriesDataType()
    {
        return recessionCoefficientTimeSeriesDataType;
    }

    /**
     * @param recessionCoefficientTimeSeriesDataType the recessionCoefficientTimeSeriesDataType to set
     */
    public void setRecessionCoefficientTimeSeriesDataType(final String recessionCoefficientTimeSeriesDataType)
    {
        this.recessionCoefficientTimeSeriesDataType = recessionCoefficientTimeSeriesDataType;
    }

//    public double getRecessionCoefficient()
//    {
//        return recessionCoefficient;
//    }
//
//    public void setRecessionCoefficient(final double recessionCoefficient)
//    {
//        this.recessionCoefficient = recessionCoefficient;
//    }
}
