package ohd.hseb.ohdmodels.baseflow;

import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.ModelException;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.ohdmodels.ModelParameters;
import ohd.hseb.util.fews.ohdmodels.ModelState;

public class BaseflowJavaModelState extends ModelState
{
    public final static String PREVIOUS_BASEFLOW = "PREVIOUS_BASEFLOW";
    public final static String BASEFLOW_RECESSION_COEFFICIENT = "BASEFLOW_RECESSION_COEFFICIENT";
    public final static String RECESSION_COEFFICIENT_ID = "RECESSION_COEFFICIENT_ID";
    public final static String RECESSION_COEFFICIENT_TYPE = "RECESSION_COEFFICIENT_TYPE";

    public final static double RECESSION_COEFICIENT_MINIMUM = 0.5;
    public final static double RECESSION_COEFICIENT_MAXIMUM = 0.999;

    String _inputUnitType = null;
    double _previousBaseflow = 0;
    double _baseflowRecessionCoefficient = 0;
    String _recessionCoefficient_ID = null;
    String _recessionCoefficient_Type = null;

    public BaseflowJavaModelState()
    {
        super();
    }

    public void validateState() throws Exception
    {

        if(this.getPreviousBaseflow() < 0.0)
        {
            this.setPreviousBaseflow(0.0);
            _logger.log(Logger.WARNING,
                        "**WARNING** THE PREVIOUS BASEFLOW CARRYOVER VALUE WAS NEGATIVE. THE VALUE WAS CHANGED TO ZER0.");
        }

        if(this.getBaseflowRecessionCoefficient() < RECESSION_COEFICIENT_MINIMUM
            && this.getBaseflowRecessionCoefficient() > RECESSION_COEFICIENT_MAXIMUM)
        {
            _logger.log(Logger.FATAL,
                        "The Constant Recession Coeficient for BaseFlow must be equal a value between "
                            + RECESSION_COEFICIENT_MINIMUM + " and " + RECESSION_COEFICIENT_MAXIMUM
                            + " inclusively. The value entered was " + this.getBaseflowRecessionCoefficient());
            throw new ModelException("The Constant Recession Coeficient for BaseFlow must be equal a value between "
                + RECESSION_COEFICIENT_MINIMUM + " and " + RECESSION_COEFICIENT_MAXIMUM
                + " inclusively. The value entered was " + this.getBaseflowRecessionCoefficient());
        }

        if(this.getPreviousBaseflow() < RECESSION_COEFICIENT_MINIMUM
            && this.getPreviousBaseflow() > RECESSION_COEFICIENT_MAXIMUM)
        {
            _logger.log(Logger.FATAL,
                        "Baseflow Recession Coeficient limits are " + RECESSION_COEFICIENT_MINIMUM + " and "
                            + RECESSION_COEFICIENT_MAXIMUM + " inclusively. The value entered was "
                            + this.getPreviousBaseflow());
            throw new ModelException("Baseflow Recession Coeficient limits are " + RECESSION_COEFICIENT_MINIMUM
                + " and " + RECESSION_COEFICIENT_MAXIMUM + " inclusively. The value entered was "
                + this.getPreviousBaseflow());
        }

        if(this.getPreviousBaseflow() < this.getBaseflowRecessionCoefficient())
        {
            _logger.log(Logger.WARNING,
                        "Total previous Baseflow must be equal or exceed the constant baseflow of "
                            + this.getBaseflowRecessionCoefficient()
                            + " (CFS or CMS). The total previous Baseflow value entered was "
                            + this.getPreviousBaseflow()
                            + " (CMS or CFS). Total previous Baseflow was set equal to constant Baseflow before being stored as carryover");
        }
    }

    @Override
    public void doCarryOverTransfer(final ModelParameters savedParams, final ModelParameters params) throws Exception
    {

//          THIS SUBROUTINE MAINTAINS INTEGRITY BETWEEN THE OLD CARRYOVER
//          ARRAY, COLD, AND THE NEW CARRYOVER ARRAY, CONEW, WHENEVER
//          THE PARAMETER ARRAY FOR OPERATION 38 IS RE-INITIALIZED.  IF THE
//          VARIABLE BASEFLOW OPTION INDICATOR DOES NOT CHANGE, (I.E.,
//          POLD(9)=PONEW(9)), THE CONTENTS OF COLD ARE LOADED DIRECTLY INTO
//          CONEW, AS LONG AS POLD(9).NE.0.  IF THE VARIABLE BASEFLOW OPTION
//          INDICATOR GOES FROM 1 TO 2, OR FROM 2 TO 1, ONLY BASEFLOW IS
//          TRANSFERRED FROM THE COLD TO THE CONEW ARRAY.  FOR ALL OTHER
//          COMBINATIONS, NEITHER BASEFLOW NOR BASEFLOW RECESSION COEFFICIENT
//          IS TRANSFERRED.   

//         BASE IN THE PREVIOUS STATEMENT NO CARRYOVER OPERATION IS NEEDED.              

    }

    @Override
    public void extractValuesFromMap() throws Exception
    {
        if(super.isStateExisting(PREVIOUS_BASEFLOW))
        {
            this.setPreviousBaseflow(super.getDoubleDataState(PREVIOUS_BASEFLOW));
        }

        if(super.isStateExisting(BASEFLOW_RECESSION_COEFFICIENT))
        {
            this.setBaseflowRecessionCoefficient(super.getDoubleDataState(BASEFLOW_RECESSION_COEFFICIENT));
        }

        if(super.isStateExisting(RECESSION_COEFFICIENT_ID))
        {
            this.setRecessionCoefficient_ID(super.getStateAsString(RECESSION_COEFFICIENT_ID));
        }

        if(super.isStateExisting(RECESSION_COEFFICIENT_TYPE))
        {
            this.setRecessionCoefficient_Type(super.getStateAsString(RECESSION_COEFFICIENT_TYPE));
        }

        if(super.isStateExisting(OHDConstants.UNIT_TAG))
        {
            this.setInputUnitType(super.getStateAsString(OHDConstants.UNIT_TAG));
        }
    }

    public void setCarryOverValuesToMap()
    {
        this.getStateMap().clear();
        super.setStateValue(PREVIOUS_BASEFLOW, this.getPreviousBaseflow());
        super.setStateValue(BASEFLOW_RECESSION_COEFFICIENT, this.getBaseflowRecessionCoefficient());
        super.insertStateAsString(OHDConstants.UNIT_TAG, this.getInputUnitType());
    }

    public double getPreviousBaseflow()
    {
        return _previousBaseflow;
    }

    public void setPreviousBaseflow(final double previousBaseflow)
    {
        this._previousBaseflow = previousBaseflow;
    }

    public double getBaseflowRecessionCoefficient()
    {
        return _baseflowRecessionCoefficient;
    }

    public void setBaseflowRecessionCoefficient(final double baseflowRecessionCoefficient)
    {
        this._baseflowRecessionCoefficient = baseflowRecessionCoefficient;
    }

    public String getRecessionCoefficient_ID()
    {
        return _recessionCoefficient_ID;
    }

    public void setRecessionCoefficient_ID(final String recessionCoefficient_ID)
    {
        this._recessionCoefficient_ID = recessionCoefficient_ID;
    }

    public String getRecessionCoefficient_Type()
    {
        return _recessionCoefficient_Type;
    }

    public void setRecessionCoefficient_Type(final String recessionCoefficient_Type)
    {
        this._recessionCoefficient_Type = recessionCoefficient_Type;
    }

    public String getInputUnitType()
    {
        return this._inputUnitType;
    }

    /**
     * @param inputUnitType the inputUnitType to set
     */
    public void setInputUnitType(final String inputUnitType)
    {
        if(inputUnitType.equalsIgnoreCase(OHDConstants.UNIT_METRIC))
            this._inputUnitType = OHDConstants.UNIT_METRIC;
        else
            this._inputUnitType = OHDConstants.UNIT_ENGLISH;
    }

}