package ohd.hseb.ohdmodels.chanloss;

import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.ModelException;
import ohd.hseb.util.fews.ohdmodels.ModelParameters;

final public class ChanlossJavaModelParameters extends ModelParameters
{
    // Card 1
    public final static String SSOUT_TYPE = "SSOUT_TYPE";
    public final static String SSOUT_CONSTANT = "SSOUT_CONSTANT";
    public final static String WATER_SURFACE_AREA = "WATER_SURFACE_AREA";
    public final static String TS_PE = "INPUT_MAPE";
    // Card 2
    public final static String CARRYOVER_FLAG = "CARRYOVER_FLAG";
    //Card 3
    public final static String SSOUT_VARIABLE = "SSOUT_VARIABLE";
    // Card 4
    public final static String PEADJ = "PE_ADJUSTMENT";
    public final static String DAILY_TYPE = "DAILY_EVAPORATION_DISTRIBUTION_TYPE";
    // Card 5
    public final static String AVE_EVAP_VALUES = "LONG_TERM_AVERAGE_EVAPORATION";

    public final static String VARIABLE_SSOUT_CMS = "VARC"; // Variable SSOUT - units of CMS
    public final static String VARIABLE_SSOUT_PERCENTAGE = "VARP"; // Variable SSOUT - units of percentage
    public final static String CONSTANT_SSOUT_PERCENTAGE = "FIXP"; // Constant SSOOUT- units of percentage
    public final static String CONSTANT_SSOUT_CMS = "FIXC"; //Constant SSOUT - units of CMS
    public final static String NOPE = "NO"; // no PE time series
    public final static String YES = "YES";
    public final static String PE_CARRYOVER_VALUE = ChanlossModelState.stateName;
    public final static String DIURNAL_EVAPORATION_DISTRIBUTION = "DIUR";
    public final static String EVEN_EVAPORATION_DISTRIBUTION = "EVEN";
    
    public final static String DAY_OF_MONTH = "DAY_OF_MONTH";

    private String channelBottonLossParameterType;
    private double channelBottonLossParameterConstant;
    private double waterSurfaceArea;
    private boolean peTimeSeriesAvailability = false;

    private double[] channelBottonLossValue; // SSOUT
    private double[] channelBottonLossIncrements; // SSOUT Increments
    private double constantEvaporationAdjustmentFactor; // PEADJ
    private String dailyEvaporationDistributionType;
    private double[] averageEvaporationValues; // EA or EMO
    private double[] averageEvaporationIncrements; // EA or EMO Increments
    private int dayOfMonth = 16; // Default value 

    private final double peCarryOverValue = 0.0;
    private final boolean carryOver = false;

    final int numberDaysMonth[] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    @Override
    public void extractValuesFromMap() throws Exception
    {

        if(isParamExisting(SSOUT_TYPE))
        {
            this.setSSOUTParameterType(getStringDataParameter(SSOUT_TYPE));
        }
        else
        {
            this.setSSOUTParameterType(CONSTANT_SSOUT_CMS);
        }

        this.setWaterSurfaceArea(getDoubleDataParameter(WATER_SURFACE_AREA));

        if(isParamExisting(TS_PE))
        {
            this.setPeTimeSeriesAvailability(getStringDataParameter(TS_PE));
        }
        else
        {
            this.setPeTimeSeriesAvailability(NOPE);
        }

//        if(getPeTimeSeriesAvailability())
//        {
//
//            if(isParamExisting(PE_CARRYOVER_VALUE))
//            {
//                this.setPeCarryOverValue(getDoubleDataParameter(PE_CARRYOVER_VALUE));
//                carryOver = true;
//            }
//
//        }

        if(!this.getSSOUTParameterType().isEmpty()
            && (this.getSSOUTParameterType().equals(VARIABLE_SSOUT_CMS) || this.getSSOUTParameterType()
                                                                               .equals(VARIABLE_SSOUT_PERCENTAGE)))
        {
            this.setSSOUTValues(getDoubleArrayParameter(SSOUT_VARIABLE));
        }
        else
        {
            this.setSSOUTParameterConstant(getDoubleDataParameter(SSOUT_CONSTANT));
        }
        if(this.getWaterSurfaceArea() > 0.0)
        {
            this.setConstantEvaporationAdjustmentFactor(getDoubleDataParameter(PEADJ));

            if(isParamExisting(DAILY_TYPE))
            {
                this.setDailyEvaporationDistributionType(getStringDataParameter(DAILY_TYPE));
            }
            else
            {
                this.setDailyEvaporationDistributionType(EVEN_EVAPORATION_DISTRIBUTION);
            }
            this.setAverageEvaporationValues(getDoubleArrayParameter(AVE_EVAP_VALUES));
        }
        else
        {
            this.setDailyEvaporationDistributionType(EVEN_EVAPORATION_DISTRIBUTION);
            this.setConstantEvaporationAdjustmentFactor(0.0);

        }

        setSSOUTIncrements();
        setAverageEvaporationIncrements();
        
        if(isParamExisting(DAY_OF_MONTH))
        {
            this.setDayOfMonth(getIntDataParameter(DAY_OF_MONTH));
        }
        else
        {
            this.setDayOfMonth(dayOfMonth);
        }
    }

    public void validateParams() throws ModelException, Exception
    {

        if(this.getWaterSurfaceArea() > 0.0)
        {
            if(this.getConstantEvaporationAdjustmentFactor() < 0.0)
            {
                _logger.log(Logger.FATAL,
                            "THE PE ADJUSTMENT FACTOR, PEADJ= " + this.getConstantEvaporationAdjustmentFactor()
                                + " IS AN ERRONEOUS VALUE.");
                throw new ModelException("THE PE ADJUSTMENT FACTOR, PEADJ= "
                    + this.getConstantEvaporationAdjustmentFactor() + " IS AN ERRONEOUS VALUE.");
            }
        }

        if(isParamExisting(SSOUT_TYPE))
        {
            if(!this.getSSOUTParameterType().equals(VARIABLE_SSOUT_CMS)
                && !this.getSSOUTParameterType().equals(VARIABLE_SSOUT_PERCENTAGE)
                && !this.getSSOUTParameterType().equals(CONSTANT_SSOUT_PERCENTAGE)
                && !this.getSSOUTParameterType().equals(CONSTANT_SSOUT_CMS))
            {
                _logger.log(Logger.FATAL,
                            "The parameter: " + SSOUT_TYPE + " has an erroneous value: " + this.getSSOUTParameterType());
                throw new ModelException("The parameter: " + SSOUT_TYPE + " has an erroneous value: "
                    + this.getSSOUTParameterType());
            }
        }

        if(isParamExisting(DAILY_TYPE))
        {
            if(!this.getDailyEvaporationDistributionType().equals(DIURNAL_EVAPORATION_DISTRIBUTION)
                && !this.getDailyEvaporationDistributionType().equals(EVEN_EVAPORATION_DISTRIBUTION))
            {
                _logger.log(Logger.FATAL,
                            "The parameter: " + DAILY_TYPE + " has an erroneous value: "
                                + this.getDailyEvaporationDistributionType());
                throw new ModelException("The parameter: " + DAILY_TYPE + " has an erroneous value: "
                    + this.getDailyEvaporationDistributionType());
            }
        }

        if(this.getSSOUTValues() != null && this.getSSOUTValues().length > 0 && this.getSSOUTValues().length < 11)
        {
            _logger.log(Logger.FATAL, "The parameter: " + SSOUT_VARIABLE + " has an erroneous number of values: "
                + this.getSSOUTValues().length);
            throw new ModelException("The parameter: " + SSOUT_VARIABLE + " has an erroneous number of values: "
                + this.getSSOUTValues().length);
        }
    }

    /**
     * @return the channelBottonLossParameterType
     */
    public String getSSOUTParameterType()
    {
        return channelBottonLossParameterType;
    }

    /**
     * @param channelBottonLossParameterType the channelBottonLossParameterType to set
     */
    public void setSSOUTParameterType(final String channelBottonLossParameterType)
    {
        this.channelBottonLossParameterType = channelBottonLossParameterType;
    }

    /**
     * @return the channelBottonLossParameterConstant
     */
    public Double getSSOUTParameterConstant()
    {
        return channelBottonLossParameterConstant;
    }

    /**
     * @param channelBottonLossParameterConstant the channelBottonLossParameterConstant to set
     */
    public void setSSOUTParameterConstant(final double channelBottonLossParameterConstant)
    {
        this.channelBottonLossParameterConstant = channelBottonLossParameterConstant;
    }

    /**
     * @return the waterSurfaceArea
     */
    public double getWaterSurfaceArea()
    {
        return waterSurfaceArea;
    }

    /**
     * @param waterSurfaceArea the waterSurfaceArea to set
     */
    public void setWaterSurfaceArea(final double waterSurfaceArea)
    {
        this.waterSurfaceArea = waterSurfaceArea;
    }

    /**
     * @return the peTimeSeriesAvailability
     */
    public boolean getPeTimeSeriesAvailability()
    {
        return peTimeSeriesAvailability;
    }

    /**
     * @param peTimeSeriesAvailability the peTimeSeriesAvailability to set
     */
    public void setPeTimeSeriesAvailability(final String peTimeSeriesAvailability)
    {
        if(peTimeSeriesAvailability.isEmpty())
            this.peTimeSeriesAvailability = false;
        else
        {
            if(peTimeSeriesAvailability.equals(NOPE))
                this.peTimeSeriesAvailability = false;
            else
                this.peTimeSeriesAvailability = true;
        }
    }

    public void setPeTimeSeriesAvailability(final boolean peTimeSeriesAvailability)
    {

        this.peTimeSeriesAvailability = peTimeSeriesAvailability;
    }

    /**
     * @return the channelBottonLossValue
     */
    public double[] getSSOUTValues()
    {
        return channelBottonLossValue;
    }

    /**
     * @param channelBottonLossValue the channelBottonLossValue to set
     */
    public void setSSOUTValues(final double[] channelBottonLossValue)
    {
        this.channelBottonLossValue = channelBottonLossValue;
    }

    /**
     * @return the constantEvaporationAdjustmentFactor
     */
    public double getConstantEvaporationAdjustmentFactor()
    {
        return constantEvaporationAdjustmentFactor;
    }

    /**
     * @param constantEvaporationAdjustmentFactor the constantEvaporationAdjustmentFactor to set
     */
    public void setConstantEvaporationAdjustmentFactor(final double constantEvaporationAdjustmentFactor)
    {
        this.constantEvaporationAdjustmentFactor = constantEvaporationAdjustmentFactor;
    }

    /**
     * @return the dailyEvaporationDistributionType
     */
    public String getDailyEvaporationDistributionType()
    {
        return dailyEvaporationDistributionType;
    }

    /**
     * @param dailyEvaporationDistributionType the dailyEvaporationDistributionType to set
     */
    public void setDailyEvaporationDistributionType(final String dailyEvaporationDistributionType)
    {
        this.dailyEvaporationDistributionType = dailyEvaporationDistributionType;
    }

    /**
     * @return the averageEvaporationValues
     */
    public double[] getAverageEvaporationValues()
    {
        return averageEvaporationValues;
    }

    /**
     * @param averageEvaporationValues the averageEvaporationValues to set
     */
    public void setAverageEvaporationValues(final double[] averageEvaporationValues)
    {
        this.averageEvaporationValues = averageEvaporationValues;
    }
    
    public int getDayOfMonth()
    {
    	return this.dayOfMonth;
    }
    
    public void setDayOfMonth(int dayOfMonth)
    {
    	this.dayOfMonth = dayOfMonth;
    }

//    /**
//     * @return the carryOver
//     */
//    public boolean isCarryOver()
//    {
//        return carryOver;
//    }
//
//    /**
//     * @param carryOver the carryOver to set
//     */
//    public void setCarryOver(final boolean carryOver)
//    {
//        this.carryOver = carryOver;
//    }

//    /**
//     * @return the peCarryOverValue
//     */
//    public double getPeCarryOverValue()
//    {
//        return peCarryOverValue;
//    }
//
//    /**
//     * @param peCarryOverValue the peCarryOverValue to set
//     */
//    public void setPeCarryOverValue(final double peCarryOverValue)
//    {
//        this.peCarryOverValue = peCarryOverValue;
//    }

    /**
     * IF WATER SURFACE AREA (WSAREA) >0, READ IN EVAPORATION LOSS PARAMETERS READ IN 12 MID-MONTH VALUES ON
     * EVAP-DEMAND/PE-ADJUSTMENT CURVE. IF PE DATA IS AVAILABLE, VALUES ARE PE-ADJ CURVE.
     */
    public void setSSOUTIncrements()
    {
        if(this.getSSOUTValues() != null && this.getSSOUTValues().length > 0)
        {
            int m = 0;
            // COMPUTE DAILY INCREMENT IN ABOVE CURVE.  FIRST VALUE IS
            // INCREMENT BETWEEN 1/16 AND 2/16.               
            channelBottonLossIncrements = new double[this.getSSOUTValues().length];
            for(int i = 0; i < 12; i++)
            {
                m = i + 1;
                if(i == 11)
                    m = 0;
                channelBottonLossIncrements[i] = ((float)(channelBottonLossValue[m] - channelBottonLossValue[i]) / numberDaysMonth[i]);
            }
        }
    }

    /**
     * @return
     */
    public double[] getSSOUTIncrements()
    {
        return channelBottonLossIncrements;
    }

    /**
     * IF WATER SURFACE AREA (WSAREA) >0, READ IN EVAPORATION LOSS PARAMETERS READ IN 12 MID-MONTH VALUES ON
     * EVAP-DEMAND/PE-ADJUSTMENT CURVE. IF PE DATA IS NOT AVAILABLE VALUES REPRESENT EVAP-DEMAND.
     */
    public void setAverageEvaporationIncrements()
    {
        if(this.getAverageEvaporationValues() != null && this.getAverageEvaporationValues().length > 0)
        {
            int m = 0;
            // COMPUTE DAILY INCREMENT IN ABOVE CURVE.  FIRST VALUE IS
            // INCREMENT BETWEEN 1/16 AND 2/16.               
            averageEvaporationIncrements = new double[this.getAverageEvaporationValues().length];
            for(int i = 0; i < 12; i++)
            {
                m = i + 1;
                if(i == 11)
                    m = 0;
                averageEvaporationIncrements[i] = ((float)(averageEvaporationValues[m] - averageEvaporationValues[i]) / numberDaysMonth[i]);
            }
        }
    }

    public double[] getAverageEvaporationIncrements()
    {
        return averageEvaporationIncrements;
    }

}
