package ohd.hseb.ohdmodels.chanloss;

import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.Parameters;
import ohd.hseb.util.fews.ohdmodels.ModelParameters;
import ohd.hseb.util.fews.ohdmodels.ModelState;

public class ChanlossJavaModelState extends ModelState
{
    public final static String LAST_PE_VALUE = "LAST_PE_VALUE";
    public final static String UNIT_TYPE = "UNIT";

    private double _lastPeValue = 0.0;
    private String _unitType = null;

    public ChanlossJavaModelState()
    {
        super();
    }

    public void validateState(final Parameters params) throws Exception
    {

        this.extractValuesFromMap();

        if(this.getLastPeValue() < 0.0)
        {
            this.setLastPeValue(0.0);
            _logger.log(Logger.WARNING,
                        "**WARNING** THE PE CARRYOVER VALUE WAS NEGATIVE. THE VALUE WAS CHANGED TO ZER0.");
        }
    }

    @Override
    public void doCarryOverTransfer(final ModelParameters savedParams, final ModelParameters params) throws Exception
    {
        final ChanlossJavaModelParameters savedParameters = (ChanlossJavaModelParameters)savedParams;
        final ChanlossJavaModelParameters parameters = (ChanlossJavaModelParameters)params;

        if(parameters.getWaterSurfaceArea() > 0.0)
        {
            //TODO: Need to verify what value is being set.
            if(parameters.getPeTimeSeriesAvailability())
            {
                if(savedParameters.getWaterSurfaceArea() > 0.0)
                {
                    //super.setStateValue(LAST_PE_VALUE, savedParameters.getPeCarryOverValue());
                }
            }
        }
    }

    /**
     * @param layerId
     * @param tatumCarryOverValues
     */
    public void setCarryOverValuesToMap(final double carryOverValues)
    {
        this.getStateMap().clear();
        super.setStateValue(LAST_PE_VALUE, carryOverValues);
        super.insertStateAsString(UNIT_TYPE, OHDConstants.UNIT_METRIC);
    }

    @Override
    public void extractValuesFromMap() throws Exception
    {
        if(super.isStateExisting(LAST_PE_VALUE))
        {

            this.setLastPeValue(super.getDoubleDataState(LAST_PE_VALUE));
        }
        if(super.isStateExisting(UNIT_TYPE))
        {
            this.setUnitType(super.getStateAsString(UNIT_TYPE));
        }
    }

    /**
     * @return the _lastPeValue
     */
    public double getLastPeValue()
    {
        return _lastPeValue;
    }

    /**
     * @param _lastPeValue the _lastPeValue to set
     */
    public void setLastPeValue(final double lastPeValue)
    {
        this._lastPeValue = lastPeValue;
    }

    /**
     * @return the _unitType
     */
    public String getUnitType()
    {
        return _unitType;
    }

    /**
     * @param _unitType the _unitType to set
     */
    public void setUnitType(final String unitType)
    {
        this._unitType = unitType;
    }
}
