package ohd.hseb.ohdmodels.chanloss;

import java.util.List;

import ohd.hseb.measurement.MeasuringUnitType;
import ohd.hseb.measurement.RegularTimeSeries;
import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.State;
import ohd.hseb.util.fews.ohdmodels.LegacyModelAdapter;
import ohd.hseb.util.fews.ohdmodels.ModelDriver;

final public class ChanlossModelDriver extends ModelDriver
{

    private static final String CHANLOSS_EXE_NAME = "chanloss";

    public ChanlossModelDriver()
    {
        super(); //calling ModelDriver constructor

        _state = new ChanlossModelState();
        _parameters = new ChanlossModelParameters();
        _savedParameters = new ChanlossModelParameters();
    }

    @Override
    public ChanlossModelParameters getParameters()
    {
        return (ChanlossModelParameters)_parameters;
    }

    @Override
    public ChanlossModelState getState()
    {
        return (ChanlossModelState)_state;
    }

    @Override
    public ChanlossModelParameters getPreviousParameters()
    {
        return (ChanlossModelParameters)_savedParameters;
    }

    @Override
    public void execute() throws Exception
    {

        // only timeseries containing L3/T data should be considered as driving time series for this model
        for(final RegularTimeSeries timeSeries: _tsList)
        {
            if(timeSeries.getMeasuringUnit().getType() == MeasuringUnitType.discharge)
            {
                _drivingTs = timeSeries;
                _logger.log(Logger.DEBUG,
                            "Driving Time Series set to " + _drivingTs.getLocationId() + " "
                                + _drivingTs.getTimeSeriesType() + " " + _drivingTs.getIntervalInHours());
            }
        }

        if(_drivingTs == null)
        {
            _logger.log(Logger.FATAL, "Driving Time Series is null.Exiting...");

            throw new Exception();
        }

        //Send in work dir and state dir
        final LegacyModelAdapter chanlossAdapter = new LegacyModelAdapter(this, getWorkDir(), _logger);

        chanlossAdapter.writeStandAloneFiles();

        //Clear out state Map before storing the new data (bug 244)
        ((State)_state).getStateMap().clear();

        //if there are any model specific arguments to be sent, 
        //fill in a String [] array and send to executeModel as last argument
        chanlossAdapter.executeModel(getDriverProperties().getProperty(OHDConstants.LEGACY_LOCATION_DIR) + "/"
            + CHANLOSS_EXE_NAME, null);

        // Load the state results
        getState().loadState(chanlossAdapter.getOutputStateFileName(), _logger);

        //Set state date and time
        getState().setDateTime(getComputationEndTime());

        //load the results
        final List<RegularTimeSeries> resultsList = chanlossAdapter.readOutputFlatFilesToLists();

        for(int i = 0; i < resultsList.size(); i++)
        {
            addTStoResultMap(resultsList.get(i));
        }

    }

}
