package ohd.hseb.ohdmodels.consuse;

import java.util.List;

import ohd.hseb.measurement.MeasuringUnitType;
import ohd.hseb.measurement.RegularTimeSeries;
import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.State;
import ohd.hseb.util.fews.ohdmodels.LegacyModelAdapter;
import ohd.hseb.util.fews.ohdmodels.ModelDriver;

/**
 * @author FewsPilot Team
 */
final public class ConsUseModelDriver extends ModelDriver
{
    public ConsUseModelDriver()
    {
        super(); //calling ModelDriver constructor

        _state = new ConsUseModelState();
        _parameters = new ConsUseModelParameters();
        _savedParameters = new ConsUseModelParameters();
//      _converter = new ConsUseOptFileConverter(getWorkDir(), _logger);
    }

    @Override
    public ConsUseModelParameters getParameters()
    {
        return (ConsUseModelParameters)_parameters;
    }

    @Override
    public ConsUseModelState getState()
    {
        return (ConsUseModelState)_state;
    }

    @Override
    public ConsUseModelParameters getPreviousParameters()
    {
        return (ConsUseModelParameters)_savedParameters;
    }

    @Override
    public void execute() throws Exception
    {

        for(int listIndex = 0; listIndex < _tsList.size(); listIndex++)
        {
            if(_tsList.get(listIndex).getMeasuringUnit().getType() == MeasuringUnitType.volume)
            {
                //the validate needs to validate this is there
                _drivingTs = _tsList.get(listIndex);
                _logger.log(Logger.DEBUG,
                            "Driving Time Series set to " + _drivingTs.getLocationId() + " "
                                + _drivingTs.getTimeSeriesType() + " " + _drivingTs.getIntervalInHours());
            }
        }

        if(_drivingTs == null)
        {
            _logger.log(Logger.FATAL, "Driving Time Series is null.Exiting...");

            throw new Exception();
        }

        //Send in work dir and state dir
        final LegacyModelAdapter consUseAdapter = new LegacyModelAdapter(this, getWorkDir(), _logger);

        consUseAdapter.writeStandAloneFiles();

        //Clear out state Map before storing the new data (bug 244)
        ((State)_state).getStateMap().clear();

        //if there are any model specific arguments to be sent, 
        //fill in a String [] array and send to executeModel as last argument

        consUseAdapter.executeModel(getDriverProperties().getProperty(OHDConstants.LEGACY_LOCATION_DIR) + "consuse",
                                    null);

        getState().loadState(consUseAdapter.getOutputStateFileName(), _logger);
        getState().setDateTime(getComputationEndTime());

        //load the results
        final List<RegularTimeSeries> resultsList = consUseAdapter.readOutputFlatFilesToLists();

        // qualifier id is part of unique key NOT location id
        // this is because can have multiple outputs with same type

        for(int i = 0; i < resultsList.size(); i++)
        {
            addTStoResultMap(resultsList.get(i));
        }
    }

}
