package ohd.hseb.ohdmodels.glacier;

import ohd.hseb.measurement.MeasuringUnitType;
import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.ModelException;
import ohd.hseb.util.fews.NwsrfsDataTypeMappingReader;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.ohdmodels.ModelParameters;

final public class GlacierModelParameters extends ModelParameters
{
    // Card 1
//	public final static String TS_ID = "TS_ID";
//	public final static String TS_Type = "TS_TYPE";
    public final static String TS_OUTPUT_TIME_STEP_TAG = "TS_OUTPUT_TIME_STEP";
    public final static String TS_OUTPUT_ID_TAG = "TS_OUTPUT_ID";
    public final static String TS_OUTPUT_TYPE_TAG = "TS_OUTPUT_TYPE";
    public final static String ANTECEDENT_FLOW_ID_TAG = "ANTECEDENT_FLOW_ID";
    public final static String ANTECEDENT_FLOW_TYPE_TAG = "ANTECEDENT_FLOW_TYPE";
    // Card 2
    public final static String CG1_PARAMETER_TAG = "CG1_PARAMETER";
    public final static String CG2_PARAMETER_TAG = "CG2_PARAMETER";
    public final static String AFI_DECAY_PARAMETER_TAG = "AFI_DECAY_PARAMETER";
    public final static String KG1_PARAMETER_TAG = "KG1_PARAMETER";
    public final static String KG2_PARAMETER_TAG = "KG2_PARAMETER";
    // Card 3 had defined in GlacierModelState class

    private String _timeSeriesRainMeltId;
    private String _timeSeriesRainMeltDataType;
    private int _timeSeriesRainMeltOutputTimeInterval;
    private String _timeSeriesOutputId;
    private String _timeSeriesOutputDataType;
    private String _antecedentFlowIndexId;
    private String _antecedentFlowIndexDataType;

    private double _cg1Parameter;
    private double _cg2Parameter;
    private double _afiDecayParameter;
    private double _kg1Parameter;
    private double _kg2Parameter;

    /*
     * (non-Javadoc)
     * @see ohd.hseb.ohdmodels.ModelParameters#extractValuesFromMap()
     */
    @Override
    protected void extractValuesFromMap() throws Exception
    {
        _timeSeriesRainMeltId = getStringDataParameter(OHDConstants.TS_ID);
        _timeSeriesRainMeltDataType = getStringDataParameter(OHDConstants.TS_TYPE);
        _timeSeriesRainMeltOutputTimeInterval = getIntDataParameter(TS_OUTPUT_TIME_STEP_TAG);
        _timeSeriesOutputId = getStringDataParameter(TS_OUTPUT_ID_TAG);
        _timeSeriesOutputDataType = getStringDataParameter(TS_OUTPUT_TYPE_TAG);
        _antecedentFlowIndexId = getStringDataParameter(ANTECEDENT_FLOW_ID_TAG);
        _antecedentFlowIndexDataType = getStringDataParameter(ANTECEDENT_FLOW_TYPE_TAG);
        _cg1Parameter = getDoubleDataParameter(CG1_PARAMETER_TAG);
        _cg2Parameter = getDoubleDataParameter(CG2_PARAMETER_TAG);
        _afiDecayParameter = getDoubleDataParameter(AFI_DECAY_PARAMETER_TAG);
        _kg1Parameter = super.getDoubleDataParameter(KG1_PARAMETER_TAG);
        _kg2Parameter = super.getDoubleDataParameter(KG2_PARAMETER_TAG);

    }

    /**
     * @param drivingTsInterval
     * @throws ModelException
     * @throws Exception
     */
    public void validateParams(final String drivingTsMeasuringUnit) throws ModelException, Exception
    {

        final String dimension = NwsrfsDataTypeMappingReader.getNwsrfsDim(this.getTimeSeriesRainMeltDataType(), _logger);

        if(!dimension.equals(MeasuringUnitType.length.getName())
            || !drivingTsMeasuringUnit.equals(OHDConstants.RUNOFF_UNIT.getName()))
        {
            _logger.log(Logger.FATAL, "FOR RAIN+MELT TS  " + getTimeSeriesRainMeltDataType()
                + " L    IS EXPECTED INSTEAD OF " + MeasuringUnitType.discharge.getName()
                + " MM IS EXPECTED INSTEAD OF " + drivingTsMeasuringUnit);
            throw new ModelException("FOR RAIN+MELT TS " + getTimeSeriesRainMeltDataType() + ",IS NOT EQUAL TO "
                + MeasuringUnitType.discharge.getName());
        }

        if(getCg2Parameter() < 0.0 || getCg2Parameter() > 1.0)
        {
            _logger.log(Logger.FATAL, "ERROR: THE ROUTING PARAMETER #2 MUST BE LESS THAN OR EQUAL TO ONE");
            throw new ModelException("ERROR: THE ROUTING PARAMETER #2 MUST BE LESS THAN OR EQUAL TO ONE");
        }

        if(getAfiDecayParameter() < 0.0 || getAfiDecayParameter() > 1.0)
        {
            _logger.log(Logger.FATAL,
                        "ERROR: THE AFI DECAY PARAMETER MUST BE GREATER THAN OR EQUAL TO ZERO AND LESS THAN OR EQUAL TO ONE.");
            throw new ModelException("ERROR: THE AFI DECAY PARAMETER MUST BE GREATER THAN OR EQUAL TO ZERO AND LESS THAN OR EQUAL TO ONE.");
        }

        if((getKg1Parameter() < 0.0 || getKg1Parameter() > 1.0) || (getKg2Parameter() < 0.0 || getKg2Parameter() > 1.0))
        {
            _logger.log(Logger.FATAL,
                        "ERROR: OUTFLOW COEFS MUST BE GREATER THAN OR EQUAL TO ZERO AND LESS THAN OR EQUAL TO ONE.");
            throw new ModelException("ERROR: THE ROUTING PARAMETER #2 MUST BE LESS THAN OR EQUAL TO ONE");
        }

        if(getKg1Parameter() > getKg2Parameter())
        {
            _logger.log(Logger.FATAL, "ERROR MAX OUTFLOW COEF MUST BE GREATER THAN OR EQUAL TO MIN COEF");
            throw new ModelException("ERROR MAX OUTFLOW COEF MUST BE GREATER THAN OR EQUAL TO MIN COEF");
        }
        _logger.log(Logger.DEBUG, "GlacierModelParameters has been validated!");
    }

    /**
     * @return the timeSeriesRainMeltId
     */
    public String getTimeSeriesRainMeltId()
    {
        return _timeSeriesRainMeltId;
    }

    /**
     * @param timeSeriesRainMeltId the timeSeriesRainMeltId to set
     */
    public void setTimeSeriesRainMeltId(final String timeSeriesRainMeltId)
    {
        this._timeSeriesRainMeltId = timeSeriesRainMeltId;
    }

    /**
     * @return the timeSeriesRainMeltDataType
     */
    public String getTimeSeriesRainMeltDataType()
    {
        return _timeSeriesRainMeltDataType;
    }

    /**
     * @param timeSeriesRainMeltDataType the timeSeriesRainMeltDataType to set
     */
    public void setTimeSeriesRainMeltDataType(final String timeSeriesRainMeltDataType)
    {
        this._timeSeriesRainMeltDataType = timeSeriesRainMeltDataType;
    }

    /**
     * @return the timeSeriesRainMeltOutputTimeInterval
     */
    public int getTimeSeriesRainMeltOutputTimeInterval()
    {
        return _timeSeriesRainMeltOutputTimeInterval;
    }

    /**
     * @param timeSeriesRainMeltOutputTimeInterval the timeSeriesRainMeltOutputTimeInterval to set
     */
    public void setTimeSeriesRainMeltOutputTimeInterval(final int timeSeriesRainMeltOutputTimeInterval)
    {
        this._timeSeriesRainMeltOutputTimeInterval = timeSeriesRainMeltOutputTimeInterval;
    }

    /**
     * @return the timeSeriesOutputId
     */
    public String getTimeSeriesOutputId()
    {
        return _timeSeriesOutputId;
    }

    /**
     * @param timeSeriesOutputId the timeSeriesOutputId to set
     */
    public void setTimeSeriesOutputId(final String timeSeriesOutputId)
    {
        this._timeSeriesOutputId = timeSeriesOutputId;
    }

    /**
     * @return the timeSeriesOutputDataType
     */
    public String getTimeSeriesOutputDataType()
    {
        return _timeSeriesOutputDataType;
    }

    /**
     * @param timeSeriesOutputDataType the timeSeriesOutputDataType to set
     */
    public void setTimeSeriesOutputDataType(final String timeSeriesOutputDataType)
    {
        this._timeSeriesOutputDataType = timeSeriesOutputDataType;
    }

    /**
     * @return the antecedentFlowIndexId
     */
    public String getAntecedentFlowIndexId()
    {
        return _antecedentFlowIndexId;
    }

    /**
     * @param antecedentFlowIndexId the antecedentFlowIndexId to set
     */
    public void setAntecedentFlowIndexId(final String antecedentFlowIndexId)
    {
        this._antecedentFlowIndexId = antecedentFlowIndexId;
    }

    /**
     * @return the antecedentFlowIndexDataType
     */
    public String getAntecedentFlowIndexDataType()
    {
        return _antecedentFlowIndexDataType;
    }

    /**
     * @param antecedentFlowIndexDataType the antecedentFlowIndexDataType to set
     */
    public void setAntecedentFlowIndexDataType(final String antecedentFlowIndexDataType)
    {
        this._antecedentFlowIndexDataType = antecedentFlowIndexDataType;
    }

    /**
     * gets the Glacier Routing Parameter # 1
     * 
     * @return the cg1Parameter
     */
    public double getCg1Parameter()
    {
        return _cg1Parameter;
    }

    /**
     * @param cg1Parameter the cg1Parameter to set
     */
    public void setCg1Parameter(final double cg1Parameter)
    {
        this._cg1Parameter = cg1Parameter;
    }

    /**
     * * gets the Glacier Routing Parameter # 2 (time-1)
     * 
     * @return the cg2Parameter
     */
    public double getCg2Parameter()
    {
        return _cg2Parameter;
    }

    /**
     * @param cg2Parameter the cg2Parameter to set
     */
    public void setCg2Parameter(final double cg2Parameter)
    {
        this._cg2Parameter = cg2Parameter;
    }

    /**
     * @return the afiDecayParameter
     */
    public double getAfiDecayParameter()
    {
        return _afiDecayParameter;
    }

    /**
     * @param afiDecayParameter the afiDecayParameter to set
     */
    public void setAfiDecayParameter(final double afiDecayParameter)
    {
        this._afiDecayParameter = afiDecayParameter;
    }

    /**
     * get the Minimum glacier outflow coefficient (time-1)
     * 
     * @return the kg1Parameter
     */
    public double getKg1Parameter()
    {
        return _kg1Parameter;
    }

    /**
     * @param kg1Parameter the kg1Parameter to set
     */
    public void setKg1Parameter(final double kg1Parameter)
    {
        this._kg1Parameter = kg1Parameter;
    }

    /**
     * * get the Maximum glacier outflow coefficient (time-1)
     * 
     * @return the kg2Parameter
     */
    public double getKg2Parameter()
    {
        return _kg2Parameter;
    }

    /**
     * @param kg2Parameter the kg2Parameter to set
     */
    public void setKg2Parameter(final double kg2Parameter)
    {
        this._kg2Parameter = kg2Parameter;
    }

}