package ohd.hseb.ohdmodels.lagk;

final public class LagKConstants
{
    private LagKConstants()
    {
        /*
         * This class only contains static constants and methods, so an instance of this class should never be created.
         * If not providing this private constructor, users still can create objects of this class by using the
         * invisible default constructor provided by Java, which is wrong. Now, with this private constructor, the
         * default constructor by Java is destroyed. Now, nobody from outside of this class can create the object of
         * this class
         */
    }

    public final static double MIN_DOUBLE = 0.0;
    public final static double MAX_DOUBLE = 1000.0;
    public final static int MIN_INT = 0;
    public final static int MAX_INT = 100;

    public final static String INTERNAL_IDENTIFIER_INFLOW_TAG = "TSIDA";
    public final static String DATA_TYPE_CODE_INFLOW_TAG = "DTA";
    public final static String DATA_TIME_INTERVAL_INFLOW_TAG = "ITA";
    public final static String INTERNAL_IDENTIFIER_OUTFLOW_TAG = "TSIDB";
    public final static String DATA_TYPE_CODE_OUTFLOW_TAG = "DTB";
    public final static String DATA_TIME_INTERVAL_OUTFLOW_TAG = "ITB";
    public final static String NUMBER_PAIR_LAG_AND_Q_VALUES_TAG = "JLAG";
    public final static String NUMBER_PAIR_K_AND_Q_VALUES_TAG = "JK";
    public final static String MEASUREMENT_UNIT_TAG = "METENG";
    public final static String TLRC_TAG = "TLRC";
    public final static String FLOW_ABOVE_TLRC_TAG = "QBNTL";
    public final static String LAG_AND_Q_VALUES_PAIR_TAG = "LAGQ_PAIRS";
    public final static String K_AND_Q_VALUES_PAIR_TAG = "KQ_PAIRS";
    public final static String LAG_CONSTANT_TAG = "SETLAG";
    public final static String K_CONSTANT_TAG = "SETK";

    public final static String QT_PAIRS = "PAIR_QT_LAG_CARRYOVER";
    public final static String Q_AND_TIME_CARRYOVER_VALUES_PAIR_TAG = "QT_PAIRS";
    public final static String INFLOW_BEGINNING_ROUTING_INTERVAL = "CURRENT_LAGGED_INFLOW";
    public final static String OUTFLOW_BEGINNING_ROUTING_INTERVAL = "CURRENT_OUTFLOW";
    public final static String STORAGE_BEGINNING_ROUTING_INTERVAL = "CURRENT_STORAGE";
    /** Number of lines in model states */
    public final static String LENGTH_CARRYOVER_ARRAY = "LENGTH_CARRYOVER_ARRAY";
}