package ohd.hseb.ohdmodels.lagk;

import java.util.List;

import ohd.hseb.measurement.RegularTimeSeries;
import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.State;
import ohd.hseb.util.fews.ohdmodels.LegacyModelAdapter;
import ohd.hseb.util.fews.ohdmodels.ModelDriver;

public class LagKModelDriver extends ModelDriver
{
    private static final String _LAGK_EXE_NAME = "lagk";

    public LagKModelDriver()
    {
        super(); //calling ModelDriver constructor

        _state = new LagKModelState();
        _parameters = new LagKModelParameters();
        _savedParameters = new LagKModelParameters();
    }

    @Override
    public LagKModelParameters getParameters()
    {
        return (LagKModelParameters)_parameters;
    }

    @Override
    public LagKModelState getState()
    {
        return (LagKModelState)_state;
    }

    @Override
    public LagKModelParameters getPreviousParameters()
    {
        return (LagKModelParameters)_savedParameters;
    }

    @Override
    public void execute() throws Exception
    {
        // all input timeseries have the same time step. Any timeseries is a driver.
        _drivingTs = _tsList.get(0);

        if(_drivingTs == null)
        {
            _logger.log(Logger.FATAL, "Driving Time Series is null.Exiting...");

            throw new Exception();
        }

        _logger.log(Logger.DEBUG,
                    "Driving Time Series set to " + _drivingTs.getLocationId() + " " + _drivingTs.getTimeSeriesType()
                        + " " + _drivingTs.getIntervalInHours());

        //Send in work dir and state dir
        final LegacyModelAdapter lagkAdapter = new LegacyModelAdapter(this, getWorkDir(), _logger);

        lagkAdapter.writeStandAloneFiles();

        //Clear out state Map before storing the new data (bug 244)
        ((State)_state).getStateMap().clear();

        //if there are any model specific arguments to be sent, 
        //fill in a String [] array and send to executeModel as last argument

        lagkAdapter.executeModel(getDriverProperties().getProperty(OHDConstants.LEGACY_LOCATION_DIR) + "/"
            + _LAGK_EXE_NAME, null);

        getState().loadState(lagkAdapter.getOutputStateFileName(), _logger);
        getState().setDateTime(getComputationEndTime());

        //load the results
        final List<RegularTimeSeries> resultsList = lagkAdapter.readOutputFlatFilesToLists();

        for(int i = 0; i < resultsList.size(); i++)
        {
            addTStoResultMap(resultsList.get(i));
        }

    }
}
