package ohd.hseb.ohdmodels.lagkj;

final public class LagKJConstants
{
    private LagKJConstants()
    {
        /*
         * This class only contains static constants and methods, so an instance of this class should never be created.
         * If not providing this private constructor, users still can create objects of this class by using the
         * invisible default constructor provided by Java, which is wrong. Now, with this private constructor, the
         * default constructor by Java is destroyed. Now, nobody from outside of this class can create the object of
         * this class
         */
    }

    public final static double MIN_DOUBLE = 0.0;
    public final static double MAX_DOUBLE = 1000.0;
    public final static int MIN_INT = 0;
    public final static int MAX_INT = 100;

    public final static double CFSM = 35.31510; //convert cfs (ENGL) to cms (METRIC)
    public final static double CFDM = 35.31431; //convert cfs to cms 

    public final static double C1 = 12.0;
    public final static double C2 = 100.0;
    public final static int DEFAULT_LENGTH_CARRYOVER = 5;

    public final static String QT_PAIRS = "PAIR_QT_LAG_CARRYOVER";
    public final static String Q_AND_TIME_CARRYOVER_VALUES_PAIR_TAG = "QT_PAIRS";
    public final static String INFLOW_BEGINNING_ROUTING_INTERVAL = "CURRENT_LAGGED_INFLOW";
    public final static String OUTFLOW_BEGINNING_ROUTING_INTERVAL = "CURRENT_OUTFLOW";
    public final static String STORAGE_BEGINNING_ROUTING_INTERVAL = "CURRENT_STORAGE";

    /** Number of lines in model states */
    public final static String LENGTH_CARRYOVER_ARRAY = "LENGTH_CARRYOVER_ARRAY";

}
