package ohd.hseb.ohdmodels.lagkj;

import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.ohdmodels.ModelDriver;
import ohd.hseb.util.fews.ohdmodels.ModelException;

/*
* ChamP 05/22/2019 - RM54565 Lag/K mod error when default lag is zero
*/

public class LagKJModelDriver extends ModelDriver
{
    private final LagKJModelParameters _lagKJParameters;
    private final LagKJModelParameters _savedParameters;
    private final LagKJModelState _lagKJState;

    public LagKJModelDriver()
    {
        super(); //calling ModelDriver constructor

        super._parameters = new LagKJModelParameters();

        super._savedParameters = new LagKJModelParameters();

        super._state = new LagKJModelState();

        _lagKJParameters = (LagKJModelParameters)super._parameters;
        _savedParameters = (LagKJModelParameters)super._savedParameters;

        _lagKJState = (LagKJModelState)super._state;

        //Clear out state Map before storing the new data (bug 244)
        _lagKJState.getStateMap().clear();

    }

    /**
     * The Operation is based on a procedure originally developed as a graphical routing technique. Lag and K can be
     * used either to route for a reach or at a point. Computations at a point can be used to account for attenuation in
     * the channel system above a headwater gage.
     */
    @Override
    public void execute() throws Exception
    {
        try
        {
            this.runModelDriverValidation();

            final LagKJModel lagkModel = new LagKJModel(_lagKJParameters,
                                                        _lagKJState,
                                                        getComputationStartTime(),
                                                        getComputationEndTime(),
                                                        getDrivingTsIntervalInMillis(),
                                                        getDrivingRTS(),
                                                        _logger);
            /*this._lagKJParameters.setMeanQ(true);
            this._savedParameters.setMeanQ(true);
            System.out.println("Set parameter mean Q to true");*/
            addTStoResultMap(lagkModel.runLagKModel());

            _lagKJState.setDateTime(getComputationEndTime());
        }
        catch(final Exception e)
        {
            throw new ModelException(e);
        }

    }

    @Override
    final protected void runModelDriverValidation() throws Exception
    {
        // all input timeseries have the same time step. Any timeseries is a driver.
        _drivingTs = _tsList.get(0);

        if(_drivingTs == null)
        {
            _logger.log(Logger.FATAL, "Driving Time Series is null.  Exiting...");
            throw new ModelException("Driving Time Series is null.  Exiting...");
        }

        _logger.log(Logger.DEBUG,
                    "Driving Time Series set to " + _drivingTs.getLocationId() + " " + _drivingTs.getTimeSeriesType()
                        + " " + _drivingTs.getIntervalInHours());

        if(!_drivingTs.getLocationId().equalsIgnoreCase(_lagKJParameters.getInflowTimeSeriesId()))
        {
            _logger.log(Logger.WARNING, "Input timeseriesID (" + _lagKJParameters.getInflowTimeSeriesId()
                + ") in 'TSIDA' ModuleParam " + " NOT match with locationId (" + _drivingTs.getLocationId()
                + ") in inputs.xml ");
        }
        // Do carryover transfer
        boolean doCarryOver=false;  //Added for RM54565

        if(super.needCarryoverTransfer())
        {
      	    doCarryOver=true;

            _lagKJState.validateState(_savedParameters, doCarryOver);

            _lagKJState.doCarryOverTransfer(_savedParameters, _lagKJParameters);
        }
        else
        {
            //valid states
            _lagKJState.validateState(_lagKJParameters, doCarryOver);
        }
        super.runModelDriverValidation();

    }

    @Override
    public LagKJModelParameters getParameters()
    {
        return _lagKJParameters;
    }

    @Override
    public LagKJModelState getState()
    {
        return (LagKJModelState)_state;
    }

    @Override
    public LagKJModelParameters getPreviousParameters()
    {
        return _savedParameters;
    }
}
