package ohd.hseb.ohdmodels.lagkj;

/**
 * This class defines the old parameter tag (i.e TSIDA) and new parameter tag (i.e INFLOW_TS_ID).
 * <p>
 * ChamP 11/25/2014 - FB1617 Cleanup LagK parameter definitions.
 */

public enum LagKJParIdentifiers
{
    TSIDA("TSIDA", "INFLOW_TS_ID"), //required
    DTA("DTA", "INFLOW_TS_DATA_TYPE"), // required
    ITA("ITA", "INFLOW_TS_INTERVAL"), // required
    TSIDB("TSIDB", "OUTFLOW_TS_ID"), //optional
    DTB("DTB", "OUTFLOW_TS_DATA_TYPE"), //optional
    ITB("ITB", "OUTFLOW_TS_INTERVAL"), //required
    JLAG("JLAG", "NUMBER_OF_LAGQ_PAIRS"), //required
    JK("JK", "NUMBER_OF_KQ_PAIRS"), //required
    METENG("METENG", "METR_OR_ENGL_UNITS"), //optional
    TLRC("TLRC", "TRANSMISSION_LOSS_COEFFICIENT"), //required
    QBNTL("QBNTL", "TRANSMISSION_LOSS_THRESHOLD_FLOW"), //required
    SETLAG("SETLAG", "CONSTANT_LAG_VALUE"), //optional
    SETK("SETK", "CONSTANT_K_VALUE"); //optional

    private String oldName;
    private String newName;

    LagKJParIdentifiers(final String oldName, final String newName)
    {
        this.oldName = oldName;
        this.newName = newName;
    }

    String getOldName()
    {
        return this.oldName;
    }

    String getNewName()
    {
        return this.newName;
    }
}
