package ohd.hseb.ohdmodels.laycoef;

import ohd.hseb.measurement.MeasuringUnit;
import ohd.hseb.measurement.MeasuringUnitType;
import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.ModelException;
import ohd.hseb.util.fews.NwsrfsDataTypeMappingReader;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.ohdmodels.ModelParameters;

/**
 * @author champ, CamachoF
 */
final public class LayCoefModelParameters extends ModelParameters
{
    // card 1
    public final static String GENERAL_INFO_TAG = "GENERAL_INFO";
    public final static String TS_INFLOW_ID_TAG = "TS_INFLOW_ID";
    public final static String TS_INFLOW_TYPE_TAG = "TS_INFLOW_TYPE";
    public final static String TS_INFLOW_TIMESTEP_TAG = "TS_INFLOW_TIMESTEP";
    public final static String TS_OUTFLOW_ID_TAG = "TS_OUTFLOW_ID";
    public final static String TS_OUTFLOW_TYPE_TAG = "TS_OUTFLOW_TYPE";
    public final static String TS_OUTFLOW_TIMESTEP_TAG = "TS_OUTFLOW_TIMESTEP";
    public final static String NUMBER_OF_LAYERS_TAG = "NUMBER_OF_LAYERS";
    public final static String CARRYOVER_FLAG = "CARRYOVER_FLAG";
    // card 2
    public final static String LAYER_COEFFICIENTS_TAG = "LAYER_COEFFICIENTS";
    // card 3
    public final static String LAYER_UPPER_LIMIT_FLOW_TAG = "LAYER_UPPER_LIMIT_FLOW";
    // card 4
    public final static String LAYER_CARRYOVER_TAG = "LAYER_CARRYOVER";

    public final static String[] LAYER_DATA_TAG = {"LAYER_COEFFICIENTS", "LAYER_UPPER_LIMIT_FLOW"};
    public final static int COEFFICIENT_INDEX = 0;
    public final static int UPPER_LIMIT_INDEX = 1;
    public final static int CARRYOVER_INDEX = 2;

    private String generalInfo;
    private String inflowTimeSerieId;
    private String inflowTimeSerieType;
    private int inflowTimeSerieTimeStep;
    private String outflowTimeSerieId = null;
    private String outflowTimeSerieType = null;
    private int outflowTimeSerieTimeStep = 0;
    private int numberLayers;
    private boolean carryOver;
    private double[] layerCoefficients = {0.0,};
    private double[] _layerCoefficients = {0.0};
    private double[] upperLimitFlowByLayer = {0.0};

    double[] limitFlowByLayer = {0.0};

    @Override
    public void extractValuesFromMap() throws Exception
    {

        generalInfo = getStringDataParameter(GENERAL_INFO_TAG);
        inflowTimeSerieId = getStringDataParameter(TS_INFLOW_ID_TAG);
        inflowTimeSerieType = getStringDataParameter(TS_INFLOW_TYPE_TAG);
        inflowTimeSerieTimeStep = getIntDataParameter(TS_INFLOW_TIMESTEP_TAG);
        if(isParamExisting(TS_OUTFLOW_ID_TAG))
        {
            outflowTimeSerieId = getStringDataParameter(TS_OUTFLOW_ID_TAG);
        }
        if(isParamExisting(TS_OUTFLOW_TYPE_TAG))
        {
            outflowTimeSerieType = getStringDataParameter(TS_OUTFLOW_TYPE_TAG);
        }
        if(isParamExisting(TS_OUTFLOW_TIMESTEP_TAG))
        {
            outflowTimeSerieTimeStep = getIntDataParameter(TS_OUTFLOW_TIMESTEP_TAG);
        }
        numberLayers = getIntDataParameter(NUMBER_OF_LAYERS_TAG);
        if(isParamExisting(CARRYOVER_FLAG))
        {
            carryOver = getIntDataParameter(CARRYOVER_FLAG) == 1 ? true : false;
        }
        _layerCoefficients = getDoubleArrayParameter(LAYER_COEFFICIENTS_TAG);

        if(isParamExisting(LAYER_UPPER_LIMIT_FLOW_TAG))
        {
            limitFlowByLayer = getDoubleArrayParameter(LAYER_UPPER_LIMIT_FLOW_TAG);

            //invert values as they are in the wrong order in the params.xml file due to migration.
            upperLimitFlowByLayer = new double[limitFlowByLayer.length];
            for(int i = 0; i < limitFlowByLayer.length; i++)
            {
                upperLimitFlowByLayer[(limitFlowByLayer.length - 1) - i] = limitFlowByLayer[i];
            }
        }

        layerCoefficients = new double[_layerCoefficients.length];
        for(int i = 0; i < _layerCoefficients.length; i++)
        {
            layerCoefficients[(_layerCoefficients.length - 1) - i] = _layerCoefficients[i];
        }

    }

    /**
     * @return the generalInfo
     */
    public String getGeneralInfo()
    {
        return generalInfo;
    }

    /**
     * @param generalInfo the generalInfo to set
     */
    public void setGeneralInfo(final String generalInfo)
    {
        this.generalInfo = generalInfo;
    }

    /**
     * @return the inflowTimeSerieId
     */
    public String getInflowTimeSerieId()
    {
        return inflowTimeSerieId;
    }

    /**
     * @param inflowTimeSerieId the inflowTimeSerieId to set
     */
    public void setInflowTimeSerieId(final String inflowTimeSerieId)
    {
        this.inflowTimeSerieId = inflowTimeSerieId;
    }

    /**
     * @return the inflowTimeSerieType
     */
    public String getInflowTimeSerieType()
    {
        return inflowTimeSerieType;
    }

    /**
     * @param inflowTimeSerieType the inflowTimeSerieType to set
     */
    public void setInflowTimeSerieType(final String inflowTimeSerieType)
    {
        this.inflowTimeSerieType = inflowTimeSerieType;
    }

    /**
     * @return the inflowTimeSerieTimeStep
     */
    public int getInflowTimeSerieTimeStep()
    {
        return inflowTimeSerieTimeStep;
    }

    /**
     * @param inflowTimeSerieTimeStep the inflowTimeSerieTimeStep to set
     */
    public void setInflowTimeSerieTimeStep(final int inflowTimeSerieTimeStep)
    {
        this.inflowTimeSerieTimeStep = inflowTimeSerieTimeStep;
    }

    /**
     * @return the outflowTimeSerieId
     */
    public String getOutflowTimeSerieId()
    {
        return outflowTimeSerieId;
    }

    /**
     * @param outflowTimeSerieId the outflowTimeSerieId to set
     */
    public void setOutflowTimeSerieId(final String outflowTimeSerieId)
    {
        this.outflowTimeSerieId = outflowTimeSerieId;
    }

    /**
     * @return the outflowTimeSerieType
     */
    public String getOutflowTimeSerieType()
    {
        return outflowTimeSerieType;
    }

    /**
     * @param outflowTimeSerieType the outflowTimeSerieType to set
     */
    public void setOutflowTimeSerieType(final String outflowTimeSerieType)
    {
        this.outflowTimeSerieType = outflowTimeSerieType;
    }

    /**
     * @return the outflowTimeSerieTimeStep
     */
    public int getOutflowTimeSerieTimeStep()
    {
        return outflowTimeSerieTimeStep;
    }

    /**
     * @param outflowTimeSerieTimeStep the outflowTimeSerieTimeStep to set
     */
    public void setOutflowTimeSerieTimeStep(final int outflowTimeSerieTimeStep)
    {
        this.outflowTimeSerieTimeStep = outflowTimeSerieTimeStep;
    }

    /**
     * @return the numberLayers
     */
    public int getNumberLayers()
    {
        return numberLayers;
    }

    /**
     * @param numberLayers the numberLayers to set
     */
    public void setNumberLayers(final int numberLayers)
    {
        this.numberLayers = numberLayers;
    }

    /**
     * @return the carryOver
     */
    public boolean isCarryOver()
    {
        return carryOver;
    }

    /**
     * @param carryOver the carryOver to set
     */
    public void setCarryOver(final boolean carryOver)
    {
        this.carryOver = carryOver;
    }

    /**
     * @return the upperLimitFlowByLayer
     */
    public double[] getUpperLimitFlowByLayer()
    {
        return upperLimitFlowByLayer;
    }

    /**
     * @param upperLimitFlowByLayer the upperLimitFlowByLayer to set
     */
    public void setUpperLimitFlowByLayer(final double[] upperLimitFlowByLayer)
    {
        this.upperLimitFlowByLayer = upperLimitFlowByLayer;
    }

    /**
     * @param layerId
     * @return
     * @throws Exception
     */
    public double[] getLayerCoefficients() throws Exception
    {
        return this.layerCoefficients;

    }

    /**
     * @param layerId
     * @param tatumCarryOverValues
     */
    public void setLayerCoefficients(final double[] layerCoefficients)
    {
        this.layerCoefficients = layerCoefficients;
    }

    /**
     * @param drivingTsInterval
     * @throws ModelException
     * @throws Exception
     */
    public void validateParams(final MeasuringUnit mUnit) throws ModelException, Exception
    {
        // extractValuesFromMap() validate that required params are present.

        // Check number layer should be greater than 0
        if(this.getNumberLayers() <= 0)
        {
            _logger.log(Logger.FATAL, "**ERROR** THE NUMBER OF COEFFICIENTS IS ZERO.");
            throw new ModelException("**ERROR** THE NUMBER OF COEFFICIENTS IS ZERO.");
        }

        //Check inflow time series
        String dimension = NwsrfsDataTypeMappingReader.getNwsrfsDim(inflowTimeSerieType, _logger);

        if(!dimension.equals(MeasuringUnitType.discharge.getName())
            || mUnit.getType() != OHDConstants.DISCHARGE_UNIT.getType())
        {
            _logger.log(Logger.FATAL, "FOR CHANNEL INFLOW TS " + inflowTimeSerieType + " L3/T IS EXPECTED INSTEAD OF "
                + OHDConstants.DISCHARGE_UNIT + " CMS IS EXPECTED INSTEAD OF " + mUnit.getType());
            throw new ModelException("FOR CHANNEL INFLOW TS " + inflowTimeSerieType + " L3/T IS EXPECTED INSTEAD OF "
                + OHDConstants.DISCHARGE_UNIT + " CMS IS EXPECTED INSTEAD OF " + mUnit.getType());
        }

        if(this.getOutflowTimeSerieTimeStep() != 0
//            && this.getInflowTimeSerieTimeStep() != this.getOutflowTimeSerieTimeStep())
            && this.getOutflowTimeSerieTimeStep() < this.getInflowTimeSerieTimeStep())
        {
            _logger.log(Logger.FATAL, "**ERROR** Outflow time interval = " + this.getOutflowTimeSerieTimeStep()
                + " hours is less than Inflow time interval = " + this.getInflowTimeSerieTimeStep() + " hours."
                + "\nThis is not allowed for this operation");
            throw new ModelException("**ERROR** Outflow time interval = " + this.getOutflowTimeSerieTimeStep()
                + " hours is less than Inflow time interval = " + this.getInflowTimeSerieTimeStep() + " hours."
                + "\nThis is not allowed for this operation");
        }
        //Check outflow time series

        if(outflowTimeSerieType != null)
        {
            dimension = NwsrfsDataTypeMappingReader.getNwsrfsDim(outflowTimeSerieType, _logger);

            if(!dimension.equals(MeasuringUnitType.discharge.getName())
                || mUnit.getType() != OHDConstants.DISCHARGE_UNIT.getType())
            {
                _logger.log(Logger.FATAL, "FOR CHANNEL OUTFLOW TS " + outflowTimeSerieType
                    + " L3/T IS EXPECTED INSTEAD OF " + OHDConstants.DISCHARGE_UNIT + " CMS IS EXPECTED INSTEAD OF "
                    + mUnit.getType());
                throw new ModelException("FOR CHANNEL OUTFLOW TS " + outflowTimeSerieType
                    + " L3/T IS EXPECTED INSTEAD OF " + OHDConstants.DISCHARGE_UNIT + " CMS IS EXPECTED INSTEAD OF "
                    + mUnit.getType());
            }
        }
        // If coefficients had values greater than 1.0 then value set equal to 1.0

//        boolean layercoeffBiggerThanOne = false;
        for(int layerNumber = 0; layerNumber < layerCoefficients.length; layerNumber++)
        {
            if(layerCoefficients[layerNumber] > 1.0)
            {
                layerCoefficients[layerNumber] = 1.0;
//                layercoeffBiggerThanOne = true;
                _logger.log(Logger.WARNING, " **Warning, coefficients had values greater than 1.0 values set to 1.0");
            }
        }
//        if(layercoeffBiggerThanOne)
//        {
//            _logger.log(Logger.WARNING, " **Warning, coefficients had values greater than 1.0 values set to 1.0");
//        }

        // Check Q range data for errors. These values must be in increasing order ----------------------

//        for(int layerNumber = 0; layerNumber < layerCoefficients.length - 1; layerNumber++)
        for(int layerNumber = 0; layerNumber < upperLimitFlowByLayer.length - 1; layerNumber++)
        {
//            System.out.println(upperLimitFlowByLayer[layerNumber] + "GE" + upperLimitFlowByLayer[layerNumber + 1]
//                + "failed");
//            if(layerCoefficients[layerNumber] < layerCoefficients[layerNumber + 1])
            if(upperLimitFlowByLayer[layerNumber] >= upperLimitFlowByLayer[layerNumber + 1])
            {
                _logger.log(Logger.FATAL, "Flow ranges for layers not in increasing order");
                throw new ModelException("Flow ranges for layers not in increasing order");
            }
        }

        _logger.log(Logger.DEBUG, "LayCoefModelParameters has been validated!");
    }
}