package ohd.hseb.ohdmodels.laycoef;

import java.io.BufferedWriter;
import java.io.FileWriter;

import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.OHDConstants;
import ohd.hseb.util.fews.Parameters;
import ohd.hseb.util.fews.StringIntegerComparator;
import ohd.hseb.util.fews.ohdmodels.ModelParameters;
import ohd.hseb.util.fews.ohdmodels.ModelState;

public class LayCoefModelState extends ModelState
{

    private int _numberCarryOver = 0;;
    private String _unitType = OHDConstants.UNIT_METRIC;;
    private double[] _carryOver;
    public final static String FLOW_LAYER_TAG = "FLOW_LAYER#";

    public LayCoefModelState()
    {
        super();
    }

    public LayCoefModelState(final int whichMap)
    {
        super(whichMap);
    }

    /**
     * states of all models are stored in _statesMap. TatumModelState, LayCoefModelState could further override
     * ModelState toString(). Then this call writeState() will print out more information.
     */
    @Override
    public void writeState(final String outputStateFileName, final Logger logger) throws Exception
    {
        final BufferedWriter outFile = new BufferedWriter(new FileWriter(outputStateFileName));

        try
        {
            //print out states in alphabetic order
            outFile.write(getStringsFromState(new StringIntegerComparator(false), getStateMap()));
        }
        finally
        {
            outFile.close();
        }

        //reset the states map
        getStateMap().clear();
        logger.log(Logger.DEBUG, "Output the state to the file: " + outputStateFileName);
    }

    /*
     * (non-Javadoc)
     * @see ohd.hseb.util.fews.State#extractValuesFromMap()
     */
    @Override
    public void extractValuesFromMap() throws Exception
    {
        _carryOver = getCarryOverValuesByLayerMap();

    }

    /*
     * (non-Javadoc)
     * @see ohd.hseb.ohdmodels.ModelState#doCarryOverTransfer(ohd.hseb.ohdmodels.ModelParameters,
     * ohd.hseb.ohdmodels.ModelParameters)
     */
    @Override
    public void doCarryOverTransfer(final ModelParameters savedParams, final ModelParameters params) throws Exception
    {
        boolean errorUpperLimitFlowByLayer = false;
        final LayCoefModelParameters savedParameters = (LayCoefModelParameters)savedParams;
        final LayCoefModelParameters parameters = (LayCoefModelParameters)params;

        final int numberOfLayersOld = savedParameters.getNumberLayers();
        final int numberOfLayersNew = parameters.getNumberLayers();

        final double[] coefficientsByLayersOld = savedParameters.getLayerCoefficients();
        final double[] coefficientsByLayersNew = parameters.getLayerCoefficients();

        final double[] upperLimitFlowLayerOld = savedParameters.getUpperLimitFlowByLayer();
        final double[] upperLimitFlowLayerNew = parameters.getUpperLimitFlowByLayer();

        final double[] carryOverValuesNew = new double[numberOfLayersNew];
        final double[] carryOverValuesOld = this.getCarryOverValuesByLayer();

        for(int numberLayer = 0; numberLayer < upperLimitFlowLayerNew.length; numberLayer++)
        {
            if(numberLayer < carryOverValuesOld.length)
                carryOverValuesNew[numberLayer] = carryOverValuesOld[numberLayer];
        }

        double carryOverValue = 0.0;
        double diffNew = 0.0;
        double diffOld = 0.0;

        if(_logger.getPrintDebugInfo() > 0)
        {
            _logger.log(Logger.DEBUG, "LayCoefModelState before carry over transfer " + this.getStateMap());
        }

        // check to see if number of layers is the same
        if(numberOfLayersNew == numberOfLayersOld)
        {
            if(numberOfLayersNew != 1)
            {
                for(int numberLayer = 0; numberLayer < upperLimitFlowLayerNew.length; numberLayer++)
                {
                    if(Math.abs(upperLimitFlowLayerOld[numberLayer] - upperLimitFlowLayerNew[numberLayer]) > 0.0001)
                    {
                        errorUpperLimitFlowByLayer = true;
                    }
                }
                if(!errorUpperLimitFlowByLayer)
                {
                    //apply coefficient adjustment and end execution                    
                    for(int numberLayer = 0; numberLayer < numberOfLayersOld; numberLayer++)
                    {
                        if(coefficientsByLayersOld[numberLayer] <= 0.999)
                        {
                            carryOverValuesNew[numberLayer] = carryOverValuesOld[numberLayer]
                                * (1.0 - coefficientsByLayersNew[numberLayer])
                                / (1.0 - coefficientsByLayersOld[numberLayer]);
                        }
                    }
                    this.setCarryOverValuesToMap(carryOverValuesNew);
                    this.setCarryOverValuesByLayer(carryOverValuesNew);
                    this.setUnitType(OHDConstants.UNIT_METRIC);

                    if(_logger.getPrintDebugInfo() > 0)
                    {
                        _logger.log(Logger.DEBUG, "LayCoefModelState after carry over transfer " + this.getStateMap());
                    }
                    return;
                }
            }
        }
        if(numberOfLayersOld <= 1)
        {
            carryOverValuesNew[0] = carryOverValuesOld[0];
        }
        else
        {
            if(numberOfLayersNew > 1)
            {
                int layerB = 0;
                int layerT = 0;
                for(int layerNumber = 0; layerNumber < numberOfLayersNew; layerNumber++)
                {
                    if(layerB == numberOfLayersOld - 1)
                    {
                        break;
                    }
                    if(layerNumber < numberOfLayersNew - 1)
                    {
                        for(int layerNumberOld = layerB; layerNumberOld < numberOfLayersOld; layerNumberOld++)
                        {
                            if(layerNumberOld == numberOfLayersOld - 1)
                            {
                                layerT = layerNumberOld;
                                break;
                            }
                            if(layerNumberOld > 0)
                            {
                                if(upperLimitFlowLayerNew[layerNumber] <= upperLimitFlowLayerOld[layerNumberOld]
                                    && upperLimitFlowLayerNew[layerNumber] > upperLimitFlowLayerOld[layerNumberOld - 1])
                                {
                                    layerT = layerNumberOld;
                                    break;
                                }
                            }
                            else
                            {
                                if(upperLimitFlowLayerNew[layerNumber] <= upperLimitFlowLayerOld[0])
                                {
                                    layerT = layerNumberOld;
                                    break;
                                }
                            }
                        }// end for 
                    }
                    else
                    {
                        layerT = numberOfLayersOld - 1;
                    }
                    if(layerT == layerB)
                    {
                        if(layerB == 0)
                        {
                            diffOld = upperLimitFlowLayerOld[0];
                            if(layerNumber == 0)
                            {
                                diffNew = upperLimitFlowLayerNew[0];
                            }
                            else
                            {
                                diffNew = upperLimitFlowLayerNew[layerNumber] - upperLimitFlowLayerNew[layerNumber - 1];
                            }
                        }
                        else
                        {
                            diffOld = upperLimitFlowLayerOld[layerB] - upperLimitFlowLayerOld[layerB - 1];
                            diffNew = upperLimitFlowLayerNew[layerNumber] - upperLimitFlowLayerNew[layerNumber - 1];
                        }
                        if(coefficientsByLayersOld[layerT] <= 0.999)
                        {
                            carryOverValuesNew[layerNumber] = carryOverValuesOld[layerT] * diffNew
                                * (1.0 - coefficientsByLayersNew[layerNumber]) / diffOld
                                / (1.0 - coefficientsByLayersOld[layerT]);
                        }
                    }
                    else
                    {
                        carryOverValue = 0.0;
                        for(int layerNumberOld = layerB; layerNumberOld <= layerT; layerNumberOld++)
                        {
                            if(layerB == numberOfLayersOld - 1)
                            {
                                // end carryover transfer
                                this.setCarryOverValuesToMap(carryOverValuesNew);
                                this.setCarryOverValuesByLayer(carryOverValuesNew);
                                this.setUnitType(OHDConstants.UNIT_METRIC);
                                return;
                            }
                            if(layerNumberOld <= layerB)
                            {
                                if(layerB == 0)
                                {
                                    diffOld = upperLimitFlowLayerOld[0];
                                }
                                else
                                {
                                    diffOld = upperLimitFlowLayerOld[layerNumberOld] - upperLimitFlowLayerOld[layerNumberOld - 1];
                                }
                                if(layerNumber > 0)
                                {
                                    diffNew = upperLimitFlowLayerOld[layerNumberOld] - upperLimitFlowLayerNew[layerNumber - 1];
                                    if(coefficientsByLayersOld[layerNumberOld] <= 0.999)
                                    {
                                        carryOverValue = carryOverValue + carryOverValuesOld[layerNumberOld]
                                            * (1.0 - coefficientsByLayersNew[layerNumber])
                                            / (1.0 - coefficientsByLayersOld[layerNumberOld]) * diffNew / diffOld;
                                    }
                                }
                                else
                                {
                                    if(coefficientsByLayersOld[layerNumberOld] <= 0.999)
                                    {
                                        carryOverValue = carryOverValue + carryOverValuesOld[0]
                                            * (1.0 - coefficientsByLayersNew[0]) / (1.0 - coefficientsByLayersOld[layerNumberOld]);
                                    }
                                }
                            }
                            else
                            {
                                if(layerNumberOld == layerT)
                                {
                                    if(layerNumber < numberOfLayersNew - 1)
                                    {
                                        if(layerNumberOld < numberOfLayersOld - 1)
                                        {
                                            diffOld = upperLimitFlowLayerOld[layerNumberOld] - upperLimitFlowLayerOld[layerNumberOld - 1];
                                            diffNew = upperLimitFlowLayerNew[layerNumber]
                                                - upperLimitFlowLayerOld[layerNumberOld - 1];

                                            if(coefficientsByLayersOld[layerNumberOld] <= 0.999)
                                            {
                                                carryOverValue = carryOverValue + carryOverValuesOld[layerNumberOld]
                                                    * (1.0 - coefficientsByLayersNew[layerNumber]) * diffNew
                                                    / (1.0 - coefficientsByLayersOld[layerNumberOld]) / diffOld;
                                            }
                                        }
                                        else
                                        {
                                            if(coefficientsByLayersOld[layerNumberOld] <= 0.999)
                                            {
                                                carryOverValue = carryOverValue + carryOverValuesOld[layerNumber]
                                                    * (1.0 - coefficientsByLayersNew[layerNumber])
                                                    / (1.0 - coefficientsByLayersOld[layerNumberOld]);
                                            }
                                        }
                                    }
                                    else
                                    {
                                        if(coefficientsByLayersOld[layerNumberOld] <= 0.999)
                                        {
                                            carryOverValue = carryOverValue + carryOverValuesOld[layerNumberOld]
                                                * (1.0 - coefficientsByLayersNew[layerNumber])
                                                / (1.0 - coefficientsByLayersOld[layerNumberOld]);
                                        }
                                    }
                                }
                                else
                                {
                                    if(coefficientsByLayersOld[layerNumberOld] <= 0.999)
                                    {
                                        carryOverValue = carryOverValue + carryOverValuesOld[layerNumberOld]
                                            * (1.0 - coefficientsByLayersNew[layerNumber])
                                            / (1.0 - coefficientsByLayersOld[layerNumberOld]);
                                    }
                                }
                            }
                            carryOverValuesNew[layerNumber] = carryOverValue;
                        } // end for loop
                    } // end else

                    layerB = layerT;
                } // end for loop
            }
            else
            {
                carryOverValue = 0.0;
                for(int layerNumber = 0; layerNumber < numberOfLayersOld; layerNumber++)
                {
                    if(coefficientsByLayersOld[layerNumber] <= 0.999)
                    {
                        carryOverValue = carryOverValue + carryOverValuesOld[layerNumber]
                            * (1 - coefficientsByLayersNew[0]) / (1 - coefficientsByLayersOld[layerNumber]);
                    }
                }
                carryOverValuesNew[0] = carryOverValue;
            }
        }

        this.setCarryOverValuesToMap(carryOverValuesNew);
        this.setCarryOverValuesByLayer(carryOverValuesNew);
        this.setUnitType(OHDConstants.UNIT_METRIC);

        if(_logger.getPrintDebugInfo() > 0)
        {
            _logger.log(Logger.DEBUG, "LayCoefModelState after carry over transfer " + this.getStateMap());
        }
    }

    /**
     * @return the numberLayers
     */
    public int getNumberCarryOver()
    {
        return _numberCarryOver;
    }

    /**
     * @param numberLayers the numberLayers to set
     */
    public void setNumberCarryOver(final int numberLayers)
    {
        _numberCarryOver = numberLayers;
    }

    /**
     * @return the unitType
     */
    public String getUnitType()
    {
        return _unitType;
    }

    /**
     * @param unitType the unitType to set
     */
    public void setUnitType(final String unitType)
    {
        _unitType = unitType;
    }

    /**
     * @param carryOverList the carryOverList to set
     */
    public void setCarryOverValuesByLayer(final double[] carryOver)
    {
        _carryOver = carryOver;
    }

    public double[] getCarryOverValuesByLayer() throws Exception
    {
        return this._carryOver;
    }

    /**
     * @param layerId
     * @param tatumCarryOverValues
     */
    public void setCarryOverValuesToMap(final double[] carryOverValues)
    {
        this.getStateMap().clear();
        super.setStateValue(OHDConstants.UNIT_TAG, this.getUnitType());
        for(int numberCarryOver = 0; numberCarryOver < carryOverValues.length; numberCarryOver++)
        {
            super.setStateValue(FLOW_LAYER_TAG + numberCarryOver, carryOverValues[numberCarryOver]);
        }

    }

    /**
     * get The carry over values from the state object.
     * 
     * @return
     * @throws Exception
     */
    private double[] getCarryOverValuesByLayerMap() throws Exception
    {
        final double[] carryOverValues = new double[_numberCarryOver];

        for(int numberCarryOver = 0; numberCarryOver < _numberCarryOver; numberCarryOver++)
        {
            carryOverValues[numberCarryOver] = getDoubleDataState(FLOW_LAYER_TAG + numberCarryOver);
        }
        return carryOverValues;

    }

    public void validateState(final Parameters params) throws Exception
    {

        final LayCoefModelParameters layCoefParams = (LayCoefModelParameters)params;
        this.setNumberCarryOver(layCoefParams.getLayerCoefficients().length);
        this.extractValuesFromMap();
    }

}
