package ohd.hseb.ohdmodels.muskrout;

import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.ModelException;
import ohd.hseb.util.fews.ohdmodels.ModelParameters;

/**
 * @author champ
 */
final public class MuskroutModelParameters extends ModelParameters
{
    // card 1
    public final static String GENERAL_INFO_TAG = "GENERAL_INFO";
    public final static String TS_INFLOW_ID_TAG = "TS_INFLOW_ID";
    public final static String TS_INFLOW_TYPE_TAG = "TS_INFLOW_TYPE";
    public final static String TS_INFLOW_TIMESTEP_TAG = "TS_INFLOW_TIMESTEP";
    public final static String TS_OUTFLOW_ID_TAG = "TS_OUTFLOW_ID";
    public final static String TS_OUTFLOW_TYPE_TAG = "TS_OUTFLOW_TYPE";
    public final static String TS_OUTFLOW_TIMESTEP_TAG = "TS_OUTFLOW_TIMESTEP";
    public final static String K_PARAMETER_TAG = "K_PARAMETER";
    public final static String X_PARAMETER_TAG = "X_PARAMETER";
    public final static String CARRYOVER_FLAG_TAG = "CARRYOVER_FLAG";
    // card 2
//	public final static String Inflow_Carryover = "INFLOW_CARRYOVER";
//    public final static String Outflow_Carryover = "OUTFLOW_CARRYOVER";

    private String _generalInfo;
    private String _inflowTimeSerieId;
    private String _inflowTimeSerieDataType;
    private int _inflowTimeSerieTimeStep;
    private String _outflowTimeSerieId;
    private String _outflowTimeSerieDataType;
    private int _outflowTimeSerieTimeStep;
    private double _kParameter;
    private double _xParameter;
    private boolean _carryOver;

    /**
     * @return the generalInfo
     */
    public String getGeneralInfo()
    {
        return _generalInfo;
    }

    /**
     * @param generalInfo the generalInfo to set
     */
    public void setGeneralInfo(final String generalInfo)
    {
        _generalInfo = generalInfo;
    }

    /**
     * @return the inflowTimeSerieId
     */
    public String getInflowTimeSerieId()
    {
        return _inflowTimeSerieId;
    }

    /**
     * @param inflowTimeSerieId the inflowTimeSerieId to set
     */
    public void setInflowTimeSerieId(final String inflowTimeSerieId)
    {
        _inflowTimeSerieId = inflowTimeSerieId;
    }

    /**
     * @return the inflowTimeSerieDataType
     */
    public String getInflowTimeSerieDataType()
    {
        return _inflowTimeSerieDataType;
    }

    /**
     * @param inflowTimeSerieDataType the inflowTimeSerieDataType to set
     */
    public void setInflowTimeSerieDataType(final String inflowTimeSerieDataType)
    {
        _inflowTimeSerieDataType = inflowTimeSerieDataType;
    }

    /**
     * @return the inflowTimeSerieTimeStep
     */
    public int getInflowTimeSerieTimeStep()
    {
        return _inflowTimeSerieTimeStep;
    }

    /**
     * @param inflowTimeSerieTimeStep the inflowTimeSerieTimeStep to set
     */
    public void setInflowTimeSerieTimeStep(final int inflowTimeSerieTimeStep)
    {
        _inflowTimeSerieTimeStep = inflowTimeSerieTimeStep;
    }

    /**
     * @return the outflowTimeSerieId
     */
    public String getOutflowTimeSerieId()
    {
        return _outflowTimeSerieId;
    }

    /**
     * @param outflowTimeSerieId the outflowTimeSerieId to set
     */
    public void setOutflowTimeSerieId(final String outflowTimeSerieId)
    {
        _outflowTimeSerieId = outflowTimeSerieId;
    }

    /**
     * @return the outflowTimeSerieDataType
     */
    public String getOutflowTimeSerieDataType()
    {
        return _outflowTimeSerieDataType;
    }

    /**
     * @param outflowTimeSerieDataType the outflowTimeSerieDataType to set
     */
    public void setOutflowTimeSerieDataType(final String outflowTimeSerieDataType)
    {
        _outflowTimeSerieDataType = outflowTimeSerieDataType;
    }

    /**
     * @return the outflowTimeSerieTimeStep
     */
    public int getOutflowTimeSerieTimeStep()
    {
        return _outflowTimeSerieTimeStep;
    }

    /**
     * @param outflowTimeSerieTimeStep the outflowTimeSerieTimeStep to set
     */
    public void setOutflowTimeSerieTimeStep(final int outflowTimeSerieTimeStep)
    {
        _outflowTimeSerieTimeStep = outflowTimeSerieTimeStep;
    }

    /**
     * @return the kParameter
     */
    public double getkParameter()
    {
        return _kParameter;
    }

    /**
     * @param kParameter the kParameter to set
     */
    public void setkParameter(final double kParameter)
    {
        _kParameter = kParameter;
    }

    /**
     * @return the xParameter
     */
    public double getxParameter()
    {
        return _xParameter;
    }

    /*
     * (non-Javadoc)
     * @see ohd.hseb.ohdmodels.ModelParameters#extractValuesFromMap()
     */
    @Override
    protected void extractValuesFromMap() throws Exception
    {
        _generalInfo = getStringDataParameter(GENERAL_INFO_TAG);
        _inflowTimeSerieId = getStringDataParameter(TS_INFLOW_ID_TAG);
        _inflowTimeSerieDataType = getStringDataParameter(TS_INFLOW_TYPE_TAG);
        _inflowTimeSerieTimeStep = getIntDataParameter(TS_INFLOW_TIMESTEP_TAG);
        _outflowTimeSerieId = getStringDataParameter(TS_OUTFLOW_ID_TAG);
        _outflowTimeSerieDataType = getStringDataParameter(TS_OUTFLOW_TYPE_TAG);
        _outflowTimeSerieTimeStep = getIntDataParameter(TS_OUTFLOW_TIMESTEP_TAG);
//        _carryOver = getIntDataParameter(CARRYOVER_FLAG_TAG) == 1 ? true : false;
        _kParameter = super.getDoubleDataParameter(K_PARAMETER_TAG);
        _xParameter = super.getDoubleDataParameter(X_PARAMETER_TAG);

    }

    /**
     * @param xParameter the xParameter to set
     */
    public void setxParameter(final double xParameter)
    {
        _xParameter = xParameter;
    }

    /**
     * @return the carryOver
     */
    public boolean isCarryOver()
    {
        return _carryOver;
    }

    /**
     * @param carryOver the carryOver to set
     */
    public void setCarryOver(final boolean carryOver)
    {
        _carryOver = carryOver;
    }

    /**
     * Validate that required parameters are not empty.
     * 
     * @throws ModelException
     * @throws Exception
     */
    public void validateParams() throws ModelException, Exception
    {
        String errorMessage;

        if(_generalInfo.isEmpty())
        {
            errorMessage = GENERAL_INFO_TAG + " parameter is absent.";
            throw new ModelException(errorMessage);
        }
        if(_inflowTimeSerieId.isEmpty())
        {
            errorMessage = TS_INFLOW_ID_TAG + " parameter is absent.";
            throw new ModelException(errorMessage);
        }

        if(_inflowTimeSerieDataType.isEmpty())
        {
            errorMessage = TS_INFLOW_TYPE_TAG + " parameter is absent.";
            throw new ModelException(errorMessage);
        }
        if(_outflowTimeSerieId.isEmpty())
        {
            errorMessage = TS_OUTFLOW_ID_TAG + " parameter is absent.";
            throw new ModelException(errorMessage);
        }
        if(_outflowTimeSerieDataType.isEmpty())
        {
            errorMessage = TS_OUTFLOW_TYPE_TAG + " parameter is absent.";
            throw new ModelException(errorMessage);
        }
        //if reach here, validation is successful
        _logger.log(Logger.DEBUG, "RsnwelevModelParameters has been validated!");

    }

}